/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.filter.IFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;

public abstract class SecondaryIndexSearcher {
    protected SecondaryIndexManager indexManager;
    protected Set<ByteBuffer> columns;
    protected ColumnFamilyStore baseCfs;

    public SecondaryIndexSearcher(SecondaryIndexManager indexManager, Set<ByteBuffer> columns) {
        this.indexManager = indexManager;
        this.columns = columns;
        this.baseCfs = indexManager.baseCfs;
    }

    public static boolean satisfies(ColumnFamily data, IndexClause clause, IndexExpression first) {
        for (IndexExpression expression : clause.expressions) {
            IColumn column = data.getColumn(expression.column_name);
            if (column == null) {
                return false;
            }
            int v = data.metadata().getValueValidator(expression.column_name).compare(column.value(), expression.value);
            if (SecondaryIndexSearcher.satisfies(v, expression.op)) continue;
            return false;
        }
        return true;
    }

    public static boolean satisfies(int comparison, IndexOperator op) {
        switch (op) {
            case EQ: {
                return comparison == 0;
            }
            case GTE: {
                return comparison >= 0;
            }
            case GT: {
                return comparison > 0;
            }
            case LTE: {
                return comparison <= 0;
            }
            case LT: {
                return comparison < 0;
            }
        }
        throw new IllegalStateException();
    }

    public NamesQueryFilter getExtraFilter(IndexClause clause) {
        TreeSet<ByteBuffer> columns = new TreeSet<ByteBuffer>(this.baseCfs.getComparator());
        for (IndexExpression expr : clause.expressions) {
            columns.add(expr.column_name);
        }
        return new NamesQueryFilter(columns);
    }

    public abstract List<Row> search(IndexClause var1, AbstractBounds var2, IFilter var3);
}

