/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.UUID;
import org.apache.cassandra.cql.jdbc.JdbcDate;
import org.apache.cassandra.cql.jdbc.JdbcUUID;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.commons.lang.time.DateUtils;

public class UUIDType
extends AbstractType<UUID> {
    public static final UUIDType instance = new UUIDType();

    UUIDType() {
    }

    @Override
    public int compare(ByteBuffer b1, ByteBuffer b2) {
        int c;
        int v2;
        if (b1 == null || b1.remaining() < 16) {
            return b2 == null || b2.remaining() < 16 ? 0 : -1;
        }
        if (b2 == null || b2.remaining() < 16) {
            return 1;
        }
        int s1 = b1.position();
        int s2 = b2.position();
        int v1 = b1.get(s1 + 6) >> 4 & 0xF;
        if (v1 != (v2 = b2.get(s2 + 6) >> 4 & 0xF)) {
            return v1 - v2;
        }
        if (v1 == 1 && (c = UUIDType.compareTimestampBytes(b1, b2)) != 0) {
            return c;
        }
        for (int i = 0; i < 16; ++i) {
            int c2 = (b1.get(s1 + i) & 0xFF) - (b2.get(s2 + i) & 0xFF);
            if (c2 == 0) continue;
            return c2;
        }
        return 0;
    }

    private static int compareTimestampBytes(ByteBuffer o1, ByteBuffer o2) {
        int o1Pos = o1.position();
        int o2Pos = o2.position();
        int d = (o1.get(o1Pos + 6) & 0xF) - (o2.get(o2Pos + 6) & 0xF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos + 7) & 0xFF) - (o2.get(o2Pos + 7) & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos + 4) & 0xFF) - (o2.get(o2Pos + 4) & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos + 5) & 0xFF) - (o2.get(o2Pos + 5) & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos) & 0xFF) - (o2.get(o2Pos) & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos + 1) & 0xFF) - (o2.get(o2Pos + 1) & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos + 2) & 0xFF) - (o2.get(o2Pos + 2) & 0xFF);
        if (d != 0) {
            return d;
        }
        return (o1.get(o1Pos + 3) & 0xFF) - (o2.get(o2Pos + 3) & 0xFF);
    }

    @Override
    public UUID compose(ByteBuffer bytes) {
        return JdbcUUID.instance.compose(bytes);
    }

    @Override
    public void validate(ByteBuffer bytes) {
        if (bytes.remaining() != 0 && bytes.remaining() != 16) {
            throw new MarshalException("UUIDs must be exactly 16 bytes");
        }
    }

    @Override
    public String getString(ByteBuffer bytes) {
        try {
            return JdbcUUID.instance.getString(bytes);
        }
        catch (org.apache.cassandra.cql.jdbc.MarshalException e) {
            throw new MarshalException(e.getMessage());
        }
    }

    @Override
    public ByteBuffer decompose(UUID value) {
        return ByteBuffer.wrap(UUIDGen.decompose(value));
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        ByteBuffer idBytes = null;
        if (TimeUUIDType.regexPattern.matcher(source).matches()) {
            try {
                UUID uuid = UUID.fromString(source);
                idBytes = ByteBuffer.wrap(UUIDGen.decompose(uuid));
            }
            catch (IllegalArgumentException e) {
                throw new MarshalException(String.format("unable to make UUID from '%s'", source), e);
            }
        }
        if (source.toLowerCase().equals("now")) {
            idBytes = ByteBuffer.wrap(UUIDGen.decompose(UUIDGen.makeType1UUIDFromHost(FBUtilities.getBroadcastAddress())));
        } else {
            if (source.matches("^\\d+$")) {
                try {
                    idBytes = ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes(Long.parseLong(source)));
                }
                catch (NumberFormatException e) {
                    throw new MarshalException(String.format("unable to make version 1 UUID from '%s'", source), e);
                }
            }
            try {
                long timestamp = DateUtils.parseDate((String)source, (String[])JdbcDate.iso8601Patterns).getTime();
                idBytes = ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes(timestamp));
            }
            catch (ParseException e1) {
                throw new MarshalException(String.format("unable to coerce '%s' to version 1 UUID", source), e1);
            }
        }
        return idBytes;
    }
}

