/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnIndexer;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.columniterator.ICountableColumnIterator;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.PrecompactedRow;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.IIterableColumns;
import org.apache.cassandra.utils.IMergeIterator;
import org.apache.cassandra.utils.MergeIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazilyCompactedRow
extends AbstractCompactedRow
implements IIterableColumns {
    private static Logger logger = LoggerFactory.getLogger(LazilyCompactedRow.class);
    private final List<? extends ICountableColumnIterator> rows;
    private final CompactionController controller;
    private final boolean shouldPurge;
    private final DataOutputBuffer headerBuffer;
    private ColumnFamily emptyColumnFamily;
    private Reducer reducer;
    private int columnCount;
    private long maxTimestamp;
    private long columnSerializedSize;
    private boolean closed;

    public LazilyCompactedRow(CompactionController controller, List<? extends ICountableColumnIterator> rows) {
        super(rows.get(0).getKey());
        this.rows = rows;
        this.controller = controller;
        this.shouldPurge = controller.shouldPurge(this.key);
        for (ICountableColumnIterator iCountableColumnIterator : rows) {
            ColumnFamily cf = iCountableColumnIterator.getColumnFamily();
            if (this.emptyColumnFamily == null) {
                this.emptyColumnFamily = cf;
                continue;
            }
            this.emptyColumnFamily.delete(cf);
        }
        this.headerBuffer = new DataOutputBuffer();
        ColumnIndexer.serialize(this, (DataOutput)this.headerBuffer);
        this.columnCount = this.reducer == null ? 0 : this.reducer.size;
        this.columnSerializedSize = this.reducer == null ? 0L : this.reducer.serializedSize;
        this.maxTimestamp = this.reducer == null ? Long.MIN_VALUE : this.reducer.maxTimestampSeen;
        this.reducer = null;
    }

    @Override
    public long write(DataOutput out) throws IOException {
        long secondPassColumnSize;
        assert (!this.closed);
        DataOutputBuffer clockOut = new DataOutputBuffer();
        ColumnFamily.serializer().serializeCFInfo(this.emptyColumnFamily, clockOut);
        long dataSize = (long)(this.headerBuffer.getLength() + clockOut.getLength()) + this.columnSerializedSize;
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("header / clock / column sizes are %s / %s / %s", this.headerBuffer.getLength(), clockOut.getLength(), this.columnSerializedSize));
        }
        assert (dataSize > 0L);
        out.writeLong(dataSize);
        out.write(this.headerBuffer.getData(), 0, this.headerBuffer.getLength());
        out.write(clockOut.getData(), 0, clockOut.getLength());
        out.writeInt(this.columnCount);
        for (IColumn column : this) {
            this.emptyColumnFamily.getColumnSerializer().serialize(column, out);
        }
        long l = secondPassColumnSize = this.reducer == null ? 0L : this.reducer.serializedSize;
        assert (secondPassColumnSize == this.columnSerializedSize) : "originally calculated column size of " + this.columnSerializedSize + " but now it is " + secondPassColumnSize;
        this.close();
        return dataSize;
    }

    @Override
    public void update(MessageDigest digest) {
        assert (!this.closed);
        DataOutputBuffer out = new DataOutputBuffer();
        try {
            ColumnFamily.serializer().serializeCFInfo(this.emptyColumnFamily, out);
            out.writeInt(this.columnCount);
            digest.update(out.getData(), 0, out.getLength());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        Iterator<IColumn> iter = this.iterator();
        while (iter.hasNext()) {
            iter.next().updateDigest(digest);
        }
        this.close();
    }

    @Override
    public boolean isEmpty() {
        boolean cfIrrelevant = this.shouldPurge ? ColumnFamilyStore.removeDeletedCF(this.emptyColumnFamily, this.controller.gcBefore) == null : !this.emptyColumnFamily.isMarkedForDelete();
        return cfIrrelevant && this.columnCount == 0;
    }

    @Override
    public int getEstimatedColumnCount() {
        int n = 0;
        for (ICountableColumnIterator iCountableColumnIterator : this.rows) {
            n += iCountableColumnIterator.getColumnCount();
        }
        return n;
    }

    @Override
    public AbstractType getComparator() {
        return this.emptyColumnFamily.getComparator();
    }

    @Override
    public Iterator<IColumn> iterator() {
        for (ICountableColumnIterator iCountableColumnIterator : this.rows) {
            iCountableColumnIterator.reset();
        }
        this.reducer = new Reducer();
        IMergeIterator<IColumn, IColumn> iter = MergeIterator.get(this.rows, this.getComparator().columnComparator, this.reducer);
        return Iterators.filter(iter, (Predicate)Predicates.notNull());
    }

    @Override
    public int columnCount() {
        return this.columnCount;
    }

    @Override
    public long maxTimestamp() {
        return this.maxTimestamp;
    }

    private void close() {
        for (ICountableColumnIterator iCountableColumnIterator : this.rows) {
            try {
                iCountableColumnIterator.close();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
        this.closed = true;
    }

    private class Reducer
    extends MergeIterator.Reducer<IColumn, IColumn> {
        ColumnFamily container;
        long serializedSize;
        int size;
        long maxTimestampSeen;

        private Reducer() {
            this.container = LazilyCompactedRow.this.emptyColumnFamily.cloneMeShallow();
            this.serializedSize = 4L;
            this.size = 0;
            this.maxTimestampSeen = Long.MIN_VALUE;
        }

        @Override
        public void reduce(IColumn current) {
            this.container.addColumn(current);
        }

        @Override
        protected IColumn getReduced() {
            ColumnFamily purged = PrecompactedRow.removeDeletedAndOldShards(LazilyCompactedRow.this.key, LazilyCompactedRow.this.shouldPurge, LazilyCompactedRow.this.controller, this.container);
            if (purged == null || !purged.iterator().hasNext()) {
                this.container.clear();
                return null;
            }
            IColumn reduced = purged.iterator().next();
            this.container.clear();
            this.serializedSize += (long)reduced.serializedSize();
            ++this.size;
            this.maxTimestampSeen = Math.max(this.maxTimestampSeen, reduced.maxTimestamp());
            return reduced;
        }
    }
}

