/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.IntervalTree;

import java.util.LinkedList;
import java.util.List;
import org.apache.cassandra.utils.IntervalTree.Interval;
import org.apache.cassandra.utils.IntervalTree.IntervalNode;

public class IntervalTree<T> {
    private final IntervalNode head;

    public IntervalTree() {
        this.head = null;
    }

    public IntervalTree(List<Interval> intervals) {
        this.head = new IntervalNode(intervals);
    }

    public Comparable max() {
        return this.head.v_max;
    }

    public Comparable min() {
        return this.head.v_min;
    }

    public List<T> search(Interval<T> searchInterval) {
        LinkedList retlist = new LinkedList();
        this.searchInternal(this.head, searchInterval, retlist);
        return retlist;
    }

    protected void searchInternal(IntervalNode node, Interval<T> searchInterval, List<T> retList) {
        if (null == this.head) {
            return;
        }
        if (null == node || node.v_pt == null) {
            return;
        }
        if (searchInterval.contains(node.v_pt)) {
            for (Interval interval : node.intersects_left) {
                retList.add(interval.Data);
            }
            this.searchInternal(node.left, searchInterval, retList);
            this.searchInternal(node.right, searchInterval, retList);
            return;
        }
        if (node.v_pt.compareTo(searchInterval.min) < 0) {
            for (Interval interval : node.intersects_right) {
                if (interval.max.compareTo(searchInterval.min) < 0) break;
                retList.add(interval.Data);
            }
            this.searchInternal(node.right, searchInterval, retList);
            return;
        }
        if (node.v_pt.compareTo(searchInterval.max) > 0) {
            for (Interval interval : node.intersects_left) {
                if (interval.min.compareTo(searchInterval.max) > 0) break;
                retList.add(interval.Data);
            }
            this.searchInternal(node.left, searchInterval, retList);
            return;
        }
    }
}

