/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.client;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.hadoop.conf.Configuration;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RingCache {
    private static final Logger logger_ = LoggerFactory.getLogger(RingCache.class);
    private final IPartitioner<?> partitioner;
    private final Configuration conf;
    private Multimap<Range, InetAddress> rangeMap;

    public RingCache(Configuration conf) throws IOException {
        this.conf = conf;
        this.partitioner = ConfigHelper.getPartitioner(conf);
        this.refreshEndpointMap();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refreshEndpointMap() {
        try {
            Cassandra.Client client = ConfigHelper.getClientFromAddressList(this.conf);
            List ring = client.describe_ring(ConfigHelper.getOutputKeyspace(this.conf));
            this.rangeMap = ArrayListMultimap.create();
            for (TokenRange range : ring) {
                Token left = this.partitioner.getTokenFactory().fromString(range.start_token);
                Token right = this.partitioner.getTokenFactory().fromString(range.end_token);
                Range r = new Range(left, right, this.partitioner);
                for (String host : range.endpoints) {
                    try {
                        this.rangeMap.put((Object)r, (Object)InetAddress.getByName(host));
                    }
                    catch (UnknownHostException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                continue;
                return;
            }
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (TException e) {
            logger_.debug("Error contacting seed list" + ConfigHelper.getInitialAddress(this.conf) + " " + e.getMessage());
        }
    }

    public List<InetAddress> getEndpoint(Range range) {
        return (List)this.rangeMap.get((Object)range);
    }

    public List<InetAddress> getEndpoint(ByteBuffer key) {
        return this.getEndpoint(this.getRange(key));
    }

    public Range getRange(ByteBuffer key) {
        Object t = this.partitioner.getToken(key);
        for (Range range : this.rangeMap.keySet()) {
            if (!range.contains((Token)t)) continue;
            return range;
        }
        throw new RuntimeException("Invalid token information returned by describe_ring: " + this.rangeMap);
    }
}

