/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBroadcaster
implements IEndpointStateChangeSubscriber {
    static final int BROADCAST_INTERVAL = 60000;
    public static final LoadBroadcaster instance = new LoadBroadcaster();
    private static final Logger logger_ = LoggerFactory.getLogger(LoadBroadcaster.class);
    private Map<InetAddress, Double> loadInfo_ = new HashMap<InetAddress, Double>();

    private LoadBroadcaster() {
        Gossiper.instance.register(this);
    }

    @Override
    public void onChange(InetAddress endpoint, ApplicationState state, VersionedValue value) {
        if (state != ApplicationState.LOAD) {
            return;
        }
        this.loadInfo_.put(endpoint, Double.valueOf(value.value));
    }

    @Override
    public void onJoin(InetAddress endpoint, EndpointState epState) {
        VersionedValue localValue = epState.getApplicationState(ApplicationState.LOAD);
        if (localValue != null) {
            this.onChange(endpoint, ApplicationState.LOAD, localValue);
        }
    }

    @Override
    public void onAlive(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onDead(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onRestart(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onRemove(InetAddress endpoint) {
        this.loadInfo_.remove(endpoint);
    }

    public Map<InetAddress, Double> getLoadInfo() {
        return this.loadInfo_;
    }

    public void startBroadcasting() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (logger_.isDebugEnabled()) {
                    logger_.debug("Disseminating load info ...");
                }
                Gossiper.instance.addLocalApplicationState(ApplicationState.LOAD, StorageService.instance.valueFactory.load(StorageService.instance.getLoad()));
            }
        };
        StorageService.scheduledTasks.scheduleWithFixedDelay(runnable, 2000L, 60000L, TimeUnit.MILLISECONDS);
    }
}

