/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.io.sstable.SSTable;

public class IndexSummary {
    private ArrayList<KeyPosition> indexPositions;
    private long keysWritten = 0L;

    public IndexSummary(long expectedKeys) {
        long expectedEntries = expectedKeys / (long)DatabaseDescriptor.getIndexInterval().intValue();
        if (expectedEntries > Integer.MAX_VALUE) {
            throw new RuntimeException("Cannot use index_interval of " + DatabaseDescriptor.getIndexInterval() + " with " + expectedKeys + " (expected) keys.");
        }
        this.indexPositions = new ArrayList((int)expectedEntries);
    }

    public void incrementRowid() {
        ++this.keysWritten;
    }

    public boolean shouldAddEntry() {
        return this.keysWritten % (long)DatabaseDescriptor.getIndexInterval().intValue() == 0L;
    }

    public void addEntry(DecoratedKey<?> key, long indexPosition) {
        this.indexPositions.add(new KeyPosition(SSTable.getMinimalKey(key), indexPosition));
    }

    public void maybeAddEntry(DecoratedKey<?> decoratedKey, long indexPosition) {
        if (this.shouldAddEntry()) {
            this.addEntry(decoratedKey, indexPosition);
        }
        this.incrementRowid();
    }

    public List<KeyPosition> getIndexPositions() {
        return this.indexPositions;
    }

    public void complete() {
        this.indexPositions.trimToSize();
    }

    public static final class KeyPosition
    implements Comparable<KeyPosition> {
        public final DecoratedKey<?> key;
        public final long indexPosition;

        public KeyPosition(DecoratedKey<?> key, long indexPosition) {
            this.key = key;
            this.indexPosition = indexPosition;
        }

        @Override
        public int compareTo(KeyPosition kp) {
            return this.key.compareTo(kp.key);
        }

        public String toString() {
            return this.key + ":" + this.indexPosition;
        }
    }
}

