/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.base.Objects;
import java.io.File;
import java.util.StringTokenizer;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.utils.Pair;

public class Descriptor {
    public static final String LEGACY_VERSION = "a";
    public static final String CURRENT_VERSION = "hc";
    public final File directory;
    public final String version;
    public final String ksname;
    public final String cfname;
    public final int generation;
    public final boolean temporary;
    private final int hashCode;
    public final boolean hasStringsInBloomFilter;
    public final boolean hasIntRowSize;
    public final boolean hasEncodedKeys;
    public final boolean isLatestVersion;
    public final boolean usesOldBloomFilter;
    public final boolean metadataIncludesReplayPosition;
    public final boolean tracksMaxTimestamp;
    public final boolean hasCompressionRatio;
    public final boolean hasPartitioner;

    public Descriptor(File directory, String ksname, String cfname, int generation, boolean temp) {
        this(CURRENT_VERSION, directory, ksname, cfname, generation, temp);
    }

    public Descriptor(String version, File directory, String ksname, String cfname, int generation, boolean temp) {
        assert (version != null && directory != null && ksname != null && cfname != null);
        this.version = version;
        this.directory = directory;
        this.ksname = ksname;
        this.cfname = cfname;
        this.generation = generation;
        this.temporary = temp;
        this.hashCode = Objects.hashCode((Object[])new Object[]{directory, generation, ksname, cfname});
        this.hasStringsInBloomFilter = version.compareTo("c") < 0;
        this.hasIntRowSize = version.compareTo("d") < 0;
        this.hasEncodedKeys = version.compareTo("e") < 0;
        this.usesOldBloomFilter = version.compareTo("f") < 0;
        this.metadataIncludesReplayPosition = version.compareTo("g") >= 0;
        this.tracksMaxTimestamp = version.compareTo("h") >= 0;
        this.hasCompressionRatio = version.compareTo("hb") >= 0;
        this.hasPartitioner = version.compareTo(CURRENT_VERSION) >= 0;
        this.isLatestVersion = version.compareTo(CURRENT_VERSION) == 0;
    }

    public String filenameFor(Component component) {
        return this.filenameFor(component.name());
    }

    private String baseFilename() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.directory).append(File.separatorChar);
        buff.append(this.cfname).append('-');
        if (this.temporary) {
            buff.append("tmp").append('-');
        }
        if (!LEGACY_VERSION.equals(this.version)) {
            buff.append(this.version).append('-');
        }
        buff.append(this.generation);
        return buff.toString();
    }

    public String filenameFor(String suffix) {
        return this.baseFilename() + '-' + suffix;
    }

    public static Descriptor fromFilename(String filename) {
        File file = new File(filename);
        assert (file.getParentFile() != null) : "Filename must include parent directory.";
        return (Descriptor)Descriptor.fromFilename((File)file.getParentFile(), (String)file.getName()).left;
    }

    public static Pair<Descriptor, String> fromFilename(File directory, String name) {
        String ksname = Descriptor.extractKeyspaceName(directory);
        StringTokenizer st = new StringTokenizer(name, String.valueOf('-'));
        String cfname = st.nextToken();
        String nexttok = st.nextToken();
        boolean temporary = false;
        if (nexttok.equals("tmp")) {
            temporary = true;
            nexttok = st.nextToken();
        }
        String version = LEGACY_VERSION;
        if (Descriptor.versionValidate(nexttok)) {
            version = nexttok;
            nexttok = st.nextToken();
        }
        int generation = Integer.parseInt(nexttok);
        String component = st.nextToken();
        return new Pair<Descriptor, String>(new Descriptor(version, directory, ksname, cfname, generation, temporary), component);
    }

    public static String extractKeyspaceName(File directory) {
        if (Descriptor.isSnapshotInPath(directory)) {
            return directory.getParentFile().getParentFile().getName();
        }
        return directory.getName();
    }

    private static boolean isSnapshotInPath(File directory) {
        for (File curDirectory = directory; curDirectory != null; curDirectory = curDirectory.getParentFile()) {
            if (!curDirectory.getName().equals("snapshots")) continue;
            return true;
        }
        return false;
    }

    public Descriptor asTemporary(boolean temporary) {
        return new Descriptor(this.version, this.directory, this.ksname, this.cfname, this.generation, temporary);
    }

    static boolean versionValidate(String ver) {
        return ver != null && ver.matches("[a-z]+");
    }

    public boolean isCompatible() {
        return this.version.charAt(0) <= CURRENT_VERSION.charAt(0);
    }

    public boolean isStreamCompatible() {
        return this.isCompatible() && this.version.charAt(0) >= 'f';
    }

    public String toString() {
        return this.baseFilename();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Descriptor)) {
            return false;
        }
        Descriptor that = (Descriptor)o;
        return that.directory.equals(this.directory) && that.generation == this.generation && that.ksname.equals(this.ksname) && that.cfname.equals(this.cfname);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static final class TempState
    extends Enum<TempState> {
        public static final /* enum */ TempState LIVE = new TempState();
        public static final /* enum */ TempState TEMP = new TempState();
        public static final /* enum */ TempState ANY = new TempState();
        private static final /* synthetic */ TempState[] $VALUES;

        public static TempState[] values() {
            return (TempState[])$VALUES.clone();
        }

        public static TempState valueOf(String name) {
            return Enum.valueOf(TempState.class, name);
        }

        boolean isMatch(Descriptor descriptor) {
            assert (descriptor != null);
            if (ANY == this) {
                return true;
            }
            return TEMP == this ? descriptor.temporary : !descriptor.temporary;
        }

        static {
            $VALUES = new TempState[]{LIVE, TEMP, ANY};
        }
    }
}

