/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.BigLongArray;

public class CompressionMetadata {
    public final long dataLength;
    public final long compressedFileLength;
    private final BigLongArray chunkOffsets;
    public final String indexFilePath;
    public final CompressionParameters parameters;

    public static CompressionMetadata create(String dataFilePath) {
        Descriptor desc = Descriptor.fromFilename(dataFilePath);
        try {
            return new CompressionMetadata(desc.filenameFor(Component.COMPRESSION_INFO), new File(dataFilePath).length());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    CompressionMetadata(String indexFilePath, long compressedLength) throws IOException {
        this.indexFilePath = indexFilePath;
        DataInputStream stream = new DataInputStream(new FileInputStream(indexFilePath));
        String compressorName = stream.readUTF();
        int optionCount = stream.readInt();
        HashMap<String, String> options = new HashMap<String, String>();
        for (int i = 0; i < optionCount; ++i) {
            String key = stream.readUTF();
            String value = stream.readUTF();
            options.put(key, value);
        }
        int chunkLength = stream.readInt();
        try {
            this.parameters = new CompressionParameters(compressorName, (Integer)chunkLength, options);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Cannot create CompressionParameters for stored parameters", e);
        }
        this.dataLength = stream.readLong();
        this.compressedFileLength = compressedLength;
        this.chunkOffsets = this.readChunkOffsets(stream);
        FileUtils.closeQuietly(stream);
    }

    public ICompressor compressor() {
        return this.parameters.sstableCompressor;
    }

    public int chunkLength() {
        return this.parameters.chunkLength();
    }

    private BigLongArray readChunkOffsets(DataInput input) throws IOException {
        int chunkCount = input.readInt();
        BigLongArray offsets = new BigLongArray(chunkCount);
        for (int i = 0; i < chunkCount; ++i) {
            try {
                offsets.set(i, input.readLong());
                continue;
            }
            catch (EOFException e) {
                throw new EOFException(String.format("Corrupted Index File %s: read %d but expected %d chunks.", this.indexFilePath, i, chunkCount));
            }
        }
        return offsets;
    }

    public Chunk chunkFor(long position) throws IOException {
        int idx = (int)(position / (long)this.parameters.chunkLength());
        if (idx >= this.chunkOffsets.size) {
            throw new EOFException();
        }
        long chunkOffset = this.chunkOffsets.get(idx);
        long nextChunkOffset = idx + 1 == this.chunkOffsets.size ? this.compressedFileLength : this.chunkOffsets.get(idx + 1);
        return new Chunk(chunkOffset, (int)(nextChunkOffset - chunkOffset - 4L));
    }

    public class Chunk {
        public final long offset;
        public final int length;

        public Chunk(long offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        public String toString() {
            return String.format("Chunk<offset: %d, length: %d>", this.offset, this.length);
        }
    }

    public static class Writer
    extends RandomAccessFile {
        private long dataLengthOffset = -1L;

        public Writer(String path) throws IOException {
            super(path, "rw");
        }

        public void writeHeader(CompressionParameters parameters) throws IOException {
            this.writeUTF(parameters.sstableCompressor.getClass().getSimpleName());
            this.writeInt(parameters.otherOptions.size());
            for (Map.Entry<String, String> entry : parameters.otherOptions.entrySet()) {
                this.writeUTF(entry.getKey());
                this.writeUTF(entry.getValue());
            }
            this.writeInt(parameters.chunkLength());
            this.dataLengthOffset = this.getFilePointer();
            this.writeLong(-1L);
            this.writeInt(-1);
        }

        public void finalizeHeader(long dataLength, int chunks) throws IOException {
            assert (this.dataLengthOffset != -1L) : "writeHeader wasn't called";
            long currentPosition = this.getFilePointer();
            this.seek(this.dataLengthOffset);
            this.writeLong(dataLength);
            this.writeInt(chunks);
            this.seek(currentPosition);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long chunkOffsetBy(int chunkIndex) throws IOException {
            if (this.dataLengthOffset == -1L) {
                throw new IllegalStateException("writeHeader wasn't called");
            }
            long position = this.getFilePointer();
            this.seek(this.dataLengthOffset + 8L + 4L + (long)chunkIndex * 8L);
            try {
                long l = this.readLong();
                return l;
            }
            finally {
                this.seek(position);
            }
        }

        public void resetAndTruncate(int chunkIndex) throws IOException {
            this.seek(this.dataLengthOffset + 8L + 4L + (long)chunkIndex * 8L);
            this.getChannel().truncate(this.getFilePointer());
        }
    }
}

