/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.collect.Ordering;
import java.io.DataInput;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.HeapAllocator;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSTable {
    static final Logger logger = LoggerFactory.getLogger(SSTable.class);
    public static final String COMPONENT_DATA = Component.Type.DATA.repr;
    public static final String COMPONENT_INDEX = Component.Type.PRIMARY_INDEX.repr;
    public static final String COMPONENT_FILTER = Component.Type.FILTER.repr;
    public static final String COMPONENT_STATS = Component.Type.STATS.repr;
    public static final String COMPONENT_DIGEST = Component.Type.DIGEST.repr;
    public static final String TEMPFILE_MARKER = "tmp";
    public static final Comparator<SSTableReader> maxTimestampComparator = new Comparator<SSTableReader>(){

        @Override
        public int compare(SSTableReader o1, SSTableReader o2) {
            long ts2;
            long ts1 = o1.getMaxTimestamp();
            return ts1 > (ts2 = o2.getMaxTimestamp()) ? -1 : (ts1 == ts2 ? 0 : 1);
        }
    };
    public final Descriptor descriptor;
    protected final Set<Component> components;
    public final CFMetaData metadata;
    public final IPartitioner partitioner;
    public final boolean compression;
    public DecoratedKey first;
    public DecoratedKey last;
    public static final Comparator<SSTableReader> sstableComparator = new Comparator<SSTableReader>(){

        @Override
        public int compare(SSTableReader o1, SSTableReader o2) {
            return o1.first.compareTo(o2.first);
        }
    };
    public static final Ordering<SSTableReader> sstableOrdering = Ordering.from(sstableComparator);

    protected SSTable(Descriptor descriptor, CFMetaData metadata, IPartitioner partitioner) {
        this(descriptor, new HashSet<Component>(), metadata, partitioner);
    }

    protected SSTable(Descriptor descriptor, Set<Component> components, CFMetaData metadata, IPartitioner partitioner) {
        assert (descriptor != null);
        assert (components != null);
        assert (partitioner != null);
        this.descriptor = descriptor;
        HashSet<Component> dataComponents = new HashSet<Component>(components);
        for (Component component : components) {
            assert (component.type != Component.Type.COMPACTED_MARKER);
        }
        this.compression = dataComponents.contains(Component.COMPRESSION_INFO);
        this.components = Collections.unmodifiableSet(dataComponents);
        this.metadata = metadata;
        this.partitioner = partitioner;
    }

    public static boolean delete(Descriptor desc, Set<Component> components) throws IOException {
        if (components.contains(Component.DATA)) {
            FileUtils.deleteWithConfirm(desc.filenameFor(Component.DATA));
        }
        for (Component component : components) {
            if (component.equals(Component.DATA) || component.equals(Component.COMPACTED_MARKER)) continue;
            FileUtils.deleteWithConfirm(desc.filenameFor(component));
        }
        FileUtils.delete(desc.filenameFor(Component.COMPACTED_MARKER));
        logger.debug("Deleted {}", (Object)desc);
        return true;
    }

    public static DecoratedKey<?> getMinimalKey(DecoratedKey<?> key) {
        return key.key.position() > 0 || key.key.hasRemaining() ? new DecoratedKey(key.token, HeapAllocator.instance.clone(key.key)) : key;
    }

    public String getFilename() {
        return this.descriptor.filenameFor(COMPONENT_DATA);
    }

    public String getColumnFamilyName() {
        return this.descriptor.cfname;
    }

    public String getTableName() {
        return this.descriptor.ksname;
    }

    public static Pair<Descriptor, Component> tryComponentFromFilename(File dir, String name) {
        try {
            return Component.fromFilename(dir, name);
        }
        catch (Exception e) {
            if (!("snapshots".equals(name) || "backups".equals(name) || name.contains(".json"))) {
                logger.warn("Invalid file '{}' in data directory {}.", (Object)name, (Object)dir);
            }
            return null;
        }
    }

    static Set<Component> componentsFor(final Descriptor desc, final Descriptor.TempState matchState) {
        final HashSet<Component> components = new HashSet<Component>();
        final String sstableFilePrefix = desc.cfname + '-';
        desc.directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory() || !file.getName().startsWith(sstableFilePrefix)) {
                    return false;
                }
                Pair<Descriptor, Component> component = SSTable.tryComponentFromFilename(file.getParentFile(), file.getName());
                if (component != null && ((Descriptor)component.left).equals(desc) && matchState.isMatch((Descriptor)component.left)) {
                    components.add(component.right);
                }
                return false;
            }
        });
        return components;
    }

    static long estimateRowsFromData(Descriptor desc, RandomAccessReader dfile) throws IOException {
        int keys;
        int SAMPLES_CAP = 1000;
        int BYTES_CAP = (int)Math.min(100000000L, dfile.length());
        long dataPosition = 0L;
        for (keys = 0; dataPosition < (long)BYTES_CAP && keys < 1000; ++keys) {
            dfile.seek(dataPosition);
            ByteBufferUtil.skipShortLength(dfile);
            long dataSize = SSTableReader.readRowSize(dfile, desc);
            dataPosition = dfile.getFilePointer() + dataSize;
        }
        dfile.seek(0L);
        return dfile.length() / (dataPosition / (long)keys);
    }

    static long estimateRowsFromIndex(RandomAccessReader ifile) throws IOException {
        int keys;
        int SAMPLES_CAP = 10000;
        int BYTES_CAP = (int)Math.min(10000000L, ifile.length());
        for (keys = 0; ifile.getFilePointer() < (long)BYTES_CAP && keys < 10000; ++keys) {
            ByteBufferUtil.skipShortLength(ifile);
            FileUtils.skipBytesFully((DataInput)ifile, 8);
        }
        assert (keys > 0 && ifile.getFilePointer() > 0L && ifile.length() > 0L) : "Unexpected empty index file: " + ifile;
        long estimatedRows = ifile.length() / (ifile.getFilePointer() / (long)keys);
        ifile.seek(0L);
        return estimatedRows;
    }

    public static long getTotalBytes(Iterable<SSTableReader> sstables) {
        long sum = 0L;
        for (SSTableReader sstable : sstables) {
            sum += sstable.onDiskLength();
        }
        return sum;
    }

    public long bytesOnDisk() {
        long bytes = 0L;
        for (Component component : this.components) {
            bytes += new File(this.descriptor.filenameFor(component)).length();
        }
        return bytes;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + "path='" + this.getFilename() + '\'' + ')';
    }
}

