/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql.jdbc.JdbcLong;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class LongType
extends AbstractType<Long> {
    public static final LongType instance = new LongType();

    LongType() {
    }

    @Override
    public Long compose(ByteBuffer bytes) {
        return ByteBufferUtil.toLong(bytes);
    }

    @Override
    public ByteBuffer decompose(Long value) {
        return ByteBufferUtil.bytes(value);
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (o1.remaining() == 0) {
            return o2.remaining() == 0 ? 0 : -1;
        }
        if (o2.remaining() == 0) {
            return 1;
        }
        int diff = o1.get(o1.position()) - o2.get(o2.position());
        if (diff != 0) {
            return diff;
        }
        return ByteBufferUtil.compareUnsigned(o1, o2);
    }

    @Override
    public String getString(ByteBuffer bytes) {
        try {
            return JdbcLong.instance.getString(bytes);
        }
        catch (org.apache.cassandra.cql.jdbc.MarshalException e) {
            throw new MarshalException(e.getMessage());
        }
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        long longType;
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            longType = Long.parseLong(source);
        }
        catch (Exception e) {
            throw new MarshalException(String.format("unable to make long from '%s'", source), e);
        }
        return this.decompose(longType);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (bytes.remaining() != 8 && bytes.remaining() != 0) {
            throw new MarshalException(String.format("Expected 8 or 0 byte long (%d)", bytes.remaining()));
        }
    }
}

