/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggableScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private static Logger logger = LoggerFactory.getLogger(DebuggableScheduledThreadPoolExecutor.class);

    public DebuggableScheduledThreadPoolExecutor(int corePoolSize, String threadPoolName, int priority) {
        super(corePoolSize, new NamedThreadFactory(threadPoolName, priority));
    }

    public DebuggableScheduledThreadPoolExecutor(String threadPoolName) {
        this(1, threadPoolName, 5);
    }

    @Override
    public void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        DebuggableThreadPoolExecutor.logExceptionsAfterExecute(r, t);
    }
}

