/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.migration;

import java.io.IOException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.db.migration.avro.CfDef;
import org.apache.cassandra.db.migration.avro.ColumnDef;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;

public class UpdateColumnFamily
extends Migration {
    private CFMetaData metadata;

    protected UpdateColumnFamily() {
    }

    public UpdateColumnFamily(CfDef cf_def) throws ConfigurationException, IOException {
        super(UUIDGen.makeType1UUIDFromHost(FBUtilities.getBroadcastAddress()), Schema.instance.getVersion());
        KSMetaData ksm = this.schema.getTableDefinition(((Object)cf_def.keyspace).toString());
        if (ksm == null) {
            throw new ConfigurationException("No such keyspace: " + ((Object)cf_def.keyspace).toString());
        }
        if (cf_def.column_metadata != null) {
            for (ColumnDef entry : cf_def.column_metadata) {
                if (entry.index_name == null || Migration.isLegalName(((Object)entry.index_name).toString())) continue;
                throw new ConfigurationException("Invalid index name: " + entry.index_name);
            }
        }
        CFMetaData oldCfm = this.schema.getCFMetaData(((Object)cf_def.keyspace).toString(), ((Object)cf_def.name).toString());
        this.metadata = CFMetaData.fromAvro(oldCfm.toAvro());
        this.metadata.apply(cf_def);
        KSMetaData newKsMeta = KSMetaData.fromAvro(ksm.toAvro());
        newKsMeta.cfMetaData().get(((Object)cf_def.name).toString()).apply(cf_def);
        this.rm = this.makeDefinitionMutation(newKsMeta, null, this.newVersion);
    }

    @Override
    void applyModels() throws IOException {
        logger.debug("Updating " + this.schema.getCFMetaData(this.metadata.cfId) + " to " + this.metadata);
        try {
            this.schema.getCFMetaData(this.metadata.cfId).apply(this.metadata.toAvro());
        }
        catch (ConfigurationException ex) {
            throw new IOException(ex);
        }
        this.schema.setTableDefinition(null, this.newVersion);
        if (!StorageService.instance.isClientMode()) {
            Table table = Table.open(this.metadata.ksName, this.schema);
            ColumnFamilyStore oldCfs = table.getColumnFamilyStore(this.metadata.cfName);
            oldCfs.reload();
        }
    }

    @Override
    public void subdeflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.UpdateColumnFamily update = new org.apache.cassandra.db.migration.avro.UpdateColumnFamily();
        update.metadata = this.metadata.toAvro();
        mi.migration = update;
    }

    @Override
    public void subinflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.UpdateColumnFamily update = (org.apache.cassandra.db.migration.avro.UpdateColumnFamily)((Object)mi.migration);
        this.metadata = CFMetaData.fromAvro(update.metadata);
    }

    public String toString() {
        return String.format("Update column family to %s", this.metadata.toString());
    }
}

