/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SliceFromReadCommand;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetriedSliceFromReadCommand
extends SliceFromReadCommand {
    static final Logger logger = LoggerFactory.getLogger(RetriedSliceFromReadCommand.class);
    public final int originalCount;

    public RetriedSliceFromReadCommand(String table, ByteBuffer key, ColumnParent column_parent, ByteBuffer start, ByteBuffer finish, boolean reversed, int originalCount, int count) {
        super(table, key, column_parent, start, finish, reversed, count);
        this.originalCount = originalCount;
    }

    public RetriedSliceFromReadCommand(String table, ByteBuffer key, QueryPath path, ByteBuffer start, ByteBuffer finish, boolean reversed, int originalCount, int count) {
        super(table, key, path, start, finish, reversed, count);
        this.originalCount = originalCount;
    }

    @Override
    public ReadCommand copy() {
        RetriedSliceFromReadCommand readCommand = new RetriedSliceFromReadCommand(this.table, this.key, this.queryPath, this.start, this.finish, this.reversed, this.originalCount, this.count);
        readCommand.setDigestQuery(this.isDigestQuery());
        return readCommand;
    }

    @Override
    public int getRequestedCount() {
        return this.originalCount;
    }

    @Override
    public String toString() {
        return "RetriedSliceFromReadCommand(table='" + this.table + '\'' + ", key='" + ByteBufferUtil.bytesToHex(this.key) + '\'' + ", column_parent='" + this.queryPath + '\'' + ", start='" + this.getComparator().getString(this.start) + '\'' + ", finish='" + this.getComparator().getString(this.finish) + '\'' + ", reversed=" + this.reversed + ", originalCount=" + this.originalCount + ", count=" + this.count + ')';
    }
}

