/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnIndexer;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.ISortedColumns;
import org.apache.cassandra.db.ThreadSafeSortedColumns;
import org.apache.cassandra.db.UnserializableColumnFamilyException;
import org.apache.cassandra.io.ISerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFamilySerializer
implements ISerializer<ColumnFamily> {
    private static final Logger logger = LoggerFactory.getLogger(ColumnFamilySerializer.class);

    @Override
    public void serialize(ColumnFamily columnFamily, DataOutput dos) {
        try {
            if (columnFamily == null) {
                dos.writeBoolean(false);
                return;
            }
            dos.writeBoolean(true);
            dos.writeInt(columnFamily.id());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.serializeForSSTable(columnFamily, dos);
    }

    public int serializeForSSTable(ColumnFamily columnFamily, DataOutput dos) {
        try {
            this.serializeCFInfo(columnFamily, dos);
            Collection<IColumn> columns = columnFamily.getSortedColumns();
            int count = columns.size();
            dos.writeInt(count);
            int i = 0;
            for (IColumn column : columns) {
                columnFamily.getColumnSerializer().serialize(column, dos);
                ++i;
            }
            assert (count == i) : "CF size changed during serialization: was " + count + " initially but " + i + " written";
            return count;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void serializeCFInfo(ColumnFamily columnFamily, DataOutput dos) throws IOException {
        dos.writeInt(columnFamily.getLocalDeletionTime());
        dos.writeLong(columnFamily.getMarkedForDeleteAt());
    }

    public int serializeWithIndexes(ColumnFamily columnFamily, ColumnIndexer.RowHeader index, DataOutput dos) {
        ColumnIndexer.serialize(index, dos);
        return this.serializeForSSTable(columnFamily, dos);
    }

    @Override
    public ColumnFamily deserialize(DataInput dis) throws IOException {
        return this.deserialize(dis, false, ThreadSafeSortedColumns.factory());
    }

    public ColumnFamily deserialize(DataInput dis, boolean fromRemote, ISortedColumns.Factory factory) throws IOException {
        if (!dis.readBoolean()) {
            return null;
        }
        int cfId = dis.readInt();
        if (Schema.instance.getCF(cfId) == null) {
            throw new UnserializableColumnFamilyException("Couldn't find cfId=" + cfId, cfId);
        }
        ColumnFamily cf = ColumnFamily.create(cfId, factory);
        this.deserializeFromSSTableNoColumns(cf, dis);
        this.deserializeColumns(dis, cf, fromRemote);
        return cf;
    }

    public void deserializeColumns(DataInput dis, ColumnFamily cf, boolean fromRemote) throws IOException {
        int size = dis.readInt();
        this.deserializeColumns(dis, cf, size, fromRemote);
    }

    public void deserializeColumns(DataInput dis, ColumnFamily cf, int size, boolean fromRemote) throws IOException {
        for (int i = 0; i < size; ++i) {
            IColumn column = cf.getColumnSerializer().deserialize(dis, fromRemote, (int)(System.currentTimeMillis() / 1000L));
            cf.addColumn(column);
        }
    }

    public ColumnFamily deserializeFromSSTableNoColumns(ColumnFamily cf, DataInput input) throws IOException {
        cf.delete(input.readInt(), input.readLong());
        return cf;
    }

    @Override
    public long serializedSize(ColumnFamily cf) {
        return cf == null ? 1L : cf.serializedSize();
    }
}

