/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkTopologyStrategy
extends AbstractReplicationStrategy {
    private final IEndpointSnitch snitch;
    private final Map<String, Integer> datacenters;
    private static final Logger logger = LoggerFactory.getLogger(NetworkTopologyStrategy.class);

    public NetworkTopologyStrategy(String table, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> configOptions) throws ConfigurationException {
        super(table, tokenMetadata, snitch, configOptions);
        this.snitch = snitch;
        HashMap<String, Integer> newDatacenters = new HashMap<String, Integer>();
        if (configOptions != null) {
            for (Map.Entry<String, String> entry : configOptions.entrySet()) {
                String dc = entry.getKey();
                if (dc.equalsIgnoreCase("replication_factor")) {
                    throw new ConfigurationException("replication_factor is an option for SimpleStrategy, not NetworkTopologyStrategy");
                }
                Integer replicas = Integer.valueOf(entry.getValue());
                newDatacenters.put(dc, replicas);
            }
        }
        this.datacenters = Collections.unmodifiableMap(newDatacenters);
        logger.debug("Configured datacenter replicas are {}", (Object)FBUtilities.toString(this.datacenters));
    }

    @Override
    public List<InetAddress> calculateNaturalEndpoints(Token searchToken, TokenMetadata tokenMetadata) {
        ArrayList<InetAddress> endpoints = new ArrayList<InetAddress>(this.getReplicationFactor());
        for (Map.Entry<String, Integer> dcEntry : this.datacenters.entrySet()) {
            InetAddress endpoint;
            Token token;
            String dcName = dcEntry.getKey();
            int dcReplicas = dcEntry.getValue();
            TokenMetadata dcTokens = new TokenMetadata();
            for (Map.Entry<Token, InetAddress> tokenEntry : tokenMetadata.getTokenToEndpointMapForReading().entrySet()) {
                if (!this.snitch.getDatacenter(tokenEntry.getValue()).equals(dcName)) continue;
                dcTokens.updateNormalToken(tokenEntry.getKey(), tokenEntry.getValue());
            }
            ArrayList<InetAddress> dcEndpoints = new ArrayList<InetAddress>(dcReplicas);
            HashSet<String> racks = new HashSet<String>();
            Iterator<Token> iter = TokenMetadata.ringIterator(dcTokens.sortedTokens(), searchToken, false);
            while (dcEndpoints.size() < dcReplicas && iter.hasNext()) {
                token = iter.next();
                endpoint = dcTokens.getEndpoint(token);
                String rack = this.snitch.getRack(endpoint);
                if (racks.contains(rack)) continue;
                dcEndpoints.add(endpoint);
                racks.add(rack);
            }
            iter = TokenMetadata.ringIterator(dcTokens.sortedTokens(), searchToken, false);
            while (dcEndpoints.size() < dcReplicas && iter.hasNext()) {
                token = iter.next();
                endpoint = dcTokens.getEndpoint(token);
                if (dcEndpoints.contains(endpoint)) continue;
                dcEndpoints.add(endpoint);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{} endpoints in datacenter {} for token {} ", new Object[]{StringUtils.join(dcEndpoints, (String)","), dcName, searchToken});
            }
            endpoints.addAll(dcEndpoints);
        }
        return endpoints;
    }

    @Override
    public int getReplicationFactor() {
        int total = 0;
        for (int repFactor : this.datacenters.values()) {
            total += repFactor;
        }
        return total;
    }

    public int getReplicationFactor(String dc) {
        return this.datacenters.get(dc);
    }

    public Set<String> getDatacenters() {
        return this.datacenters.keySet();
    }

    @Override
    public void validateOptions() throws ConfigurationException {
        for (Map.Entry e : this.configOptions.entrySet()) {
            this.validateReplicationFactor((String)e.getValue());
        }
    }
}

