/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.migration;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;

public class AddColumnFamily
extends Migration {
    private CFMetaData cfm;

    protected AddColumnFamily() {
    }

    public AddColumnFamily(CFMetaData cfm) throws ConfigurationException, IOException {
        super(UUIDGen.makeType1UUIDFromHost(FBUtilities.getBroadcastAddress()), Schema.instance.getVersion());
        this.cfm = cfm;
        KSMetaData ksm = this.schema.getTableDefinition(cfm.ksName);
        if (ksm == null) {
            throw new ConfigurationException("No such keyspace: " + cfm.ksName);
        }
        if (ksm.cfMetaData().containsKey(cfm.cfName)) {
            throw new ConfigurationException(String.format("%s already exists in keyspace %s", cfm.cfName, cfm.ksName));
        }
        if (!Migration.isLegalName(cfm.cfName)) {
            throw new ConfigurationException("Invalid column family name: " + cfm.cfName);
        }
        for (Map.Entry<ByteBuffer, ColumnDefinition> entry : cfm.getColumn_metadata().entrySet()) {
            String indexName = entry.getValue().getIndexName();
            if (indexName == null || Migration.isLegalName(indexName)) continue;
            throw new ConfigurationException("Invalid index name: " + indexName);
        }
        KSMetaData newKsm = this.makeNewKeyspaceDefinition(ksm);
        this.rm = this.makeDefinitionMutation(newKsm, null, this.newVersion);
    }

    private KSMetaData makeNewKeyspaceDefinition(KSMetaData ksm) {
        return KSMetaData.cloneWith(ksm, Iterables.concat(ksm.cfMetaData().values(), Collections.singleton(this.cfm)));
    }

    @Override
    public void applyModels() throws IOException {
        KSMetaData ksm = this.schema.getTableDefinition(this.cfm.ksName);
        ksm = this.makeNewKeyspaceDefinition(ksm);
        try {
            this.schema.load(this.cfm);
        }
        catch (ConfigurationException ex) {
            throw new IOException(ex);
        }
        Table.open(this.cfm.ksName, this.schema);
        this.schema.setTableDefinition(ksm, this.newVersion);
        this.schema.fixCFMaxId();
        if (!StorageService.instance.isClientMode()) {
            Table.open(ksm.name, this.schema).initCf(this.cfm.cfId, this.cfm.cfName);
        }
    }

    @Override
    public void subdeflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.AddColumnFamily acf = new org.apache.cassandra.db.migration.avro.AddColumnFamily();
        acf.cf = this.cfm.toAvro();
        mi.migration = acf;
    }

    @Override
    public void subinflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.AddColumnFamily acf = (org.apache.cassandra.db.migration.avro.AddColumnFamily)((Object)mi.migration);
        this.cfm = CFMetaData.fromAvro(acf.cf);
    }

    public String toString() {
        return "Add column family: " + this.cfm.toString();
    }
}

