/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.streaming.OperationType;
import org.apache.cassandra.streaming.PendingFile;
import org.apache.cassandra.streaming.StreamInSession;
import org.apache.cassandra.streaming.StreamRequestMessage;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamIn {
    private static Logger logger = LoggerFactory.getLogger(StreamIn.class);

    public static void requestRanges(InetAddress source, String tableName, Collection<Range> ranges, Runnable callback, OperationType type) {
        StreamIn.requestRanges(source, tableName, Table.open(tableName).getColumnFamilyStores(), ranges, callback, type);
    }

    public static void requestRanges(InetAddress source, String tableName, Collection<ColumnFamilyStore> columnFamilies, Collection<Range> ranges, Runnable callback, OperationType type) {
        assert (ranges.size() > 0);
        if (logger.isDebugEnabled()) {
            logger.debug("Requesting from {} ranges {}", (Object)source, (Object)StringUtils.join(ranges, (String)", "));
        }
        StreamInSession session = StreamInSession.create(source, callback);
        StreamRequestMessage srm = new StreamRequestMessage(FBUtilities.getBroadcastAddress(), ranges, tableName, columnFamilies, session.getSessionId(), type);
        Message message = srm.getMessage(Gossiper.instance.getVersion(source));
        MessagingService.instance().sendOneWay(message, source);
    }

    public static PendingFile getContextMapping(PendingFile remote) throws IOException {
        Descriptor remotedesc = remote.desc;
        if (!remotedesc.isStreamCompatible()) {
            throw new UnsupportedOperationException(String.format("SSTable %s is not compatible with current version %s", remote.getFilename(), "hd"));
        }
        Table table = Table.open(remotedesc.ksname);
        ColumnFamilyStore cfStore = table.getColumnFamilyStore(remotedesc.cfname);
        Descriptor localdesc = Descriptor.fromFilename(cfStore.getFlushPath(remote.size, remote.desc.version));
        return new PendingFile(localdesc, remote);
    }
}

