/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileFilter;
import java.io.IOError;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cassandra.cache.AutoSavingCache;
import org.apache.cassandra.cache.AutoSavingKeyCache;
import org.apache.cassandra.cache.AutoSavingRowCache;
import org.apache.cassandra.cache.ConcurrentLinkedHashCache;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.CollationController;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.DataTracker;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.ISortedColumns;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.MeteredFlusher;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowIteratorFactory;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.LeveledCompactionStrategy;
import org.apache.cassandra.db.compaction.LeveledManifest;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.filter.IFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableMetadata;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.utils.Allocator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.CLibrary;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.DefaultInteger;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.HeapAllocator;
import org.apache.cassandra.utils.IntervalTree.Interval;
import org.apache.cassandra.utils.LatencyTracker;
import org.apache.cassandra.utils.NodeId;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WrappedRunnable;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFamilyStore
implements ColumnFamilyStoreMBean {
    private static Logger logger = LoggerFactory.getLogger(ColumnFamilyStore.class);
    private static final ExecutorService flushWriter = new JMXEnabledThreadPoolExecutor(DatabaseDescriptor.getFlushWriters(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(DatabaseDescriptor.getFlushQueueSize()), new NamedThreadFactory("FlushWriter"), "internal");
    public static final ExecutorService postFlushExecutor = new JMXEnabledThreadPoolExecutor("MemtablePostFlusher");
    public final Table table;
    public final String columnFamily;
    public final CFMetaData metadata;
    public final IPartitioner partitioner;
    private final String mbeanName;
    private volatile boolean valid = true;
    private final DataTracker data;
    private volatile int memtableSwitchCount = 0;
    private AtomicInteger fileIndexGenerator = new AtomicInteger(0);
    public final SecondaryIndexManager indexManager;
    private LatencyTracker readStats = new LatencyTracker();
    private LatencyTracker writeStats = new LatencyTracker();
    private final EstimatedHistogram recentSSTablesPerRead = new EstimatedHistogram(35);
    private final EstimatedHistogram sstablesPerRead = new EstimatedHistogram(35);
    private static final int INTERN_CUTOFF = 256;
    public final ConcurrentMap<ByteBuffer, ByteBuffer> internedNames = new NonBlockingHashMap();
    private volatile DefaultInteger minCompactionThreshold;
    private volatile DefaultInteger maxCompactionThreshold;
    private volatile AbstractCompactionStrategy compactionStrategy;
    private volatile DefaultInteger rowCacheSaveInSeconds;
    private volatile DefaultInteger keyCacheSaveInSeconds;
    private volatile DefaultInteger rowCacheKeysToSave;
    public final Lock flushLock = new ReentrantLock();
    public final AutoSavingCache<Pair<Descriptor, DecoratedKey>, Long> keyCache;
    public final AutoSavingCache<DecoratedKey, ColumnFamily> rowCache;
    volatile double liveRatio = 1.0;
    private final AtomicLong liveRatioComputedAt = new AtomicLong(32L);

    public void reload() throws IOException {
        if (!this.minCompactionThreshold.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.minCompactionThreshold = new DefaultInteger(this.metadata.getMinCompactionThreshold());
            }
        }
        if (!this.maxCompactionThreshold.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.maxCompactionThreshold = new DefaultInteger(this.metadata.getMaxCompactionThreshold());
            }
        }
        if (!this.rowCacheSaveInSeconds.isModified()) {
            this.rowCacheSaveInSeconds = new DefaultInteger(this.metadata.getRowCacheSavePeriodInSeconds());
        }
        if (!this.keyCacheSaveInSeconds.isModified()) {
            this.keyCacheSaveInSeconds = new DefaultInteger(this.metadata.getKeyCacheSavePeriodInSeconds());
        }
        if (!this.rowCacheKeysToSave.isModified()) {
            this.rowCacheKeysToSave = new DefaultInteger(this.metadata.getRowCacheKeysToSave());
        }
        this.maybeReloadCompactionStrategy();
        this.updateCacheSizes();
        this.scheduleCacheSaving(this.rowCacheSaveInSeconds.value(), this.keyCacheSaveInSeconds.value(), this.rowCacheKeysToSave.value());
        this.indexManager.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeReloadCompactionStrategy() {
        if (this.metadata.compactionStrategyClass.equals(this.compactionStrategy.getClass()) && ((Object)this.metadata.compactionStrategyOptions).equals(this.compactionStrategy.getOptions())) {
            return;
        }
        CompactionManager.instance.getCompactionLock().lock();
        try {
            this.compactionStrategy.shutdown();
            this.compactionStrategy = this.metadata.createCompactionStrategyInstance(this);
        }
        finally {
            CompactionManager.instance.getCompactionLock().unlock();
        }
    }

    @Override
    public void setCompactionStrategyClass(String compactionStrategyClass) throws ConfigurationException {
        this.metadata.compactionStrategyClass = CFMetaData.createCompactionStrategy(compactionStrategyClass);
        this.maybeReloadCompactionStrategy();
    }

    @Override
    public String getCompactionStrategyClass() {
        return this.metadata.compactionStrategyClass.getName();
    }

    private ColumnFamilyStore(Table table, String columnFamilyName, IPartitioner partitioner, int generation, CFMetaData metadata) {
        assert (metadata != null) : "null metadata for " + table + ":" + columnFamilyName;
        this.table = table;
        this.columnFamily = columnFamilyName;
        this.metadata = metadata;
        this.minCompactionThreshold = new DefaultInteger(metadata.getMinCompactionThreshold());
        this.maxCompactionThreshold = new DefaultInteger(metadata.getMaxCompactionThreshold());
        this.rowCacheSaveInSeconds = new DefaultInteger(metadata.getRowCacheSavePeriodInSeconds());
        this.keyCacheSaveInSeconds = new DefaultInteger(metadata.getKeyCacheSavePeriodInSeconds());
        this.rowCacheKeysToSave = new DefaultInteger(metadata.getRowCacheKeysToSave());
        this.partitioner = partitioner;
        this.indexManager = new SecondaryIndexManager(this);
        this.fileIndexGenerator.set(generation);
        if (logger.isDebugEnabled()) {
            logger.debug("Starting CFS {}", (Object)this.columnFamily);
        }
        ConcurrentLinkedHashCache kc = ConcurrentLinkedHashCache.create(0, table.name, columnFamilyName);
        this.keyCache = new AutoSavingKeyCache<Pair<Descriptor, DecoratedKey>, Long>(kc, table.name, columnFamilyName);
        ICache<DecoratedKey, ColumnFamily> rc = metadata.getRowCacheProvider().create(0, table.name, columnFamilyName);
        this.rowCache = new AutoSavingRowCache<DecoratedKey, ColumnFamily>(rc, table.name, columnFamilyName);
        this.data = new DataTracker(this);
        Set<DecoratedKey> savedKeys = this.keyCache.readSaved();
        Set<Map.Entry<Descriptor, Set<Component>>> entries = ColumnFamilyStore.files(table.name, columnFamilyName, false, false).entrySet();
        this.data.addInitialSSTables(SSTableReader.batchOpen(entries, savedKeys, this.data, metadata, this.partitioner));
        this.compactionStrategy = metadata.createCompactionStrategyInstance(this);
        for (ColumnDefinition info : metadata.getColumn_metadata().values()) {
            if (info.getIndexType() == null) continue;
            this.indexManager.addIndexedColumn(info);
        }
        String type = this.partitioner instanceof LocalPartitioner ? "IndexColumnFamilies" : "ColumnFamilies";
        this.mbeanName = "org.apache.cassandra.db:type=" + type + ",keyspace=" + this.table.name + ",columnfamily=" + this.columnFamily;
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName nameObj = new ObjectName(this.mbeanName);
            mbs.registerMBean(this, nameObj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void invalidate() {
        try {
            this.valid = false;
            this.unregisterMBean();
            this.data.removeAllSSTables();
            this.indexManager.invalidate();
        }
        catch (Exception e) {
            logger.warn("Failed unregistering mbean: " + this.mbeanName, (Throwable)e);
        }
    }

    void unregisterMBean() throws MalformedObjectNameException, InstanceNotFoundException, MBeanRegistrationException {
        ObjectName nameObj;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (mbs.isRegistered(nameObj = new ObjectName(this.mbeanName))) {
            mbs.unregisterMBean(nameObj);
        }
    }

    @Override
    public long getMinRowSize() {
        return this.data.getMinRowSize();
    }

    @Override
    public long getMaxRowSize() {
        return this.data.getMaxRowSize();
    }

    @Override
    public long getMeanRowSize() {
        return this.data.getMeanRowSize();
    }

    public int getMeanColumns() {
        return this.data.getMeanColumns();
    }

    public static ColumnFamilyStore createColumnFamilyStore(Table table, String columnFamily) {
        return ColumnFamilyStore.createColumnFamilyStore(table, columnFamily, StorageService.getPartitioner(), Schema.instance.getCFMetaData(table.name, columnFamily));
    }

    public static synchronized ColumnFamilyStore createColumnFamilyStore(Table table, String columnFamily, IPartitioner partitioner, CFMetaData metadata) {
        ArrayList<Integer> generations = new ArrayList<Integer>();
        for (String path : DatabaseDescriptor.getAllDataFileLocationsForTable(table.name)) {
            Iterable<Pair<Descriptor, Component>> pairs = ColumnFamilyStore.files(new File(path), columnFamily);
            File incrementalsPath = new File(path, "backups");
            if (incrementalsPath.exists()) {
                pairs = Iterables.concat(pairs, ColumnFamilyStore.files(incrementalsPath, columnFamily));
            }
            for (Pair pair : pairs) {
                Descriptor desc = (Descriptor)pair.left;
                if (!desc.cfname.equals(columnFamily)) continue;
                generations.add(desc.generation);
                if (desc.isCompatible()) continue;
                throw new RuntimeException(String.format("Can't open incompatible SSTable! Current version %s, found file: %s", "hd", desc));
            }
        }
        Collections.sort(generations);
        int value = generations.size() > 0 ? (Integer)generations.get(generations.size() - 1) : 0;
        return new ColumnFamilyStore(table, columnFamily, partitioner, value, metadata);
    }

    public static void scrubDataDirectories(String table, String columnFamily) {
        CFMetaData cfm;
        logger.debug("Removing compacted SSTable files from {} (see http://wiki.apache.org/cassandra/MemtableSSTable)", (Object)columnFamily);
        for (Map.Entry<Descriptor, Set<Component>> sstableFiles : ColumnFamilyStore.files(table, columnFamily, true, true).entrySet()) {
            Descriptor desc = sstableFiles.getKey();
            Set<Component> components = sstableFiles.getValue();
            if (components.contains(Component.COMPACTED_MARKER) || desc.temporary) {
                try {
                    SSTable.delete(desc, components);
                    continue;
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
            File dataFile = new File(desc.filenameFor(Component.DATA));
            if (components.contains(Component.DATA) && dataFile.length() > 0L) continue;
            logger.warn("Removing orphans for {}: {}", (Object)desc, components);
            for (Component component : components) {
                try {
                    FileUtils.deleteWithConfirm(desc.filenameFor(component));
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
        }
        Pattern tmpCacheFilePattern = Pattern.compile(table + "-" + columnFamily + "-(Key|Row)Cache.*\\.tmp$");
        File dir = new File(DatabaseDescriptor.getSavedCachesLocation());
        if (dir.exists()) {
            assert (dir.isDirectory());
            for (File file : dir.listFiles()) {
                if (!tmpCacheFilePattern.matcher(file.getName()).matches() || file.delete()) continue;
                logger.warn("could not delete " + file.getAbsolutePath());
            }
        }
        if ((cfm = Schema.instance.getCFMetaData(table, columnFamily)) != null) {
            for (ColumnDefinition def : cfm.getColumn_metadata().values()) {
                ColumnFamilyStore.scrubDataDirectories(table, cfm.indexColumnFamilyName(def));
            }
        }
    }

    public void initCaches() {
        long start = System.currentTimeMillis();
        int cachedRowsRead = 0;
        for (DecoratedKey key : this.rowCache.readSaved()) {
            this.cacheRow(key);
            if (cachedRowsRead++ <= this.rowCache.getCapacity()) continue;
            logger.debug(String.format("Stopped loading row cache after capacity %d was reached", this.rowCache.getCapacity()));
            break;
        }
        if (this.rowCache.size() > 0) {
            logger.info(String.format("completed loading (%d ms; %d keys) row cache for %s.%s", System.currentTimeMillis() - start, this.rowCache.size(), this.table.name, this.columnFamily));
        }
        this.scheduleCacheSaving(this.metadata.getRowCacheSavePeriodInSeconds(), this.metadata.getKeyCacheSavePeriodInSeconds(), this.metadata.getRowCacheKeysToSave());
    }

    public void scheduleCacheSaving(int rowCacheSavePeriodInSeconds, int keyCacheSavePeriodInSeconds, int rowCacheKeysToSave) {
        this.keyCache.scheduleSaving(keyCacheSavePeriodInSeconds, Integer.MAX_VALUE);
        this.rowCache.scheduleSaving(rowCacheSavePeriodInSeconds, rowCacheKeysToSave);
    }

    public AutoSavingCache<Pair<Descriptor, DecoratedKey>, Long> getKeyCache() {
        return this.keyCache;
    }

    private static Map<Descriptor, Set<Component>> files(String keyspace, String columnFamily, boolean includeCompacted, boolean includeTemporary) {
        HashMap<Descriptor, Set<Component>> sstables = new HashMap<Descriptor, Set<Component>>();
        for (String directory : DatabaseDescriptor.getAllDataFileLocationsForTable(keyspace)) {
            for (Pair<Descriptor, Component> component : ColumnFamilyStore.files(new File(directory), columnFamily)) {
                if (component == null) continue;
                if (!(!includeCompacted && new File(((Descriptor)component.left).filenameFor(Component.COMPACTED_MARKER)).exists() || !includeTemporary && ((Descriptor)component.left).temporary)) {
                    HashSet components = (HashSet)sstables.get(component.left);
                    if (components == null) {
                        components = new HashSet();
                        sstables.put((Descriptor)component.left, components);
                    }
                    components.add(component.right);
                    continue;
                }
                logger.debug("not including compacted sstable " + ((Descriptor)component.left).cfname + "-" + ((Descriptor)component.left).generation);
            }
        }
        return sstables;
    }

    private static List<Pair<Descriptor, Component>> files(File path, String columnFamilyName) {
        final ArrayList<Pair<Descriptor, Component>> sstables = new ArrayList<Pair<Descriptor, Component>>();
        final String sstableFilePrefix = columnFamilyName + '-';
        path.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory() || !file.getName().startsWith(sstableFilePrefix)) {
                    return false;
                }
                Pair<Descriptor, Component> pair = SSTable.tryComponentFromFilename(file.getParentFile(), file.getName());
                if (pair != null) {
                    sstables.add(pair);
                }
                return false;
            }
        });
        return sstables;
    }

    public static synchronized void loadNewSSTables(String ksName, String cfName) {
        Table table = Table.open(ksName);
        table.getColumnFamilyStore(cfName).loadNewSSTables();
    }

    @Override
    public synchronized void loadNewSSTables() {
        logger.info("Loading new SSTables for " + this.table.name + "/" + this.columnFamily + "...");
        DataTracker.View view = this.data.getView();
        HashSet<Descriptor> currentDescriptors = new HashSet<Descriptor>();
        HashSet<SSTableReader> sstables = new HashSet<SSTableReader>();
        Set<DecoratedKey> savedKeys = this.keyCache.readSaved();
        int generation = 0;
        for (SSTableReader reader : view.sstables) {
            sstables.add(reader);
            currentDescriptors.add(reader.descriptor);
            if (reader.descriptor.generation <= generation) continue;
            generation = reader.descriptor.generation;
        }
        boolean atLeastOneNew = false;
        for (Map.Entry<Descriptor, Set<Component>> rawSSTable : ColumnFamilyStore.files(this.table.name, this.columnFamily, false, false).entrySet()) {
            SSTableReader reader;
            Descriptor descriptor = rawSSTable.getKey();
            if (currentDescriptors.contains(descriptor) || !descriptor.cfname.equals(this.columnFamily)) continue;
            if (!descriptor.isCompatible()) {
                throw new RuntimeException(String.format("Can't open incompatible SSTable! Current version %s, found file: %s", "hd", descriptor));
            }
            logger.info("Initializing new SSTable {}", rawSSTable);
            try {
                reader = SSTableReader.open(rawSSTable.getKey(), rawSSTable.getValue(), savedKeys, this.data, this.metadata, this.partitioner);
            }
            catch (IOException e) {
                SSTableReader.logOpenException(rawSSTable.getKey(), e);
                continue;
            }
            sstables.add(reader);
            if (descriptor.generation > generation) {
                generation = descriptor.generation;
            }
            if (atLeastOneNew) continue;
            atLeastOneNew = true;
        }
        if (!atLeastOneNew) {
            logger.info("No new SSTables where found for " + this.table.name + "/" + this.columnFamily);
            return;
        }
        logger.info("Loading new SSTable Set for " + this.table.name + "/" + this.columnFamily + ": " + sstables);
        SSTableReader.acquireReferences(sstables);
        this.data.addSSTables(sstables);
        logger.info("Requesting a full secondary index re-build for " + this.table.name + "/" + this.columnFamily);
        try {
            this.indexManager.maybeBuildSecondaryIndexes(sstables, this.indexManager.getIndexedColumns());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            SSTableReader.releaseReferences(sstables);
        }
        logger.info("Setting up new generation: " + generation);
        this.fileIndexGenerator.set(generation);
        logger.info("Done loading load new SSTables for " + this.table.name + "/" + this.columnFamily);
    }

    @Override
    public String getColumnFamilyName() {
        return this.columnFamily;
    }

    public String getFlushPath(long estimatedSize, String version) {
        String location = this.table.getDataFileLocation(estimatedSize);
        if (location == null) {
            throw new RuntimeException("Insufficient disk space to flush " + estimatedSize + " bytes");
        }
        return this.getTempSSTablePath(location, version);
    }

    public String getTempSSTablePath(String directory, String version) {
        Descriptor desc = new Descriptor(version, new File(directory), this.table.name, this.columnFamily, this.fileIndexGenerator.incrementAndGet(), true);
        return desc.filenameFor(Component.DATA);
    }

    public String getTempSSTablePath(String directory) {
        return this.getTempSSTablePath(directory, "hd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> maybeSwitchMemtable(Memtable oldMemtable, final boolean writeCommitLog) {
        if (oldMemtable.isFrozen()) {
            logger.debug("memtable is already frozen; another thread must be flushing it");
            return null;
        }
        Table.switchLock.writeLock().lock();
        try {
            if (oldMemtable.isFrozen()) {
                logger.debug("memtable is already frozen; another thread must be flushing it");
                Future<?> future = null;
                return future;
            }
            assert (this.getMemtableThreadSafe() == oldMemtable);
            final ReplayPosition ctx = writeCommitLog ? CommitLog.instance.getContext() : ReplayPosition.NONE;
            logger.debug("flush position is {}", (Object)ctx);
            final ArrayList<ColumnFamilyStore> icc = new ArrayList<ColumnFamilyStore>();
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                Memtable mt = cfs.getMemtableThreadSafe();
                if (mt.isClean() || mt.isFrozen()) continue;
                mt.freeze();
                icc.add(cfs);
            }
            final CountDownLatch latch = new CountDownLatch(icc.size());
            for (ColumnFamilyStore cfs : icc) {
                Memtable memtable = cfs.data.switchMemtable();
                logger.info("Enqueuing flush of {}", (Object)memtable);
                memtable.flushAndSignal(latch, flushWriter, ctx);
            }
            if (this.memtableSwitchCount == Integer.MAX_VALUE) {
                this.memtableSwitchCount = 0;
            }
            ++this.memtableSwitchCount;
            Future<?> future = postFlushExecutor.submit(new WrappedRunnable(){

                @Override
                public void runMayThrow() throws InterruptedException, IOException {
                    latch.await();
                    if (!icc.isEmpty()) {
                        for (SecondaryIndex index : ColumnFamilyStore.this.indexManager.getIndexesNotBackedByCfs()) {
                            logger.info("Flushing SecondaryIndex {}", (Object)index);
                            index.forceBlockingFlush();
                        }
                    }
                    if (writeCommitLog) {
                        CommitLog.instance.discardCompletedSegments(ColumnFamilyStore.this.metadata.cfId, ctx);
                    }
                }
            });
            return future;
        }
        finally {
            Table.switchLock.writeLock().unlock();
        }
    }

    public boolean isDropped() {
        return this.isIndex() ? Schema.instance.getCFMetaData(this.table.name, this.getParentColumnfamily()) == null : Schema.instance.getCFMetaData(this.metadata.cfId) == null;
    }

    @Override
    public Future<?> forceFlush() {
        boolean clean = true;
        for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
            clean &= cfs.getMemtableThreadSafe().isClean();
        }
        if (clean) {
            logger.debug("forceFlush requested but everything is clean in {}", (Object)this.columnFamily);
            return null;
        }
        return this.maybeSwitchMemtable(this.getMemtableThreadSafe(), true);
    }

    public void forceBlockingFlush() throws ExecutionException, InterruptedException {
        Object future = this.forceFlush();
        if (future != null) {
            future.get();
        }
    }

    public void updateRowCache(DecoratedKey key, ColumnFamily columnFamily) {
        if (this.rowCache.isPutCopying()) {
            this.invalidateCachedRow(key);
        } else {
            ColumnFamily cachedRow = this.getRawCachedRow(key);
            if (cachedRow != null) {
                cachedRow.addAllWithSCCopy(columnFamily, HeapAllocator.instance);
            }
        }
    }

    public void apply(DecoratedKey key, ColumnFamily columnFamily) {
        long start = System.nanoTime();
        Memtable mt = this.getMemtableThreadSafe();
        mt.put(key, columnFamily);
        this.updateRowCache(key, columnFamily);
        this.writeStats.addNano(System.nanoTime() - start);
        while (true) {
            long last = this.liveRatioComputedAt.get();
            long operations = this.writeStats.getOpCount();
            if (operations < 2L * last) break;
            if (!this.liveRatioComputedAt.compareAndSet(last, operations)) continue;
            logger.debug("computing liveRatio of {} at {} ops", (Object)this, (Object)operations);
            mt.updateLiveRatio();
        }
    }

    public static ColumnFamily removeDeletedCF(ColumnFamily cf, int gcBefore) {
        if (cf.getColumnCount() == 0 && cf.getLocalDeletionTime() < gcBefore) {
            return null;
        }
        cf.maybeResetDeletionTimes(gcBefore);
        return cf;
    }

    public static ColumnFamily removeDeleted(ColumnFamily cf, int gcBefore) {
        if (cf == null) {
            return null;
        }
        ColumnFamilyStore.removeDeletedColumnsOnly(cf, gcBefore);
        return ColumnFamilyStore.removeDeletedCF(cf, gcBefore);
    }

    public static void removeDeletedColumnsOnly(ColumnFamily cf, int gcBefore) {
        if (cf.isSuper()) {
            ColumnFamilyStore.removeDeletedSuper(cf, gcBefore);
        } else {
            ColumnFamilyStore.removeDeletedStandard(cf, gcBefore);
        }
    }

    private static void removeDeletedStandard(ColumnFamily cf, int gcBefore) {
        Iterator<IColumn> iter = cf.iterator();
        while (iter.hasNext()) {
            IColumn c = iter.next();
            ByteBuffer cname = c.name();
            if ((!c.isMarkedForDelete() || c.getLocalDeletionTime() >= gcBefore) && c.timestamp() > cf.getMarkedForDeleteAt()) continue;
            iter.remove();
        }
    }

    private static void removeDeletedSuper(ColumnFamily cf, int gcBefore) {
        Iterator<IColumn> iter = cf.iterator();
        while (iter.hasNext()) {
            SuperColumn c = (SuperColumn)iter.next();
            long minTimestamp = Math.max(c.getMarkedForDeleteAt(), cf.getMarkedForDeleteAt());
            Iterator<IColumn> subIter = c.getSubColumns().iterator();
            while (subIter.hasNext()) {
                IColumn subColumn = subIter.next();
                if (subColumn.timestamp() > minTimestamp && (!subColumn.isMarkedForDelete() || subColumn.getLocalDeletionTime() >= gcBefore)) continue;
                subIter.remove();
            }
            if (c.getSubColumns().isEmpty() && c.getLocalDeletionTime() < gcBefore) {
                iter.remove();
                continue;
            }
            c.maybeResetDeletionTimes(gcBefore);
        }
    }

    public boolean isKeyInRemainingSSTables(DecoratedKey key, Set<? extends SSTable> sstablesToIgnore) {
        List<SSTableReader> filteredSSTables = this.data.getView().intervalTree.search(new Interval(key, key));
        for (SSTableReader sstable : filteredSSTables) {
            if (sstablesToIgnore.contains(sstable) || !sstable.getBloomFilter().isPresent(key.key)) continue;
            return true;
        }
        return false;
    }

    public void addSSTable(SSTableReader sstable) {
        assert (sstable.getColumnFamilyName().equals(this.columnFamily));
        this.data.addSSTables(Arrays.asList(sstable));
        CompactionManager.instance.submitBackground(this);
    }

    public long getExpectedCompactedFileSize(Iterable<SSTableReader> sstables) {
        long expectedFileSize = 0L;
        for (SSTableReader sstable : sstables) {
            long size = sstable.onDiskLength();
            expectedFileSize += size;
        }
        return expectedFileSize;
    }

    public SSTableReader getMaxSizeFile(Iterable<SSTableReader> sstables) {
        long maxSize = 0L;
        SSTableReader maxFile = null;
        for (SSTableReader sstable : sstables) {
            if (sstable.onDiskLength() <= maxSize) continue;
            maxSize = sstable.onDiskLength();
            maxFile = sstable;
        }
        return maxFile;
    }

    public void forceCleanup(NodeId.OneShotRenewer renewer) throws ExecutionException, InterruptedException {
        CompactionManager.instance.performCleanup(this, renewer);
    }

    public void scrub() throws ExecutionException, InterruptedException {
        this.snapshotWithoutFlush("pre-scrub-" + System.currentTimeMillis());
        CompactionManager.instance.performScrub(this);
    }

    public void sstablesRewrite() throws ExecutionException, InterruptedException {
        CompactionManager.instance.performSSTableRewrite(this);
    }

    public void markCompacted(Collection<SSTableReader> sstables, OperationType compactionType) {
        assert (!sstables.isEmpty());
        this.data.markCompacted(sstables, compactionType);
    }

    public void replaceCompactedSSTables(Collection<SSTableReader> sstables, Iterable<SSTableReader> replacements, OperationType compactionType) {
        this.data.replaceCompactedSSTables(sstables, replacements, compactionType);
    }

    void replaceFlushed(Memtable memtable, SSTableReader sstable) {
        this.data.replaceFlushed(memtable, sstable);
        CompactionManager.instance.submitBackground(this);
    }

    public boolean isValid() {
        return this.valid;
    }

    @Override
    public long getMemtableColumnsCount() {
        return this.getMemtableThreadSafe().getOperations();
    }

    @Override
    public long getMemtableDataSize() {
        return this.getMemtableThreadSafe().getLiveSize();
    }

    public long getTotalMemtableLiveSize() {
        return this.getMemtableDataSize() + this.indexManager.getTotalLiveSize();
    }

    @Override
    public int getMemtableSwitchCount() {
        return this.memtableSwitchCount;
    }

    private Memtable getMemtableThreadSafe() {
        return this.data.getMemtable();
    }

    public DataTracker getDataTracker() {
        return this.data;
    }

    public Collection<SSTableReader> getSSTables() {
        return this.data.getSSTables();
    }

    @Override
    public long[] getRecentSSTablesPerReadHistogram() {
        return this.recentSSTablesPerRead.getBuckets(true);
    }

    @Override
    public long[] getSSTablesPerReadHistogram() {
        return this.sstablesPerRead.getBuckets(false);
    }

    @Override
    public long getReadCount() {
        return this.readStats.getOpCount();
    }

    @Override
    public double getRecentReadLatencyMicros() {
        return this.readStats.getRecentLatencyMicros();
    }

    @Override
    public long[] getLifetimeReadLatencyHistogramMicros() {
        return this.readStats.getTotalLatencyHistogramMicros();
    }

    @Override
    public long[] getRecentReadLatencyHistogramMicros() {
        return this.readStats.getRecentLatencyHistogramMicros();
    }

    @Override
    public long getTotalReadLatencyMicros() {
        return this.readStats.getTotalLatencyMicros();
    }

    @Override
    public int getPendingTasks() {
        return Table.switchLock.getQueueLength();
    }

    @Override
    public long getWriteCount() {
        return this.writeStats.getOpCount();
    }

    @Override
    public long getTotalWriteLatencyMicros() {
        return this.writeStats.getTotalLatencyMicros();
    }

    @Override
    public double getRecentWriteLatencyMicros() {
        return this.writeStats.getRecentLatencyMicros();
    }

    @Override
    public long[] getLifetimeWriteLatencyHistogramMicros() {
        return this.writeStats.getTotalLatencyHistogramMicros();
    }

    @Override
    public long[] getRecentWriteLatencyHistogramMicros() {
        return this.writeStats.getRecentLatencyHistogramMicros();
    }

    public ColumnFamily getColumnFamily(DecoratedKey key, QueryPath path, ByteBuffer start, ByteBuffer finish, boolean reversed, int limit) {
        return this.getColumnFamily(QueryFilter.getSliceFilter(key, path, start, finish, reversed, limit));
    }

    public ColumnFamily getColumnFamily(QueryFilter filter) {
        return this.getColumnFamily(filter, this.gcBefore());
    }

    public ColumnFamily getColumnFamily(QueryFilter filter, ISortedColumns.Factory factory) {
        return this.getColumnFamily(filter, this.gcBefore());
    }

    public int gcBefore() {
        return (int)(System.currentTimeMillis() / 1000L) - this.metadata.getGcGraceSeconds();
    }

    private ColumnFamily cacheRow(DecoratedKey key) {
        ColumnFamily cached = (ColumnFamily)this.rowCache.get(key);
        if (cached == null) {
            cached = this.getTopLevelColumns(QueryFilter.getIdentityFilter(key, new QueryPath(this.columnFamily)), Integer.MIN_VALUE, true);
            if (cached == null) {
                return null;
            }
            this.rowCache.put(new DecoratedKey(key.token, ByteBufferUtil.clone(key.key)), cached);
        }
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ColumnFamily getColumnFamily(QueryFilter filter, int gcBefore) {
        assert (this.columnFamily.equals(filter.getColumnFamilyName())) : filter.getColumnFamilyName();
        long start = System.nanoTime();
        try {
            if (this.rowCache.getCapacity() == 0) {
                ColumnFamily cf = this.getTopLevelColumns(filter, gcBefore, false);
                if (cf == null) {
                    ColumnFamily columnFamily = null;
                    return columnFamily;
                }
                ColumnFamily columnFamily = cf.isSuper() ? ColumnFamilyStore.removeDeleted(cf, gcBefore) : ColumnFamilyStore.removeDeletedCF(cf, gcBefore);
                return columnFamily;
            }
            ColumnFamily cached = this.cacheRow(filter.key);
            if (cached == null) {
                ColumnFamily columnFamily = null;
                return columnFamily;
            }
            ColumnFamily columnFamily = this.filterColumnFamily(cached, filter, gcBefore);
            return columnFamily;
        }
        finally {
            this.readStats.addNano(System.nanoTime() - start);
        }
    }

    ColumnFamily filterColumnFamily(ColumnFamily cached, QueryFilter filter, int gcBefore) {
        ColumnFamily cf = cached.cloneMeShallow(ArrayBackedSortedColumns.factory(), filter.filter.isReversed());
        IColumnIterator ci = filter.getMemtableColumnIterator(cached, null, this.getComparator());
        filter.collateColumns(cf, Collections.singletonList(ci), this.getComparator(), gcBefore);
        return cf.isSuper() ? ColumnFamilyStore.removeDeleted(cf, gcBefore) : ColumnFamilyStore.removeDeletedCF(cf, gcBefore);
    }

    private DataTracker.View markCurrentViewReferenced() {
        DataTracker.View currentView;
        do {
            currentView = this.data.getView();
        } while (!SSTableReader.acquireReferences(currentView.sstables));
        return currentView;
    }

    public Collection<SSTableReader> markCurrentSSTablesReferenced() {
        return this.markCurrentViewReferenced().sstables;
    }

    public ViewFragment markReferenced(DecoratedKey key) {
        DataTracker.View view;
        List<SSTableReader> sstables;
        assert (!key.isEmpty());
        do {
            view = this.data.getView();
        } while (!SSTableReader.acquireReferences(sstables = view.intervalTree.search(new Interval(key, key))));
        return new ViewFragment(sstables, Iterables.concat(Collections.singleton(view.memtable), view.memtablesPendingFlush));
    }

    public ViewFragment markReferenced(DecoratedKey startWith, DecoratedKey stopAt) {
        DecoratedKey stopInTree;
        DataTracker.View view;
        List<SSTableReader> sstables;
        do {
            view = this.data.getView();
        } while (!SSTableReader.acquireReferences(sstables = view.intervalTree.search(new Interval(startWith, stopInTree = stopAt.isEmpty() ? view.intervalTree.max() : stopAt))));
        return new ViewFragment(sstables, Iterables.concat(Collections.singleton(view.memtable), view.memtablesPendingFlush));
    }

    private ColumnFamily getTopLevelColumns(QueryFilter filter, int gcBefore, boolean forCache) {
        CollationController controller = new CollationController(this, forCache, filter, gcBefore);
        ColumnFamily columns = controller.getTopLevelColumns();
        this.recentSSTablesPerRead.add(controller.getSstablesIterated());
        this.sstablesPerRead.add(controller.getSstablesIterated());
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Row> getRangeSlice(ByteBuffer superColumn, AbstractBounds range, int maxResults, IFilter columnFilter) {
        assert (range instanceof Bounds || !((Range)range).isWrapAround() || range.right.equals(StorageService.getPartitioner().getMinimumToken())) : range;
        DecoratedKey<Token> startWith = new DecoratedKey<Token>(range.left, null);
        DecoratedKey<Token> stopAt = new DecoratedKey<Token>(range.right, null);
        QueryFilter filter = new QueryFilter(null, new QueryPath(this.columnFamily, superColumn, null), columnFilter);
        int gcBefore = (int)(System.currentTimeMillis() / 1000L) - this.metadata.getGcGraceSeconds();
        ViewFragment view = this.markReferenced(startWith, stopAt);
        try {
            CloseableIterator<Row> iterator = RowIteratorFactory.getIterator(view.memtables, view.sstables, startWith, stopAt, filter, this.getComparator(), this);
            ArrayList<Row> rows = new ArrayList<Row>();
            try {
                boolean first = true;
                do {
                    if (!iterator.hasNext()) return rows;
                    Row current = (Row)iterator.next();
                    DecoratedKey<?> key = current.key;
                    if (!stopAt.isEmpty() && stopAt.compareTo(key) < 0) {
                        ArrayList<Row> arrayList = rows;
                        return arrayList;
                    }
                    if (range instanceof Bounds || !first || !key.equals(startWith)) {
                        rows.add(current.cf != null && current.cf.isSuper() ? new Row(current.key, ColumnFamilyStore.removeDeleted(current.cf, gcBefore)) : current);
                        if (logger.isDebugEnabled()) {
                            logger.debug("scanned " + key);
                        }
                    }
                    first = false;
                } while (rows.size() < maxResults);
                ArrayList<Row> arrayList = rows;
                return arrayList;
            }
            finally {
                try {
                    iterator.close();
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
        }
        finally {
            SSTableReader.releaseReferences(view.sstables);
        }
    }

    public List<Row> search(IndexClause clause, AbstractBounds range, IFilter dataFilter) {
        return this.indexManager.search(clause, range, dataFilter);
    }

    public AbstractType getComparator() {
        return this.metadata.comparator;
    }

    public void snapshotWithoutFlush(String snapshotName) {
        for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
            DataTracker.View currentView = cfs.markCurrentViewReferenced();
            try {
                File manifest;
                for (SSTableReader ssTable : currentView.sstables) {
                    File dataDirectory = ssTable.descriptor.directory.getParentFile();
                    String snapshotDirectoryPath = Table.getSnapshotPath(dataDirectory.getAbsolutePath(), this.table.name, snapshotName);
                    FileUtils.createDirectory(snapshotDirectoryPath);
                    ssTable.createLinks(snapshotDirectoryPath);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Snapshot for " + this.table + " keyspace data file " + ssTable.getFilename() + " created in " + snapshotDirectoryPath);
                }
                if (!(this.compactionStrategy instanceof LeveledCompactionStrategy) || (manifest = LeveledManifest.tryGetManifest(cfs)) == null) continue;
                File snapshotDirectory = new File(Table.getSnapshotPath(manifest.getParent(), snapshotName));
                FileUtils.createDirectory(snapshotDirectory);
                CLibrary.createHardLink(manifest, new File(snapshotDirectory, manifest.getName()));
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            finally {
                SSTableReader.releaseReferences(currentView.sstables);
            }
        }
    }

    public void snapshot(String snapshotName) {
        try {
            this.forceBlockingFlush();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        this.snapshotWithoutFlush(snapshotName);
    }

    public boolean hasUnreclaimedSpace() {
        return this.data.getLiveSize() < this.data.getTotalSize();
    }

    @Override
    public long getTotalDiskSpaceUsed() {
        return this.data.getTotalSize();
    }

    @Override
    public long getLiveDiskSpaceUsed() {
        return this.data.getLiveSize();
    }

    @Override
    public int getLiveSSTableCount() {
        return this.data.getSSTables().size();
    }

    public ColumnFamily getRawCachedRow(DecoratedKey key) {
        return this.rowCache.getCapacity() == 0 ? null : (ColumnFamily)this.rowCache.getInternal(key);
    }

    public void invalidateCachedRow(DecoratedKey key) {
        this.rowCache.remove(key);
    }

    @Override
    public void forceMajorCompaction() throws InterruptedException, ExecutionException {
        CompactionManager.instance.performMaximal(this);
    }

    @Override
    public void invalidateRowCache() {
        this.rowCache.clear();
    }

    @Override
    public void invalidateKeyCache() {
        this.keyCache.clear();
    }

    public int getRowCacheCapacity() {
        return this.rowCache.getCapacity();
    }

    public int getKeyCacheCapacity() {
        return this.keyCache.getCapacity();
    }

    public int getRowCacheSize() {
        return this.rowCache.size();
    }

    public int getKeyCacheSize() {
        return this.keyCache.size();
    }

    public static Iterable<ColumnFamilyStore> all() {
        Iterable[] stores = new Iterable[Schema.instance.getTables().size()];
        int i = 0;
        for (Table table : Table.all()) {
            stores[i++] = table.getColumnFamilyStores();
        }
        return Iterables.concat((Iterable[])stores);
    }

    public Iterable<DecoratedKey> allKeySamples() {
        Collection<SSTableReader> sstables = this.getSSTables();
        Iterable[] samples = new Iterable[sstables.size()];
        int i = 0;
        for (SSTableReader sstable : sstables) {
            samples[i++] = sstable.getKeySamples();
        }
        return Iterables.concat((Iterable[])samples);
    }

    public Iterable<DecoratedKey> keySamples(Range range) {
        Collection<SSTableReader> sstables = this.getSSTables();
        Iterable[] samples = new Iterable[sstables.size()];
        int i = 0;
        for (SSTableReader sstable : sstables) {
            samples[i++] = sstable.getKeySamples(range);
        }
        return Iterables.concat((Iterable[])samples);
    }

    public void clearUnsafe() {
        for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
            cfs.data.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForActiveFlushes() {
        Future<?> future;
        Table.switchLock.writeLock().lock();
        try {
            future = postFlushExecutor.submit(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
        finally {
            Table.switchLock.writeLock().unlock();
        }
        try {
            future.get();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        catch (ExecutionException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Future<?> truncate() throws IOException, ExecutionException, InterruptedException {
        logger.debug("truncating {}", (Object)this.columnFamily);
        this.forceBlockingFlush();
        CommitLog.instance.forceNewSegment();
        ReplayPosition position = CommitLog.instance.getContext();
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            cfs.forceFlush();
        }
        this.waitForActiveFlushes();
        CommitLog.instance.discardCompletedSegments(this.metadata.cfId, position);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        long truncatedAt = System.currentTimeMillis();
        if (DatabaseDescriptor.isAutoSnapshot()) {
            this.snapshot(Table.getTimestampedSnapshotName(this.columnFamily));
        }
        return CompactionManager.instance.submitTruncate(this, truncatedAt);
    }

    @Override
    public long getBloomFilterFalsePositives() {
        return this.data.getBloomFilterFalsePositives();
    }

    @Override
    public long getRecentBloomFilterFalsePositives() {
        return this.data.getRecentBloomFilterFalsePositives();
    }

    @Override
    public double getBloomFilterFalseRatio() {
        return this.data.getBloomFilterFalseRatio();
    }

    @Override
    public double getRecentBloomFilterFalseRatio() {
        return this.data.getRecentBloomFilterFalseRatio();
    }

    @Override
    public long getBloomFilterDiskSpaceUsed() {
        long total = 0L;
        for (SSTableReader sst : this.getSSTables()) {
            total += sst.getBloomFilterSerializedSize();
        }
        return total;
    }

    public String toString() {
        return "CFS(Keyspace='" + this.table.name + '\'' + ", ColumnFamily='" + this.columnFamily + '\'' + ')';
    }

    @Override
    public void disableAutoCompaction() {
        this.minCompactionThreshold.set(0);
        this.maxCompactionThreshold.set(0);
    }

    public AbstractCompactionStrategy getCompactionStrategy() {
        return this.compactionStrategy;
    }

    @Override
    public int getMinimumCompactionThreshold() {
        return this.minCompactionThreshold.value();
    }

    @Override
    public void setMinimumCompactionThreshold(int minCompactionThreshold) {
        if (minCompactionThreshold > this.maxCompactionThreshold.value() && this.maxCompactionThreshold.value() != 0) {
            throw new RuntimeException("The min_compaction_threshold cannot be larger than the max.");
        }
        this.minCompactionThreshold.set(minCompactionThreshold);
    }

    @Override
    public int getMaximumCompactionThreshold() {
        return this.maxCompactionThreshold.value();
    }

    @Override
    public void setMaximumCompactionThreshold(int maxCompactionThreshold) {
        if (maxCompactionThreshold > 0 && maxCompactionThreshold < this.minCompactionThreshold.value()) {
            throw new RuntimeException("The max_compaction_threshold cannot be smaller than the min.");
        }
        this.maxCompactionThreshold.set(maxCompactionThreshold);
    }

    public boolean isCompactionDisabled() {
        return this.getMinimumCompactionThreshold() <= 0 || this.getMaximumCompactionThreshold() <= 0;
    }

    @Override
    public int getRowCacheSavePeriodInSeconds() {
        return this.rowCacheSaveInSeconds.value();
    }

    @Override
    public void setRowCacheSavePeriodInSeconds(int rcspis) {
        if (rcspis < 0) {
            throw new RuntimeException("RowCacheSavePeriodInSeconds must be non-negative.");
        }
        this.rowCacheSaveInSeconds.set(rcspis);
        this.scheduleCacheSaving(this.rowCacheSaveInSeconds.value(), this.keyCacheSaveInSeconds.value(), this.rowCacheKeysToSave.value());
    }

    @Override
    public int getKeyCacheSavePeriodInSeconds() {
        return this.keyCacheSaveInSeconds.value();
    }

    @Override
    public void setKeyCacheSavePeriodInSeconds(int kcspis) {
        if (kcspis < 0) {
            throw new RuntimeException("KeyCacheSavePeriodInSeconds must be non-negative.");
        }
        this.keyCacheSaveInSeconds.set(kcspis);
        this.scheduleCacheSaving(this.rowCacheSaveInSeconds.value(), this.keyCacheSaveInSeconds.value(), this.rowCacheKeysToSave.value());
    }

    @Override
    public int getRowCacheKeysToSave() {
        return this.rowCacheKeysToSave.value();
    }

    @Override
    public void setRowCacheKeysToSave(int keysToSave) {
        this.rowCacheKeysToSave.set(keysToSave);
    }

    @Override
    public long estimateKeys() {
        return this.data.estimatedKeys();
    }

    public synchronized void updateCacheSizes() {
        long keys = this.estimateKeys();
        this.keyCache.updateCacheSize(keys);
        this.rowCache.updateCacheSize(keys);
    }

    @Override
    public long[] getEstimatedRowSizeHistogram() {
        return this.data.getEstimatedRowSizeHistogram();
    }

    @Override
    public long[] getEstimatedColumnCountHistogram() {
        return this.data.getEstimatedColumnCountHistogram();
    }

    @Override
    public double getCompressionRatio() {
        return this.data.getCompressionRatio();
    }

    public boolean isIndex() {
        return this.partitioner instanceof LocalPartitioner;
    }

    private String getParentColumnfamily() {
        assert (this.isIndex());
        return this.columnFamily.split("\\.")[0];
    }

    public void reduceCacheSizes() {
        this.rowCache.reduceCacheSize();
        this.keyCache.reduceCacheSize();
    }

    private ByteBuffer intern(ByteBuffer name) {
        ByteBuffer concurrentName;
        ByteBuffer internedName = (ByteBuffer)this.internedNames.get(name);
        if (internedName == null && (concurrentName = this.internedNames.putIfAbsent(internedName = ByteBufferUtil.clone(name), internedName)) != null) {
            internedName = concurrentName;
        }
        return internedName;
    }

    public ByteBuffer internOrCopy(ByteBuffer name, Allocator allocator) {
        if (this.internedNames.size() >= 256) {
            return allocator.clone(name);
        }
        return this.intern(name);
    }

    public ByteBuffer maybeIntern(ByteBuffer name) {
        if (this.internedNames.size() >= 256) {
            return null;
        }
        return this.intern(name);
    }

    public SSTableWriter createFlushWriter(long estimatedRows, long estimatedSize, ReplayPosition context) throws IOException {
        SSTableMetadata.Collector sstableMetadataCollector = SSTableMetadata.createCollector().replayPosition(context);
        return new SSTableWriter(this.getFlushPath(estimatedSize, "hd"), estimatedRows, this.metadata, this.partitioner, sstableMetadataCollector);
    }

    public SSTableWriter createCompactionWriter(long estimatedRows, String location, Collection<SSTableReader> sstables) throws IOException {
        ReplayPosition rp = ReplayPosition.getReplayPosition(sstables);
        SSTableMetadata.Collector sstableMetadataCollector = SSTableMetadata.createCollector().replayPosition(rp);
        for (SSTableReader sstable : sstables) {
            sstableMetadataCollector.updateMaxTimestamp(sstable.getMaxTimestamp());
        }
        return new SSTableWriter(this.getTempSSTablePath(location), estimatedRows, this.metadata, this.partitioner, sstableMetadataCollector);
    }

    public Iterable<ColumnFamilyStore> concatWithIndexes() {
        return Iterables.concat(this.indexManager.getIndexesBackedByCfs(), Collections.singleton(this));
    }

    public Set<Memtable> getMemtablesPendingFlush() {
        return this.data.getMemtablesPendingFlush();
    }

    @Override
    public List<String> getBuiltIndexes() {
        return this.indexManager.getBuiltIndexes();
    }

    @Override
    public int getUnleveledSSTables() {
        return this.compactionStrategy instanceof LeveledCompactionStrategy ? ((LeveledCompactionStrategy)this.compactionStrategy).getLevelSize(0) : 0;
    }

    public long oldestUnflushedMemtable() {
        DataTracker.View view = this.data.getView();
        long oldest = view.memtable.creationTime();
        for (Memtable memtable : view.memtablesPendingFlush) {
            oldest = Math.min(oldest, memtable.creationTime());
        }
        return oldest;
    }

    public boolean isEmpty() {
        DataTracker.View view = this.data.getView();
        return view.sstables.isEmpty() && view.memtable.getOperations() == 0L && view.memtablesPendingFlush.isEmpty();
    }

    public void discardSSTables(long truncatedAt) {
        ArrayList<SSTableReader> truncatedSSTables = new ArrayList<SSTableReader>();
        for (SSTableReader sstable : this.getSSTables()) {
            if (sstable.newSince(truncatedAt)) continue;
            truncatedSSTables.add(sstable);
        }
        if (!truncatedSSTables.isEmpty()) {
            this.markCompacted(truncatedSSTables, OperationType.UNKNOWN);
        }
    }

    static {
        StorageService.optionalTasks.scheduleWithFixedDelay(new MeteredFlusher(), 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public static class ViewFragment {
        public final List<SSTableReader> sstables;
        public final Iterable<Memtable> memtables;

        public ViewFragment(List<SSTableReader> sstables, Iterable<Memtable> memtables) {
            this.sstables = sstables;
            this.memtables = memtables;
        }
    }

    public static enum CacheType {
        KEY_CACHE_TYPE("KeyCache"),
        ROW_CACHE_TYPE("RowCache");

        public final String name;

        private CacheType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

