/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.obs;

import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.cassandra.utils.obs.BitUtil;

public class OpenBitSet
implements Serializable {
    protected long[][] bits;
    protected int wlen;
    protected static final int PAGE_SIZE = 4096;

    public OpenBitSet(long numBits) {
        this(numBits, true);
    }

    public OpenBitSet(long numBits, boolean allocatePages) {
        this.wlen = OpenBitSet.bits2words(numBits);
        this.bits = new long[this.getPageCount()][];
        if (allocatePages) {
            int allocated = 0;
            int i = 0;
            while (allocated < this.wlen) {
                this.bits[i] = new long[4096];
                allocated += 4096;
                ++i;
            }
        }
    }

    public OpenBitSet() {
        this(64L);
    }

    public int getPageSize() {
        return 4096;
    }

    public int getPageCount() {
        return this.wlen / 4096 + 1;
    }

    public long[] getPage(int pageIdx) {
        return this.bits[pageIdx];
    }

    public OpenBitSet(BitSet bits) {
        this(bits.length());
    }

    public long capacity() {
        return (long)this.wlen << 6;
    }

    public long size() {
        return this.capacity();
    }

    public long length() {
        return this.capacity();
    }

    public boolean isEmpty() {
        return this.cardinality() == 0L;
    }

    public int getNumWords() {
        return this.wlen;
    }

    public boolean get(int index) {
        int i = index >> 6;
        if (i >= this.wlen) {
            return false;
        }
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i / 4096][i % 4096] & bitmask) != 0L;
    }

    public boolean fastGet(int index) {
        int i = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i / 4096][i % 4096] & bitmask) != 0L;
    }

    public boolean get(long index) {
        int i = (int)(index >> 6);
        if (i >= this.wlen) {
            return false;
        }
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i / 4096][i % 4096] & bitmask) != 0L;
    }

    public boolean fastGet(long index) {
        int i = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i / 4096][i % 4096] & bitmask) != 0L;
    }

    public int getBit(int index) {
        int i = index >> 6;
        int bit = index & 0x3F;
        return (int)(this.bits[i / 4096][i % 4096] >>> bit) & 1;
    }

    public void set(long index) {
        int wordNum = this.expandingWordNum(index);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        long[] lArray = this.bits[wordNum / 4096];
        int n = wordNum % 4096;
        lArray[n] = lArray[n] | bitmask;
    }

    public void fastSet(int index) {
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        long[] lArray = this.bits[wordNum / 4096];
        int n = wordNum % 4096;
        lArray[n] = lArray[n] | bitmask;
    }

    public void fastSet(long index) {
        int wordNum = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        long[] lArray = this.bits[wordNum / 4096];
        int n = wordNum % 4096;
        lArray[n] = lArray[n] | bitmask;
    }

    public void set(long startIndex, long endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        int endWord = this.expandingWordNum(endIndex - 1L);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        if (startWord == endWord) {
            long[] lArray = this.bits[startWord / 4096];
            int n = startWord % 4096;
            lArray[n] = lArray[n] | startmask & endmask;
            return;
        }
        assert (startWord / 4096 == endWord / 4096) : "cross page sets not suppotred at all - they are not used";
        long[] lArray = this.bits[startWord / 4096];
        int n = startWord % 4096;
        lArray[n] = lArray[n] | startmask;
        Arrays.fill(this.bits[startWord / 4096], (startWord + 1) % 4096, endWord % 4096, -1L);
        long[] lArray2 = this.bits[endWord / 4096];
        int n2 = endWord % 4096;
        lArray2[n2] = lArray2[n2] | endmask;
    }

    protected int expandingWordNum(long index) {
        int wordNum = (int)(index >> 6);
        if (wordNum >= this.wlen) {
            this.ensureCapacity(index + 1L);
            this.wlen = wordNum + 1;
        }
        return wordNum;
    }

    public void fastClear(int index) {
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        long[] lArray = this.bits[wordNum / 4096];
        int n = wordNum % 4096;
        lArray[n] = lArray[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void fastClear(long index) {
        int wordNum = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        long[] lArray = this.bits[wordNum / 4096];
        int n = wordNum % 4096;
        lArray[n] = lArray[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear(long index) {
        int wordNum = (int)(index >> 6);
        if (wordNum >= this.wlen) {
            return;
        }
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        long[] lArray = this.bits[wordNum / 4096];
        int n = wordNum % 4096;
        lArray[n] = lArray[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear(int startIndex, int endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = startIndex >> 6;
        if (startWord >= this.wlen) {
            return;
        }
        int endWord = endIndex - 1 >> 6;
        long startmask = -1L << startIndex;
        long endmask = -1L >>> -endIndex;
        startmask ^= 0xFFFFFFFFFFFFFFFFL;
        endmask ^= 0xFFFFFFFFFFFFFFFFL;
        if (startWord == endWord) {
            long[] lArray = this.bits[startWord / 4096];
            int n = startWord % 4096;
            lArray[n] = lArray[n] & (startmask | endmask);
            return;
        }
        long[] lArray = this.bits[startWord / 4096];
        int n = startWord % 4096;
        lArray[n] = lArray[n] & startmask;
        int middle = Math.min(this.wlen, endWord);
        if (startWord / 4096 == middle / 4096) {
            Arrays.fill(this.bits[startWord / 4096], (startWord + 1) % 4096, middle % 4096, 0L);
        } else {
            while (++startWord < middle) {
                this.bits[startWord / 4096][startWord % 4096] = 0L;
            }
        }
        if (endWord < this.wlen) {
            long[] lArray2 = this.bits[endWord / 4096];
            int n2 = endWord % 4096;
            lArray2[n2] = lArray2[n2] & endmask;
        }
    }

    public void clear(long startIndex, long endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        if (startWord >= this.wlen) {
            return;
        }
        int endWord = (int)(endIndex - 1L >> 6);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        startmask ^= 0xFFFFFFFFFFFFFFFFL;
        endmask ^= 0xFFFFFFFFFFFFFFFFL;
        if (startWord == endWord) {
            long[] lArray = this.bits[startWord / 4096];
            int n = startWord % 4096;
            lArray[n] = lArray[n] & (startmask | endmask);
            return;
        }
        long[] lArray = this.bits[startWord / 4096];
        int n = startWord % 4096;
        lArray[n] = lArray[n] & startmask;
        int middle = Math.min(this.wlen, endWord);
        if (startWord / 4096 == middle / 4096) {
            Arrays.fill(this.bits[startWord / 4096], (startWord + 1) % 4096, middle % 4096, 0L);
        } else {
            while (++startWord < middle) {
                this.bits[startWord / 4096][startWord % 4096] = 0L;
            }
        }
        if (endWord < this.wlen) {
            long[] lArray2 = this.bits[endWord / 4096];
            int n2 = endWord % 4096;
            lArray2[n2] = lArray2[n2] & endmask;
        }
    }

    public boolean getAndSet(int index) {
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        boolean val = (this.bits[wordNum / 4096][wordNum % 4096] & bitmask) != 0L;
        long[] lArray = this.bits[wordNum / 4096];
        int n = wordNum % 4096;
        lArray[n] = lArray[n] | bitmask;
        return val;
    }

    public boolean getAndSet(long index) {
        int wordNum = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        boolean val = (this.bits[wordNum / 4096][wordNum % 4096] & bitmask) != 0L;
        long[] lArray = this.bits[wordNum / 4096];
        int n = wordNum % 4096;
        lArray[n] = lArray[n] | bitmask;
        return val;
    }

    public void fastFlip(int index) {
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        long[] lArray = this.bits[wordNum / 4096];
        int n = wordNum % 4096;
        lArray[n] = lArray[n] ^ bitmask;
    }

    public void fastFlip(long index) {
        int wordNum = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        long[] lArray = this.bits[wordNum / 4096];
        int n = wordNum % 4096;
        lArray[n] = lArray[n] ^ bitmask;
    }

    public void flip(long index) {
        int wordNum = this.expandingWordNum(index);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        long[] lArray = this.bits[wordNum / 4096];
        int n = wordNum % 4096;
        lArray[n] = lArray[n] ^ bitmask;
    }

    public boolean flipAndGet(int index) {
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        long[] lArray = this.bits[wordNum / 4096];
        int n = wordNum % 4096;
        lArray[n] = lArray[n] ^ bitmask;
        return (this.bits[wordNum / 4096][wordNum % 4096] & bitmask) != 0L;
    }

    public boolean flipAndGet(long index) {
        int wordNum = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        long[] lArray = this.bits[wordNum / 4096];
        int n = wordNum % 4096;
        lArray[n] = lArray[n] ^ bitmask;
        return (this.bits[wordNum / 4096][wordNum % 4096] & bitmask) != 0L;
    }

    public void flip(long startIndex, long endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        int endWord = this.expandingWordNum(endIndex - 1L);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        if (startWord == endWord) {
            long[] lArray = this.bits[startWord / 4096];
            int n = startWord % 4096;
            lArray[n] = lArray[n] ^ startmask & endmask;
            return;
        }
        long[] lArray = this.bits[startWord / 4096];
        int n = startWord % 4096;
        lArray[n] = lArray[n] ^ startmask;
        for (int i = startWord + 1; i < endWord; ++i) {
            this.bits[i / 4096][i % 4096] = this.bits[i / 4096][i % 4096] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        long[] lArray2 = this.bits[endWord / 4096];
        int n2 = endWord % 4096;
        lArray2[n2] = lArray2[n2] ^ endmask;
    }

    public long cardinality() {
        long bitCount = 0L;
        int i = this.getPageCount();
        while (i-- > 0) {
            bitCount += BitUtil.pop_array(this.bits[i], 0, this.wlen);
        }
        return bitCount;
    }

    public int nextSetBit(int index) {
        int i = index >> 6;
        if (i >= this.wlen) {
            return -1;
        }
        int subIndex = index & 0x3F;
        long word = this.bits[i / 4096][i % 4096] >> subIndex;
        if (word != 0L) {
            return (i << 6) + subIndex + BitUtil.ntz(word);
        }
        while (++i < this.wlen) {
            word = this.bits[i / 4096][i % 4096];
            if (word == 0L) continue;
            return (i << 6) + BitUtil.ntz(word);
        }
        return -1;
    }

    public long nextSetBit(long index) {
        int i = (int)(index >>> 6);
        if (i >= this.wlen) {
            return -1L;
        }
        int subIndex = (int)index & 0x3F;
        long word = this.bits[i / 4096][i % 4096] >>> subIndex;
        if (word != 0L) {
            return ((long)i << 6) + (long)(subIndex + BitUtil.ntz(word));
        }
        while (++i < this.wlen) {
            word = this.bits[i / 4096][i % 4096];
            if (word == 0L) continue;
            return ((long)i << 6) + (long)BitUtil.ntz(word);
        }
        return -1L;
    }

    public void intersect(OpenBitSet other) {
        int newLen = Math.min(this.wlen, other.wlen);
        long[][] thisArr = this.bits;
        long[][] otherArr = other.bits;
        int thisPageSize = 4096;
        int otherPageSize = 4096;
        int pos = newLen;
        while (--pos >= 0) {
            long[] lArray = thisArr[pos / thisPageSize];
            int n = pos % thisPageSize;
            lArray[n] = lArray[n] & otherArr[pos / otherPageSize][pos % otherPageSize];
        }
        if (this.wlen > newLen) {
            pos = this.wlen;
            while (pos-- > newLen) {
                thisArr[pos / thisPageSize][pos % thisPageSize] = 0L;
            }
        }
        this.wlen = newLen;
    }

    public void and(OpenBitSet other) {
        this.intersect(other);
    }

    public void ensureCapacityWords(int numWords) {
        assert (numWords <= this.wlen) : "Growing of paged bitset is not supported";
    }

    public void ensureCapacity(long numBits) {
        this.ensureCapacityWords(OpenBitSet.bits2words(numBits));
    }

    public void trimTrailingZeros() {
        int idx;
        for (idx = this.wlen - 1; idx >= 0 && this.bits[idx / 4096][idx % 4096] == 0L; --idx) {
        }
        this.wlen = idx + 1;
    }

    public static int bits2words(long numBits) {
        return (int)((numBits - 1L >>> 6) + 1L);
    }

    public boolean equals(Object o) {
        int i;
        OpenBitSet a;
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenBitSet)) {
            return false;
        }
        OpenBitSet b = (OpenBitSet)o;
        if (b.wlen > this.wlen) {
            a = b;
            b = this;
        } else {
            a = this;
        }
        int aPageSize = 4096;
        int bPageSize = 4096;
        for (i = a.wlen - 1; i >= b.wlen; --i) {
            if (a.bits[i / aPageSize][i % aPageSize] == 0L) continue;
            return false;
        }
        for (i = b.wlen - 1; i >= 0; --i) {
            if (a.bits[i / aPageSize][i % aPageSize] == b.bits[i / bPageSize][i % bPageSize]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        long h = 0L;
        int i = this.wlen;
        while (--i >= 0) {
            h ^= this.bits[i / 4096][i % 4096];
            h = h << 1 | h >>> 63;
        }
        return (int)(h >> 32 ^ h) + -1737092556;
    }
}

