/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.streaming.PendingFile;
import org.apache.cassandra.streaming.StreamInSession;
import org.apache.cassandra.streaming.StreamOutSession;
import org.apache.cassandra.streaming.StreamingServiceMBean;

public class StreamingService
implements StreamingServiceMBean {
    public static final String MBEAN_OBJECT_NAME = "org.apache.cassandra.net:type=StreamingService";
    public static final StreamingService instance = new StreamingService();

    private StreamingService() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName(MBEAN_OBJECT_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append("Receiving from:\n");
        for (InetAddress source : StreamInSession.getSources()) {
            sb.append(String.format(" %s:%n", source.getHostAddress()));
            for (PendingFile pf : StreamInSession.getIncomingFiles(source)) {
                sb.append(String.format("  %s%n", pf.toString()));
            }
        }
        sb.append("Sending to:%n");
        for (InetAddress dest : StreamOutSession.getDestinations()) {
            sb.append(String.format(" %s:%n", dest.getHostAddress()));
            for (PendingFile pf : StreamOutSession.getOutgoingFiles(dest)) {
                sb.append(String.format("  %s%n", pf.toString()));
            }
        }
        return sb.toString();
    }

    @Override
    public Set<InetAddress> getStreamDestinations() {
        return StreamOutSession.getDestinations();
    }

    @Override
    public List<String> getOutgoingFiles(String host) throws IOException {
        InetAddress dest;
        ArrayList<String> files = new ArrayList<String>();
        Set<InetAddress> existingDestinations = this.getStreamDestinations();
        if (!existingDestinations.contains(dest = InetAddress.getByName(host))) {
            return files;
        }
        for (PendingFile f : StreamOutSession.getOutgoingFiles(dest)) {
            files.add(String.format("%s", f.toString()));
        }
        return files;
    }

    @Override
    public Set<InetAddress> getStreamSources() {
        return StreamInSession.getSources();
    }

    @Override
    public List<String> getIncomingFiles(String host) throws IOException {
        ArrayList<String> files = new ArrayList<String>();
        for (PendingFile pf : StreamInSession.getIncomingFiles(InetAddress.getByName(host))) {
            files.add(String.format("%s: %s", pf.desc.ksname, pf.toString()));
        }
        return files;
    }
}

