/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.DataInput;
import java.io.IOException;
import org.apache.cassandra.io.util.FastByteArrayOutputStream;

public final class OutputBuffer
extends FastByteArrayOutputStream {
    public OutputBuffer() {
        this(128);
    }

    public OutputBuffer(int size) {
        super(size);
    }

    public byte[] getData() {
        return this.buf;
    }

    public int getLength() {
        return this.count;
    }

    public void write(DataInput in, int len) throws IOException {
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        in.readFully(this.buf, this.count, len);
        this.count = newcount;
    }

    public byte[] asByteArray() {
        if (this.count == this.buf.length) {
            return this.buf;
        }
        return this.toByteArray();
    }
}

