/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import java.io.IOException;
import java.util.Map;
import org.apache.cassandra.io.compress.ICompressor;
import org.xerial.snappy.Snappy;

public class SnappyCompressor
implements ICompressor {
    public static final SnappyCompressor instance = new SnappyCompressor();

    public static SnappyCompressor create(Map<String, String> compressionOptions) {
        return instance;
    }

    @Override
    public int initialCompressedBufferLength(int chunkLength) {
        return Snappy.maxCompressedLength((int)chunkLength);
    }

    @Override
    public int compress(byte[] input, int inputOffset, int inputLength, ICompressor.WrappedArray output, int outputOffset) throws IOException {
        return Snappy.rawCompress((Object)input, (int)inputOffset, (int)inputLength, (byte[])output.buffer, (int)outputOffset);
    }

    @Override
    public int uncompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IOException {
        return Snappy.rawUncompress((byte[])input, (int)inputOffset, (int)inputLength, (Object)output, (int)outputOffset);
    }
}

