/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.ThreadSafeSortedColumns;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.IColumnSerializer;
import org.apache.cassandra.io.util.ColumnSortedMap;
import org.apache.cassandra.utils.ByteBufferUtil;

class SuperColumnSerializer
implements IColumnSerializer {
    private AbstractType comparator;

    public SuperColumnSerializer(AbstractType comparator) {
        this.comparator = comparator;
    }

    public AbstractType getComparator() {
        return this.comparator;
    }

    @Override
    public void serialize(IColumn column, DataOutput dos) {
        SuperColumn superColumn = (SuperColumn)column;
        ByteBufferUtil.writeWithShortLength(column.name(), dos);
        try {
            dos.writeInt(superColumn.getLocalDeletionTime());
            dos.writeLong(superColumn.getMarkedForDeleteAt());
            Collection<IColumn> columns = column.getSubColumns();
            dos.writeInt(columns.size());
            for (IColumn subColumn : columns) {
                Column.serializer().serialize(subColumn, dos);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IColumn deserialize(DataInput dis) throws IOException {
        return this.deserialize(dis, false);
    }

    public IColumn deserialize(DataInput dis, boolean fromRemote) throws IOException {
        return this.deserialize(dis, fromRemote, (int)(System.currentTimeMillis() / 1000L));
    }

    @Override
    public IColumn deserialize(DataInput dis, boolean fromRemote, int expireBefore) throws IOException {
        ByteBuffer name = ByteBufferUtil.readWithShortLength(dis);
        int localDeleteTime = dis.readInt();
        if (localDeleteTime != Integer.MIN_VALUE && localDeleteTime <= 0) {
            throw new IOException("Invalid localDeleteTime read: " + localDeleteTime);
        }
        long markedForDeleteAt = dis.readLong();
        int size = dis.readInt();
        ColumnSerializer serializer = Column.serializer();
        ColumnSortedMap preSortedMap = new ColumnSortedMap(this.comparator, serializer, dis, size, fromRemote, expireBefore);
        SuperColumn superColumn = new SuperColumn(name, ThreadSafeSortedColumns.factory().fromSorted(preSortedMap, false));
        if (localDeleteTime != Integer.MIN_VALUE && localDeleteTime <= 0) {
            throw new IOException("Invalid localDeleteTime read: " + localDeleteTime);
        }
        superColumn.delete(localDeleteTime, markedForDeleteAt);
        return superColumn;
    }
}

