/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.IIterableColumns;
import org.apache.cassandra.utils.BloomFilter;

public class ColumnIndexer {
    public static void serialize(IIterableColumns columns, DataOutput dos) {
        try {
            ColumnIndexer.writeIndex(ColumnIndexer.serialize(columns), dos);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static void serialize(RowHeader indexInfo, DataOutput dos) {
        try {
            ColumnIndexer.writeIndex(indexInfo, dos);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static RowHeader serialize(IIterableColumns columns) {
        int columnCount = columns.getEstimatedColumnCount();
        BloomFilter bf = BloomFilter.getFilter((long)columnCount, 4);
        if (columnCount == 0) {
            return new RowHeader(bf, Collections.<IndexHelper.IndexInfo>emptyList());
        }
        ArrayList<IndexHelper.IndexInfo> indexList = new ArrayList<IndexHelper.IndexInfo>();
        int endPosition = 0;
        int startPosition = -1;
        IColumn lastColumn = null;
        IColumn firstColumn = null;
        for (IColumn column : columns) {
            bf.add(column.name());
            if (firstColumn == null) {
                firstColumn = column;
                startPosition = endPosition;
            }
            if ((endPosition += column.serializedSize()) - startPosition >= DatabaseDescriptor.getColumnIndexSize()) {
                IndexHelper.IndexInfo cIndexInfo = new IndexHelper.IndexInfo(firstColumn.name(), column.name(), startPosition, endPosition - startPosition);
                indexList.add(cIndexInfo);
                firstColumn = null;
            }
            lastColumn = column;
        }
        if (lastColumn == null) {
            return new RowHeader(bf, Collections.<IndexHelper.IndexInfo>emptyList());
        }
        if (indexList.isEmpty() || columns.getComparator().compare(((IndexHelper.IndexInfo)indexList.get((int)(indexList.size() - 1))).lastName, lastColumn.name()) != 0) {
            IndexHelper.IndexInfo cIndexInfo = new IndexHelper.IndexInfo(firstColumn.name(), lastColumn.name(), startPosition, endPosition - startPosition);
            indexList.add(cIndexInfo);
        }
        assert (indexList.size() > 0);
        return new RowHeader(bf, indexList);
    }

    private static void writeIndex(RowHeader indexInfo, DataOutput dos) throws IOException {
        assert (indexInfo != null);
        ColumnIndexer.writeBloomFilter(dos, indexInfo.bloomFilter);
        dos.writeInt(indexInfo.entriesSize);
        if (indexInfo.indexEntries.size() > 1) {
            for (IndexHelper.IndexInfo cIndexInfo : indexInfo.indexEntries) {
                cIndexInfo.serialize(dos);
            }
        }
    }

    private static void writeBloomFilter(DataOutput dos, BloomFilter bf) throws IOException {
        DataOutputBuffer bufOut = new DataOutputBuffer();
        BloomFilter.serializer().serialize(bf, bufOut);
        dos.writeInt(bufOut.getLength());
        dos.write(bufOut.getData(), 0, bufOut.getLength());
        bufOut.flush();
    }

    public static class RowHeader {
        public final BloomFilter bloomFilter;
        public final List<IndexHelper.IndexInfo> indexEntries;
        public final int entriesSize;

        public RowHeader(BloomFilter bf, List<IndexHelper.IndexInfo> indexes) {
            assert (bf != null);
            assert (indexes != null);
            this.bloomFilter = bf;
            this.indexEntries = indexes;
            int entriesSize = 0;
            if (this.indexEntries.size() > 1) {
                for (IndexHelper.IndexInfo info : this.indexEntries) {
                    entriesSize += info.serializedSize();
                }
            }
            this.entriesSize = entriesSize;
        }

        public long serializedSize() {
            return 4 + this.bloomFilter.serializedSize() + 4 + this.entriesSize;
        }
    }
}

