/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cql.Term;

public class SelectExpression {
    public static final int MAX_COLUMNS_DEFAULT = 10000;
    private int numColumns = 10000;
    private boolean reverseColumns = false;
    private final boolean wildcard;
    private Term start;
    private Term finish;
    private List<Term> columns;

    public SelectExpression(Term start, Term finish, int count, boolean reverse, boolean wildcard) {
        this.start = start;
        this.finish = finish;
        this.numColumns = count;
        this.reverseColumns = reverse;
        this.wildcard = wildcard;
    }

    public SelectExpression(Term first, int count, boolean reverse) {
        this.wildcard = false;
        this.columns = new ArrayList<Term>();
        this.columns.add(first);
        this.numColumns = count;
        this.reverseColumns = reverse;
    }

    public void and(Term addTerm) {
        assert (!this.isColumnRange());
        this.columns.add(addTerm);
    }

    public boolean isColumnRange() {
        return this.start != null;
    }

    public boolean isColumnList() {
        return !this.isColumnRange();
    }

    public int getColumnsLimit() {
        return this.numColumns;
    }

    public boolean isColumnsReversed() {
        return this.reverseColumns;
    }

    public void setColumnsReversed(boolean reversed) {
        this.reverseColumns = reversed;
    }

    public void setColumnsLimit(int limit) {
        this.numColumns = limit;
    }

    public Term getStart() {
        return this.start;
    }

    public Term getFinish() {
        return this.finish;
    }

    public List<Term> getColumns() {
        return this.columns;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }
}

