/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.cache.ConcurrentLinkedHashCacheProvider;
import org.apache.cassandra.cache.IRowCacheProvider;
import org.apache.cassandra.cache.SerializingCacheProvider;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.migration.avro.CfDef;
import org.apache.cassandra.db.migration.avro.ColumnDef;
import org.apache.cassandra.io.IColumnSerializer;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CFMetaData {
    private static Logger logger = LoggerFactory.getLogger(CFMetaData.class);
    public static final double DEFAULT_ROW_CACHE_SIZE = 0.0;
    public static final double DEFAULT_KEY_CACHE_SIZE = 200000.0;
    public static final double DEFAULT_READ_REPAIR_CHANCE = 0.1;
    public static final boolean DEFAULT_REPLICATE_ON_WRITE = true;
    public static final int DEFAULT_ROW_CACHE_SAVE_PERIOD_IN_SECONDS = 0;
    public static final int DEFAULT_KEY_CACHE_SAVE_PERIOD_IN_SECONDS = 14400;
    public static final int DEFAULT_ROW_CACHE_KEYS_TO_SAVE = Integer.MAX_VALUE;
    public static final int DEFAULT_GC_GRACE_SECONDS = 864000;
    public static final int DEFAULT_MIN_COMPACTION_THRESHOLD = 4;
    public static final int DEFAULT_MAX_COMPACTION_THRESHOLD = 32;
    public static final double DEFAULT_MERGE_SHARDS_CHANCE = 0.1;
    public static final IRowCacheProvider DEFAULT_ROW_CACHE_PROVIDER = CFMetaData.initDefaultRowCacheProvider();
    public static final String DEFAULT_COMPACTION_STRATEGY_CLASS = "SizeTieredCompactionStrategy";
    public static final ByteBuffer DEFAULT_KEY_NAME = ByteBufferUtil.bytes("KEY");
    public static final CFMetaData StatusCf = CFMetaData.newSystemMetadata("LocationInfo", 0, "persistent metadata for the local node", BytesType.instance, null);
    public static final CFMetaData HintsCf = CFMetaData.newSystemMetadata("HintsColumnFamily", 1, "hinted handoff data", BytesType.instance, BytesType.instance);
    public static final CFMetaData MigrationsCf = CFMetaData.newSystemMetadata("Migrations", 2, "individual schema mutations", TimeUUIDType.instance, null);
    public static final CFMetaData SchemaCf = CFMetaData.newSystemMetadata("Schema", 3, "current state of the schema", UTF8Type.instance, null);
    public static final CFMetaData IndexCf = CFMetaData.newSystemMetadata("IndexInfo", 5, "indexes that have been completed", UTF8Type.instance, null);
    public static final CFMetaData NodeIdCf = CFMetaData.newSystemMetadata("NodeIdInfo", 6, "nodeId and their metadata", TimeUUIDType.instance, null);
    public final Integer cfId;
    public final String ksName;
    public final String cfName;
    public final ColumnFamilyType cfType;
    public final AbstractType comparator;
    public final AbstractType subcolumnComparator;
    private String comment;
    private double rowCacheSize;
    private double keyCacheSize;
    private double readRepairChance;
    private boolean replicateOnWrite;
    private int gcGraceSeconds;
    private AbstractType defaultValidator;
    private AbstractType keyValidator;
    private int minCompactionThreshold;
    private int maxCompactionThreshold;
    private int rowCacheSavePeriodInSeconds;
    private int keyCacheSavePeriodInSeconds;
    private int rowCacheKeysToSave;
    private double mergeShardsChance;
    private IRowCacheProvider rowCacheProvider;
    private ByteBuffer keyAlias;
    private Map<ByteBuffer, ColumnDefinition> column_metadata;
    public Class<? extends AbstractCompactionStrategy> compactionStrategyClass;
    public Map<String, String> compactionStrategyOptions;
    private CompressionParameters compressionParameters;

    private static IRowCacheProvider initDefaultRowCacheProvider() {
        try {
            return new SerializingCacheProvider();
        }
        catch (ConfigurationException e) {
            return new ConcurrentLinkedHashCacheProvider();
        }
    }

    public CFMetaData comment(String prop) {
        this.comment = CFMetaData.enforceCommentNotNull(prop);
        return this;
    }

    public CFMetaData rowCacheSize(double prop) {
        this.rowCacheSize = prop;
        return this;
    }

    public CFMetaData keyCacheSize(double prop) {
        this.keyCacheSize = prop;
        return this;
    }

    public CFMetaData readRepairChance(double prop) {
        this.readRepairChance = prop;
        return this;
    }

    public CFMetaData replicateOnWrite(boolean prop) {
        this.replicateOnWrite = prop;
        return this;
    }

    public CFMetaData gcGraceSeconds(int prop) {
        this.gcGraceSeconds = prop;
        return this;
    }

    public CFMetaData defaultValidator(AbstractType prop) {
        this.defaultValidator = prop;
        return this;
    }

    public CFMetaData keyValidator(AbstractType prop) {
        this.keyValidator = prop;
        return this;
    }

    public CFMetaData minCompactionThreshold(int prop) {
        this.minCompactionThreshold = prop;
        return this;
    }

    public CFMetaData maxCompactionThreshold(int prop) {
        this.maxCompactionThreshold = prop;
        return this;
    }

    public CFMetaData rowCacheSavePeriod(int prop) {
        this.rowCacheSavePeriodInSeconds = prop;
        return this;
    }

    public CFMetaData keyCacheSavePeriod(int prop) {
        this.keyCacheSavePeriodInSeconds = prop;
        return this;
    }

    public CFMetaData rowCacheKeysToSave(int prop) {
        this.rowCacheKeysToSave = prop;
        return this;
    }

    public CFMetaData mergeShardsChance(double prop) {
        this.mergeShardsChance = prop;
        return this;
    }

    public CFMetaData keyAlias(ByteBuffer prop) {
        this.keyAlias = prop;
        return this;
    }

    public CFMetaData columnMetadata(Map<ByteBuffer, ColumnDefinition> prop) {
        this.column_metadata = prop;
        return this;
    }

    public CFMetaData rowCacheProvider(IRowCacheProvider prop) {
        this.rowCacheProvider = prop;
        return this;
    }

    public CFMetaData compactionStrategyClass(Class<? extends AbstractCompactionStrategy> prop) {
        this.compactionStrategyClass = prop;
        return this;
    }

    public CFMetaData compactionStrategyOptions(Map<String, String> prop) {
        this.compactionStrategyOptions = prop;
        return this;
    }

    public CFMetaData compressionParameters(CompressionParameters prop) {
        this.compressionParameters = prop;
        return this;
    }

    public CFMetaData(String keyspace, String name, ColumnFamilyType type, AbstractType comp, AbstractType subcc) {
        this(keyspace, name, type, comp, subcc, Schema.instance.nextCFId());
    }

    private CFMetaData(String keyspace, String name, ColumnFamilyType type, AbstractType comp, AbstractType subcc, int id) {
        this.ksName = keyspace;
        this.cfName = name;
        this.cfType = type;
        this.comparator = comp;
        this.subcolumnComparator = this.enforceSubccDefault(type, subcc);
        this.cfId = id;
        this.init();
    }

    private AbstractType enforceSubccDefault(ColumnFamilyType cftype, AbstractType subcc) {
        return subcc == null && cftype == ColumnFamilyType.Super ? BytesType.instance : subcc;
    }

    private static String enforceCommentNotNull(CharSequence comment) {
        return comment == null ? "" : ((Object)comment).toString();
    }

    private void init() {
        this.rowCacheSize = 0.0;
        this.keyCacheSize = 200000.0;
        this.rowCacheKeysToSave = Integer.MAX_VALUE;
        this.readRepairChance = 0.1;
        this.replicateOnWrite = true;
        this.gcGraceSeconds = 864000;
        this.minCompactionThreshold = 4;
        this.maxCompactionThreshold = 32;
        this.mergeShardsChance = 0.1;
        this.rowCacheProvider = DEFAULT_ROW_CACHE_PROVIDER;
        this.defaultValidator = BytesType.instance;
        this.keyValidator = BytesType.instance;
        this.comment = "";
        this.keyAlias = null;
        this.column_metadata = new HashMap<ByteBuffer, ColumnDefinition>();
        try {
            this.compactionStrategyClass = CFMetaData.createCompactionSrategy(DEFAULT_COMPACTION_STRATEGY_CLASS);
        }
        catch (ConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        this.compactionStrategyOptions = new HashMap<String, String>();
        this.compressionParameters = new CompressionParameters(null);
    }

    private static CFMetaData newSystemMetadata(String cfName, int cfId, String comment, AbstractType comparator, AbstractType subcc) {
        ColumnFamilyType type = subcc == null ? ColumnFamilyType.Standard : ColumnFamilyType.Super;
        CFMetaData newCFMD = new CFMetaData("system", cfName, type, comparator, subcc, cfId);
        return newCFMD.comment(comment).keyCacheSize(0.01).readRepairChance(0.0).gcGraceSeconds(0).mergeShardsChance(0.0).rowCacheSavePeriod(0).keyCacheSavePeriod(0);
    }

    public static CFMetaData newIndexMetadata(CFMetaData parent, ColumnDefinition info, AbstractType columnComparator) {
        return new CFMetaData(parent.ksName, parent.indexColumnFamilyName(info), ColumnFamilyType.Standard, columnComparator, null).keyCacheSize(0.0).readRepairChance(0.0).gcGraceSeconds(parent.gcGraceSeconds).minCompactionThreshold(parent.minCompactionThreshold).maxCompactionThreshold(parent.maxCompactionThreshold);
    }

    public static CFMetaData rename(CFMetaData cfm, String newName) {
        return CFMetaData.copyOpts(new CFMetaData(cfm.ksName, newName, cfm.cfType, cfm.comparator, cfm.subcolumnComparator, cfm.cfId), cfm);
    }

    public static CFMetaData renameTable(CFMetaData cfm, String ksName) {
        return CFMetaData.copyOpts(new CFMetaData(ksName, cfm.cfName, cfm.cfType, cfm.comparator, cfm.subcolumnComparator, cfm.cfId), cfm);
    }

    private static CFMetaData copyOpts(CFMetaData newCFMD, CFMetaData oldCFMD) {
        return newCFMD.comment(oldCFMD.comment).rowCacheSize(oldCFMD.rowCacheSize).keyCacheSize(oldCFMD.keyCacheSize).readRepairChance(oldCFMD.readRepairChance).replicateOnWrite(oldCFMD.replicateOnWrite).gcGraceSeconds(oldCFMD.gcGraceSeconds).defaultValidator(oldCFMD.defaultValidator).minCompactionThreshold(oldCFMD.minCompactionThreshold).maxCompactionThreshold(oldCFMD.maxCompactionThreshold).rowCacheSavePeriod(oldCFMD.rowCacheSavePeriodInSeconds).keyCacheSavePeriod(oldCFMD.keyCacheSavePeriodInSeconds).rowCacheKeysToSave(oldCFMD.rowCacheKeysToSave).columnMetadata(oldCFMD.column_metadata).compactionStrategyClass(oldCFMD.compactionStrategyClass).compactionStrategyOptions(oldCFMD.compactionStrategyOptions).compressionParameters(oldCFMD.compressionParameters);
    }

    public String indexColumnFamilyName(ColumnDefinition info) {
        return this.cfName + "." + (info.getIndexName() == null ? ByteBufferUtil.bytesToHex(info.name) : info.getIndexName());
    }

    public CfDef toAvro() {
        CfDef cf = new CfDef();
        cf.id = this.cfId;
        cf.keyspace = new Utf8(this.ksName);
        cf.name = new Utf8(this.cfName);
        cf.column_type = new Utf8(this.cfType.name());
        cf.comparator_type = new Utf8(this.comparator.toString());
        if (this.subcolumnComparator != null) {
            assert (this.cfType == ColumnFamilyType.Super) : String.format("%s CF %s should not have subcomparator %s defined", new Object[]{this.cfType, this.cfName, this.subcolumnComparator});
            cf.subcomparator_type = new Utf8(this.subcolumnComparator.toString());
        }
        cf.comment = new Utf8(CFMetaData.enforceCommentNotNull(this.comment));
        cf.row_cache_size = this.rowCacheSize;
        cf.key_cache_size = this.keyCacheSize;
        cf.read_repair_chance = this.readRepairChance;
        cf.replicate_on_write = this.replicateOnWrite;
        cf.gc_grace_seconds = this.gcGraceSeconds;
        cf.default_validation_class = this.defaultValidator == null ? null : new Utf8(this.defaultValidator.toString());
        cf.key_validation_class = new Utf8(this.keyValidator.getClass().getName());
        cf.min_compaction_threshold = this.minCompactionThreshold;
        cf.max_compaction_threshold = this.maxCompactionThreshold;
        cf.row_cache_save_period_in_seconds = this.rowCacheSavePeriodInSeconds;
        cf.key_cache_save_period_in_seconds = this.keyCacheSavePeriodInSeconds;
        cf.row_cache_keys_to_save = this.rowCacheKeysToSave;
        cf.merge_shards_chance = this.mergeShardsChance;
        cf.key_alias = this.keyAlias;
        cf.column_metadata = new ArrayList<ColumnDef>(this.column_metadata.size());
        for (ColumnDefinition columnDefinition : this.column_metadata.values()) {
            cf.column_metadata.add(columnDefinition.toAvro());
        }
        cf.row_cache_provider = new Utf8(this.rowCacheProvider.getClass().getName());
        cf.compaction_strategy = new Utf8(this.compactionStrategyClass.getName());
        if (this.compactionStrategyOptions != null) {
            cf.compaction_strategy_options = new HashMap<CharSequence, CharSequence>();
            for (Map.Entry entry : this.compactionStrategyOptions.entrySet()) {
                cf.compaction_strategy_options.put((CharSequence)new Utf8((String)entry.getKey()), (CharSequence)new Utf8((String)entry.getValue()));
            }
        }
        cf.compression_options = this.compressionParameters.asAvroOptions();
        return cf;
    }

    public static CFMetaData fromAvro(CfDef cf) {
        CompressionParameters cp;
        AbstractType keyValidator;
        AbstractType validator;
        AbstractType comparator;
        AbstractType subcolumnComparator = null;
        try {
            comparator = TypeParser.parse(((Object)cf.comparator_type).toString());
            if (cf.subcomparator_type != null) {
                subcolumnComparator = TypeParser.parse(cf.subcomparator_type);
            }
            validator = TypeParser.parse(cf.default_validation_class);
            keyValidator = TypeParser.parse(cf.key_validation_class);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not inflate CFMetaData for " + (Object)((Object)cf), ex);
        }
        TreeMap<ByteBuffer, ColumnDefinition> column_metadata = new TreeMap<ByteBuffer, ColumnDefinition>(BytesType.instance);
        for (ColumnDef aColumn_metadata : cf.column_metadata) {
            ColumnDefinition cd = ColumnDefinition.fromAvro(aColumn_metadata);
            if (cd.getIndexType() != null && cd.getIndexName() == null) {
                cd.setIndexName(CFMetaData.getDefaultIndexName(((Object)cf.name).toString(), comparator, cd.name));
            }
            column_metadata.put(cd.name, cd);
        }
        CFMetaData newCFMD = new CFMetaData(((Object)cf.keyspace).toString(), ((Object)cf.name).toString(), ColumnFamilyType.create(((Object)cf.column_type).toString()), comparator, subcolumnComparator, cf.id);
        if (cf.min_compaction_threshold != null) {
            newCFMD.minCompactionThreshold(cf.min_compaction_threshold);
        }
        if (cf.max_compaction_threshold != null) {
            newCFMD.maxCompactionThreshold(cf.max_compaction_threshold);
        }
        if (cf.row_cache_save_period_in_seconds != null) {
            newCFMD.rowCacheSavePeriod(cf.row_cache_save_period_in_seconds);
        }
        if (cf.key_cache_save_period_in_seconds != null) {
            newCFMD.keyCacheSavePeriod(cf.key_cache_save_period_in_seconds);
        }
        if (cf.row_cache_keys_to_save != null) {
            newCFMD.rowCacheKeysToSave(cf.row_cache_keys_to_save);
        }
        if (cf.merge_shards_chance != null) {
            newCFMD.mergeShardsChance(cf.merge_shards_chance);
        }
        if (cf.row_cache_provider != null) {
            try {
                newCFMD.rowCacheProvider(FBUtilities.newCacheProvider(((Object)cf.row_cache_provider).toString()));
            }
            catch (ConfigurationException e) {
                logger.warn("Unable to instantiate cache provider {}; using default {} instead", (Object)cf.row_cache_provider, (Object)DEFAULT_ROW_CACHE_PROVIDER);
            }
        }
        if (cf.key_alias != null) {
            newCFMD.keyAlias(cf.key_alias);
        }
        if (cf.compaction_strategy != null) {
            try {
                newCFMD.compactionStrategyClass = CFMetaData.createCompactionSrategy(((Object)cf.compaction_strategy).toString());
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        if (cf.compaction_strategy_options != null) {
            for (Map.Entry<CharSequence, CharSequence> e : cf.compaction_strategy_options.entrySet()) {
                newCFMD.compactionStrategyOptions.put(((Object)e.getKey()).toString(), ((Object)e.getValue()).toString());
            }
        }
        try {
            cp = CompressionParameters.create(cf.compression_options);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        return newCFMD.comment(((Object)cf.comment).toString()).rowCacheSize(cf.row_cache_size).keyCacheSize(cf.key_cache_size).readRepairChance(cf.read_repair_chance).replicateOnWrite(cf.replicate_on_write).gcGraceSeconds(cf.gc_grace_seconds).defaultValidator(validator).keyValidator(keyValidator).columnMetadata(column_metadata).compressionParameters(cp);
    }

    public String getComment() {
        return this.comment;
    }

    public double getRowCacheSize() {
        return this.rowCacheSize;
    }

    public double getKeyCacheSize() {
        return this.keyCacheSize;
    }

    public double getReadRepairChance() {
        return this.readRepairChance;
    }

    public double getMergeShardsChance() {
        return this.mergeShardsChance;
    }

    public boolean getReplicateOnWrite() {
        return this.replicateOnWrite;
    }

    public int getGcGraceSeconds() {
        return this.gcGraceSeconds;
    }

    public AbstractType getDefaultValidator() {
        return this.defaultValidator;
    }

    public AbstractType getKeyValidator() {
        return this.keyValidator;
    }

    public Integer getMinCompactionThreshold() {
        return this.minCompactionThreshold;
    }

    public Integer getMaxCompactionThreshold() {
        return this.maxCompactionThreshold;
    }

    public int getRowCacheSavePeriodInSeconds() {
        return this.rowCacheSavePeriodInSeconds;
    }

    public int getKeyCacheSavePeriodInSeconds() {
        return this.keyCacheSavePeriodInSeconds;
    }

    public int getRowCacheKeysToSave() {
        return this.rowCacheKeysToSave;
    }

    public IRowCacheProvider getRowCacheProvider() {
        return this.rowCacheProvider;
    }

    public ByteBuffer getKeyName() {
        return this.keyAlias == null ? DEFAULT_KEY_NAME : this.keyAlias;
    }

    public CompressionParameters compressionParameters() {
        return this.compressionParameters;
    }

    public Map<ByteBuffer, ColumnDefinition> getColumn_metadata() {
        return Collections.unmodifiableMap(this.column_metadata);
    }

    public AbstractType getComparatorFor(ByteBuffer superColumnName) {
        return superColumnName == null ? this.comparator : this.subcolumnComparator;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CFMetaData rhs = (CFMetaData)obj;
        return new EqualsBuilder().append((Object)this.ksName, (Object)rhs.ksName).append((Object)this.cfName, (Object)rhs.cfName).append((Object)this.cfType, (Object)rhs.cfType).append((Object)this.comparator, (Object)rhs.comparator).append((Object)this.subcolumnComparator, (Object)rhs.subcolumnComparator).append((Object)this.comment, (Object)rhs.comment).append(this.rowCacheSize, rhs.rowCacheSize).append(this.keyCacheSize, rhs.keyCacheSize).append(this.readRepairChance, rhs.readRepairChance).append(this.replicateOnWrite, rhs.replicateOnWrite).append(this.gcGraceSeconds, rhs.gcGraceSeconds).append((Object)this.defaultValidator, (Object)rhs.defaultValidator).append((Object)this.keyValidator, (Object)rhs.keyValidator).append(this.minCompactionThreshold, rhs.minCompactionThreshold).append(this.maxCompactionThreshold, rhs.maxCompactionThreshold).append(this.cfId.intValue(), rhs.cfId.intValue()).append(this.column_metadata, rhs.column_metadata).append(this.rowCacheSavePeriodInSeconds, rhs.rowCacheSavePeriodInSeconds).append(this.keyCacheSavePeriodInSeconds, rhs.keyCacheSavePeriodInSeconds).append(this.rowCacheKeysToSave, rhs.rowCacheKeysToSave).append(this.mergeShardsChance, rhs.mergeShardsChance).append((Object)this.keyAlias, (Object)rhs.keyAlias).append(this.compactionStrategyClass, rhs.compactionStrategyClass).append(this.compactionStrategyOptions, rhs.compactionStrategyOptions).append((Object)this.compressionParameters, (Object)rhs.compressionParameters).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(29, 1597).append((Object)this.ksName).append((Object)this.cfName).append((Object)this.cfType).append((Object)this.comparator).append((Object)this.subcolumnComparator).append((Object)this.comment).append(this.rowCacheSize).append(this.keyCacheSize).append(this.readRepairChance).append(this.replicateOnWrite).append(this.gcGraceSeconds).append((Object)this.defaultValidator).append((Object)this.keyValidator).append(this.minCompactionThreshold).append(this.maxCompactionThreshold).append((Object)this.cfId).append(this.column_metadata).append(this.rowCacheSavePeriodInSeconds).append(this.keyCacheSavePeriodInSeconds).append(this.rowCacheKeysToSave).append(this.mergeShardsChance).append((Object)this.keyAlias).append(this.compactionStrategyClass).append(this.compactionStrategyOptions).append((Object)this.compressionParameters).toHashCode();
    }

    public AbstractType getValueValidator(ByteBuffer column) {
        return this.getValueValidator(this.column_metadata.get(column));
    }

    public AbstractType getValueValidator(ColumnDefinition columnDefinition) {
        return columnDefinition == null ? this.defaultValidator : columnDefinition.getValidator();
    }

    public static void applyImplicitDefaults(org.apache.cassandra.thrift.CfDef cf_def) {
        if (!cf_def.isSetComment()) {
            cf_def.setComment("");
        }
        if (!cf_def.isSetReplicate_on_write()) {
            cf_def.setReplicate_on_write(true);
        }
        if (!cf_def.isSetMin_compaction_threshold()) {
            cf_def.setMin_compaction_threshold(4);
        }
        if (!cf_def.isSetMax_compaction_threshold()) {
            cf_def.setMax_compaction_threshold(32);
        }
        if (!cf_def.isSetRow_cache_save_period_in_seconds()) {
            cf_def.setRow_cache_save_period_in_seconds(0);
        }
        if (!cf_def.isSetKey_cache_save_period_in_seconds()) {
            cf_def.setKey_cache_save_period_in_seconds(14400);
        }
        if (!cf_def.isSetRow_cache_keys_to_save()) {
            cf_def.setRow_cache_keys_to_save(Integer.MAX_VALUE);
        }
        if (!cf_def.isSetMerge_shards_chance()) {
            cf_def.setMerge_shards_chance(0.1);
        }
        if (null == cf_def.compaction_strategy) {
            cf_def.compaction_strategy = DEFAULT_COMPACTION_STRATEGY_CLASS;
        }
        if (null == cf_def.compaction_strategy_options) {
            cf_def.compaction_strategy_options = Collections.emptyMap();
        }
    }

    public static CFMetaData fromThrift(org.apache.cassandra.thrift.CfDef cf_def) throws InvalidRequestException, ConfigurationException {
        ColumnFamilyType cfType = ColumnFamilyType.create(cf_def.column_type);
        if (cfType == null) {
            throw new InvalidRequestException("Invalid column type " + cf_def.column_type);
        }
        CFMetaData.applyImplicitDefaults(cf_def);
        CFMetaData newCFMD = new CFMetaData(cf_def.keyspace, cf_def.name, cfType, TypeParser.parse(cf_def.comparator_type), cf_def.subcomparator_type == null ? null : TypeParser.parse(cf_def.subcomparator_type), cf_def.isSetId() ? cf_def.id : Schema.instance.nextCFId());
        if (cf_def.isSetGc_grace_seconds()) {
            newCFMD.gcGraceSeconds(cf_def.gc_grace_seconds);
        }
        if (cf_def.isSetMin_compaction_threshold()) {
            newCFMD.minCompactionThreshold(cf_def.min_compaction_threshold);
        }
        if (cf_def.isSetMax_compaction_threshold()) {
            newCFMD.maxCompactionThreshold(cf_def.max_compaction_threshold);
        }
        if (cf_def.isSetRow_cache_save_period_in_seconds()) {
            newCFMD.rowCacheSavePeriod(cf_def.row_cache_save_period_in_seconds);
        }
        if (cf_def.isSetKey_cache_save_period_in_seconds()) {
            newCFMD.keyCacheSavePeriod(cf_def.key_cache_save_period_in_seconds);
        }
        if (cf_def.isSetRow_cache_keys_to_save()) {
            newCFMD.rowCacheKeysToSave(cf_def.row_cache_keys_to_save);
        }
        if (cf_def.isSetMerge_shards_chance()) {
            newCFMD.mergeShardsChance(cf_def.merge_shards_chance);
        }
        if (cf_def.isSetRow_cache_provider()) {
            newCFMD.rowCacheProvider(FBUtilities.newCacheProvider(cf_def.row_cache_provider));
        }
        if (cf_def.isSetKey_alias()) {
            newCFMD.keyAlias(cf_def.key_alias);
        }
        if (cf_def.isSetKey_validation_class()) {
            newCFMD.keyValidator(TypeParser.parse(cf_def.key_validation_class));
        }
        if (cf_def.isSetCompaction_strategy()) {
            newCFMD.compactionStrategyClass = CFMetaData.createCompactionSrategy(cf_def.compaction_strategy);
        }
        if (cf_def.isSetCompaction_strategy_options()) {
            newCFMD.compactionStrategyOptions(new HashMap<String, String>(cf_def.compaction_strategy_options));
        }
        CompressionParameters cp = CompressionParameters.create(cf_def.compression_options);
        return newCFMD.comment(cf_def.comment).rowCacheSize(cf_def.row_cache_size).keyCacheSize(cf_def.key_cache_size).readRepairChance(cf_def.read_repair_chance).replicateOnWrite(cf_def.replicate_on_write).defaultValidator(TypeParser.parse(cf_def.default_validation_class)).keyValidator(TypeParser.parse(cf_def.key_validation_class)).columnMetadata(ColumnDefinition.fromThrift(cf_def.column_metadata)).compressionParameters(cp);
    }

    public void apply(CfDef cf_def) throws ConfigurationException {
        logger.debug("applying {} to {}", (Object)cf_def, (Object)this);
        if (!((Object)cf_def.keyspace).toString().equals(this.ksName)) {
            throw new ConfigurationException(String.format("Keyspace mismatch (found %s; expected %s)", cf_def.keyspace, this.ksName));
        }
        if (!((Object)cf_def.name).toString().equals(this.cfName)) {
            throw new ConfigurationException(String.format("Column family mismatch (found %s; expected %s)", cf_def.name, this.cfName));
        }
        if (!cf_def.id.equals(this.cfId)) {
            throw new ConfigurationException(String.format("Column family ID mismatch (found %s; expected %s)", cf_def.id, this.cfId));
        }
        if (!((Object)cf_def.column_type).toString().equals(this.cfType.name())) {
            throw new ConfigurationException("types do not match.");
        }
        if (this.comparator != TypeParser.parse(cf_def.comparator_type)) {
            throw new ConfigurationException("comparators do not match.");
        }
        if (cf_def.subcomparator_type == null || cf_def.subcomparator_type.equals("") ? this.subcolumnComparator != null : this.subcolumnComparator != TypeParser.parse(cf_def.subcomparator_type)) {
            throw new ConfigurationException("subcolumncomparators do not match.");
        }
        CFMetaData.validateMinMaxCompactionThresholds(cf_def);
        this.comment = CFMetaData.enforceCommentNotNull(cf_def.comment);
        this.rowCacheSize = cf_def.row_cache_size;
        this.keyCacheSize = cf_def.key_cache_size;
        this.readRepairChance = cf_def.read_repair_chance;
        this.replicateOnWrite = cf_def.replicate_on_write;
        this.gcGraceSeconds = cf_def.gc_grace_seconds;
        this.defaultValidator = TypeParser.parse(cf_def.default_validation_class);
        this.keyValidator = TypeParser.parse(cf_def.key_validation_class);
        this.minCompactionThreshold = cf_def.min_compaction_threshold;
        this.maxCompactionThreshold = cf_def.max_compaction_threshold;
        this.rowCacheSavePeriodInSeconds = cf_def.row_cache_save_period_in_seconds;
        this.keyCacheSavePeriodInSeconds = cf_def.key_cache_save_period_in_seconds;
        this.rowCacheKeysToSave = cf_def.row_cache_keys_to_save;
        this.mergeShardsChance = cf_def.merge_shards_chance;
        if (cf_def.row_cache_provider != null) {
            this.rowCacheProvider = FBUtilities.newCacheProvider(((Object)cf_def.row_cache_provider).toString());
        }
        this.keyAlias = cf_def.key_alias;
        HashSet<ByteBuffer> toRemove = new HashSet<ByteBuffer>();
        HashSet<ByteBuffer> newColumns = new HashSet<ByteBuffer>();
        HashSet<ColumnDef> toAdd = new HashSet<ColumnDef>();
        for (ColumnDef columnDef : cf_def.column_metadata) {
            newColumns.add(columnDef.name);
            if (this.column_metadata.containsKey(columnDef.name)) continue;
            toAdd.add(columnDef);
        }
        for (ByteBuffer byteBuffer : this.column_metadata.keySet()) {
            if (newColumns.contains(byteBuffer)) continue;
            toRemove.add(byteBuffer);
        }
        for (ByteBuffer byteBuffer : toRemove) {
            this.column_metadata.remove(byteBuffer);
        }
        for (ColumnDef columnDef : cf_def.column_metadata) {
            ColumnDefinition oldDef = this.column_metadata.get(columnDef.name);
            if (oldDef == null) continue;
            oldDef.setValidator(TypeParser.parse(columnDef.validation_class));
            oldDef.setIndexType(columnDef.index_type == null ? null : IndexType.valueOf((String)columnDef.index_type.name()), ColumnDefinition.getStringMap(columnDef.index_options));
            oldDef.setIndexName(columnDef.index_name == null ? null : ((Object)columnDef.index_name).toString());
        }
        for (ColumnDef columnDef : toAdd) {
            AbstractType dValidClass = TypeParser.parse(columnDef.validation_class);
            ColumnDefinition cd = new ColumnDefinition(columnDef.name, dValidClass, columnDef.index_type == null ? null : IndexType.valueOf((String)columnDef.index_type.toString()), ColumnDefinition.getStringMap(columnDef.index_options), columnDef.index_name == null ? null : ((Object)columnDef.index_name).toString());
            this.column_metadata.put(cd.name, cd);
        }
        if (cf_def.compaction_strategy != null) {
            this.compactionStrategyClass = CFMetaData.createCompactionSrategy(((Object)cf_def.compaction_strategy).toString());
        }
        if (null != cf_def.compaction_strategy_options) {
            this.compactionStrategyOptions = new HashMap<String, String>();
            for (Map.Entry entry : cf_def.compaction_strategy_options.entrySet()) {
                this.compactionStrategyOptions.put(((Object)((CharSequence)entry.getKey())).toString(), ((Object)((CharSequence)entry.getValue())).toString());
            }
        }
        this.compressionParameters = CompressionParameters.create(cf_def.compression_options);
        logger.debug("application result is {}", (Object)this);
    }

    public static Class<? extends AbstractCompactionStrategy> createCompactionSrategy(String className) throws ConfigurationException {
        className = className.contains(".") ? className : "org.apache.cassandra.db.compaction." + className;
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not create Compaction Strategy of type " + className, e);
        }
    }

    public AbstractCompactionStrategy createCompactionStrategyInstance(ColumnFamilyStore cfs) {
        try {
            Constructor<? extends AbstractCompactionStrategy> constructor = this.compactionStrategyClass.getConstructor(ColumnFamilyStore.class, Map.class);
            return constructor.newInstance(cfs, this.compactionStrategyOptions);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public org.apache.cassandra.thrift.CfDef toThrift() {
        org.apache.cassandra.thrift.CfDef def = new org.apache.cassandra.thrift.CfDef(this.ksName, this.cfName);
        def.setId(this.cfId.intValue());
        def.setColumn_type(this.cfType.name());
        def.setComparator_type(this.comparator.toString());
        if (this.subcolumnComparator != null) {
            assert (this.cfType == ColumnFamilyType.Super) : String.format("%s CF %s should not have subcomparator %s defined", new Object[]{this.cfType, this.cfName, this.subcolumnComparator});
            def.setSubcomparator_type(this.subcolumnComparator.toString());
        }
        def.setComment(CFMetaData.enforceCommentNotNull(this.comment));
        def.setRow_cache_size(this.rowCacheSize);
        def.setKey_cache_size(this.keyCacheSize);
        def.setRead_repair_chance(this.readRepairChance);
        def.setReplicate_on_write(this.replicateOnWrite);
        def.setGc_grace_seconds(this.gcGraceSeconds);
        def.setDefault_validation_class(this.defaultValidator.toString());
        def.setKey_validation_class(this.keyValidator.toString());
        def.setMin_compaction_threshold(this.minCompactionThreshold);
        def.setMax_compaction_threshold(this.maxCompactionThreshold);
        def.setRow_cache_save_period_in_seconds(this.rowCacheSavePeriodInSeconds);
        def.setKey_cache_save_period_in_seconds(this.keyCacheSavePeriodInSeconds);
        def.setRow_cache_keys_to_save(this.rowCacheKeysToSave);
        def.setRow_cache_provider(this.rowCacheProvider.getClass().getName());
        def.setMerge_shards_chance(this.mergeShardsChance);
        def.setKey_alias(this.getKeyName());
        ArrayList<org.apache.cassandra.thrift.ColumnDef> column_meta = new ArrayList<org.apache.cassandra.thrift.ColumnDef>(this.column_metadata.size());
        for (ColumnDefinition cd : this.column_metadata.values()) {
            org.apache.cassandra.thrift.ColumnDef tcd = new org.apache.cassandra.thrift.ColumnDef();
            tcd.setIndex_name(cd.getIndexName());
            tcd.setIndex_type(cd.getIndexType());
            tcd.setIndex_options(cd.getIndexOptions());
            tcd.setName(cd.name);
            tcd.setValidation_class(cd.getValidator().toString());
            column_meta.add(tcd);
        }
        def.setColumn_metadata(column_meta);
        def.setCompaction_strategy(this.compactionStrategyClass.getName());
        def.setCompaction_strategy_options(new HashMap<String, String>(this.compactionStrategyOptions));
        def.setCompression_options(this.compressionParameters.asThriftOptions());
        return def;
    }

    public static void validateMinMaxCompactionThresholds(CfDef cf_def) throws ConfigurationException {
        if (cf_def.min_compaction_threshold != null && cf_def.max_compaction_threshold != null) {
            if (cf_def.min_compaction_threshold > cf_def.max_compaction_threshold && cf_def.max_compaction_threshold != 0) {
                throw new ConfigurationException("min_compaction_threshold cannot be greater than max_compaction_threshold");
            }
        } else if (cf_def.min_compaction_threshold != null) {
            if (cf_def.min_compaction_threshold > 32) {
                throw new ConfigurationException("min_compaction_threshold cannot be greather than max_compaction_threshold (default 32)");
            }
        } else if (cf_def.max_compaction_threshold != null && cf_def.max_compaction_threshold < 4 && cf_def.max_compaction_threshold != 0) {
            throw new ConfigurationException("max_compaction_threshold cannot be less than min_compaction_threshold");
        }
    }

    public ColumnDefinition getColumnDefinition(ByteBuffer name) {
        return this.column_metadata.get(name);
    }

    public ColumnDefinition getColumnDefinitionForIndex(String indexName) {
        for (ColumnDefinition def : this.column_metadata.values()) {
            if (!indexName.equals(def.getIndexName())) continue;
            return def;
        }
        return null;
    }

    public static void addDefaultIndexNames(org.apache.cassandra.thrift.CfDef cf_def) throws InvalidRequestException {
        AbstractType comparator;
        if (cf_def.column_metadata == null) {
            return;
        }
        try {
            comparator = TypeParser.parse(cf_def.comparator_type);
        }
        catch (ConfigurationException e) {
            throw new InvalidRequestException(e.getMessage());
        }
        for (org.apache.cassandra.thrift.ColumnDef column : cf_def.column_metadata) {
            if (column.index_type == null || column.index_name != null) continue;
            column.index_name = CFMetaData.getDefaultIndexName(cf_def.name, comparator, column.name);
        }
    }

    public static String getDefaultIndexName(String cfName, AbstractType comparator, ByteBuffer columnName) {
        return (cfName + "_" + comparator.getString(columnName) + "_idx").replaceAll("\\W", "");
    }

    public IColumnSerializer getColumnSerializer() {
        if (this.cfType == ColumnFamilyType.Standard) {
            return Column.serializer();
        }
        return SuperColumn.serializer(this.subcolumnComparator);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("cfId", (Object)this.cfId).append("ksName", (Object)this.ksName).append("cfName", (Object)this.cfName).append("cfType", (Object)this.cfType).append("comparator", (Object)this.comparator).append("subcolumncomparator", (Object)this.subcolumnComparator).append("comment", (Object)this.comment).append("rowCacheSize", this.rowCacheSize).append("keyCacheSize", this.keyCacheSize).append("readRepairChance", this.readRepairChance).append("replicateOnWrite", this.replicateOnWrite).append("gcGraceSeconds", this.gcGraceSeconds).append("defaultValidator", (Object)this.defaultValidator).append("keyValidator", (Object)this.keyValidator).append("minCompactionThreshold", this.minCompactionThreshold).append("maxCompactionThreshold", this.maxCompactionThreshold).append("rowCacheSavePeriodInSeconds", this.rowCacheSavePeriodInSeconds).append("keyCacheSavePeriodInSeconds", this.keyCacheSavePeriodInSeconds).append("rowCacheKeysToSave", this.rowCacheKeysToSave).append("rowCacheProvider", (Object)this.rowCacheProvider).append("mergeShardsChance", this.mergeShardsChance).append("keyAlias", (Object)this.keyAlias).append("column_metadata", this.column_metadata).append("compactionStrategyClass", this.compactionStrategyClass).append("compactionStrategyOptions", this.compactionStrategyOptions).append("compressionOptions", this.compressionParameters.asThriftOptions()).toString();
    }
}

