/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.IndexScanCommand;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.ReadVerbHandler;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.Truncation;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.net.CachingMessageProducer;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.IMessageCallback;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.DatacenterReadCallback;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.IReadCommand;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.IWriteResponseHandler;
import org.apache.cassandra.service.RangeSliceResponseResolver;
import org.apache.cassandra.service.ReadCallback;
import org.apache.cassandra.service.RepairCallback;
import org.apache.cassandra.service.RowDigestResolver;
import org.apache.cassandra.service.RowRepairResolver;
import org.apache.cassandra.service.StorageProxyMBean;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.TruncateResponseHandler;
import org.apache.cassandra.service.WriteResponseHandler;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.LatencyTracker;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageProxy
implements StorageProxyMBean {
    private static final Logger logger = LoggerFactory.getLogger(StorageProxy.class);
    private static final LatencyTracker readStats = new LatencyTracker();
    private static final LatencyTracker rangeStats = new LatencyTracker();
    private static final LatencyTracker writeStats = new LatencyTracker();
    private static boolean hintedHandoffEnabled = DatabaseDescriptor.hintedHandoffEnabled();
    private static int maxHintWindow = DatabaseDescriptor.getMaxHintWindow();
    public static final String UNREACHABLE = "UNREACHABLE";
    private static final WritePerformer standardWritePerformer;
    private static final WritePerformer counterWritePerformer;
    private static final WritePerformer counterWriteOnCoordinatorPerformer;
    public static final StorageProxy instance;

    private StorageProxy() {
    }

    public static void mutate(List<? extends IMutation> mutations, ConsistencyLevel consistency_level) throws UnavailableException, TimeoutException {
        String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getLocalAddress());
        long startTime = System.nanoTime();
        ArrayList<IWriteResponseHandler> responseHandlers = new ArrayList<IWriteResponseHandler>();
        IMutation mostRecentMutation = null;
        try {
            Iterator<IMutation> i$ = mutations.iterator();
            while (i$.hasNext()) {
                IMutation mutation;
                mostRecentMutation = mutation = i$.next();
                if (mutation instanceof CounterMutation) {
                    responseHandlers.add(StorageProxy.mutateCounter((CounterMutation)mutation, localDataCenter));
                    continue;
                }
                responseHandlers.add(StorageProxy.performWrite(mutation, consistency_level, localDataCenter, standardWritePerformer));
            }
            for (IWriteResponseHandler responseHandler : responseHandlers) {
                responseHandler.get();
            }
        }
        catch (TimeoutException ex) {
            if (logger.isDebugEnabled()) {
                ArrayList<String> mstrings = new ArrayList<String>();
                for (IMutation iMutation : mutations) {
                    mstrings.add(iMutation.toString(true));
                }
                logger.debug("Write timeout {} for one (or more) of: ", (Object)ex.toString(), mstrings);
            }
            throw ex;
        }
        catch (IOException e) {
            assert (mostRecentMutation != null);
            throw new RuntimeException("error writing key " + ByteBufferUtil.bytesToHex(mostRecentMutation.key()), e);
        }
        finally {
            writeStats.addNano(System.nanoTime() - startTime);
        }
    }

    public static IWriteResponseHandler performWrite(IMutation mutation, ConsistencyLevel consistency_level, String localDataCenter, WritePerformer performer) throws UnavailableException, TimeoutException, IOException {
        String table = mutation.getTable();
        AbstractReplicationStrategy rs = Table.open(table).getReplicationStrategy();
        Collection<InetAddress> writeEndpoints = StorageProxy.getWriteEndpoints(table, mutation.key());
        Multimap<InetAddress, InetAddress> hintedEndpoints = rs.getHintedEndpoints(writeEndpoints);
        IWriteResponseHandler responseHandler = rs.getWriteResponseHandler(writeEndpoints, hintedEndpoints, consistency_level);
        responseHandler.assureSufficientLiveNodes();
        performer.apply(mutation, hintedEndpoints, responseHandler, localDataCenter, consistency_level);
        return responseHandler;
    }

    private static Collection<InetAddress> getWriteEndpoints(String table, ByteBuffer key) {
        StorageService ss = StorageService.instance;
        List<InetAddress> naturalEndpoints = ss.getNaturalEndpoints(table, key);
        return ss.getTokenMetadata().getWriteEndpoints((Token)StorageService.getPartitioner().getToken(key), table, (Collection<InetAddress>)naturalEndpoints);
    }

    public static void sendToHintedEndpoints(RowMutation rm, Multimap<InetAddress, InetAddress> hintedEndpoints, IWriteResponseHandler responseHandler, String localDataCenter, ConsistencyLevel consistency_level) throws IOException {
        HashMap<String, Multimap<Message, InetAddress>> dcMessages = new HashMap<String, Multimap<Message, InetAddress>>(hintedEndpoints.size());
        CachingMessageProducer producer = new CachingMessageProducer(rm);
        for (Map.Entry entry : hintedEndpoints.asMap().entrySet()) {
            InetAddress destination = (InetAddress)entry.getKey();
            Collection targets = (Collection)entry.getValue();
            String dc = DatabaseDescriptor.getEndpointSnitch().getDatacenter(destination);
            if (targets.size() == 1 && ((InetAddress)targets.iterator().next()).equals(destination)) {
                Multimap messages;
                if (destination.equals(FBUtilities.getLocalAddress())) {
                    StorageProxy.insertLocal(rm, responseHandler);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("insert writing key " + ByteBufferUtil.bytesToHex(rm.key()) + " to " + destination);
                }
                if ((messages = (Multimap)dcMessages.get(dc)) == null) {
                    messages = HashMultimap.create();
                    dcMessages.put(dc, (Multimap<Message, InetAddress>)messages);
                }
                messages.put((Object)producer.getMessage(Gossiper.instance.getVersion(destination)), (Object)destination);
                continue;
            }
            Message hintedMessage = rm.getMessage(Gossiper.instance.getVersion(destination));
            for (InetAddress target : targets) {
                if (target.equals(destination)) continue;
                StorageProxy.addHintHeader(hintedMessage, target);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("insert writing key " + ByteBufferUtil.bytesToHex(rm.key()) + " to " + destination + " for " + target);
            }
            if (targets.contains(destination) || consistency_level == ConsistencyLevel.ANY) {
                MessagingService.instance().sendRR(hintedMessage, destination, (IMessageCallback)responseHandler);
                continue;
            }
            MessagingService.instance().sendOneWay(hintedMessage, destination);
        }
        StorageProxy.sendMessages(localDataCenter, dcMessages, responseHandler);
    }

    private static void sendMessages(String localDataCenter, Map<String, Multimap<Message, InetAddress>> dcMessages, IWriteResponseHandler handler) throws IOException {
        for (Map.Entry<String, Multimap<Message, InetAddress>> entry : dcMessages.entrySet()) {
            String dataCenter = entry.getKey();
            for (Map.Entry messages : entry.getValue().asMap().entrySet()) {
                Message message = (Message)messages.getKey();
                message.removeHeader("FORWARD");
                if (dataCenter.equals(localDataCenter)) {
                    for (InetAddress destination : (Collection)messages.getValue()) {
                        MessagingService.instance().sendRR(message, destination, (IMessageCallback)handler);
                    }
                    continue;
                }
                Iterator iter = ((Collection)messages.getValue()).iterator();
                InetAddress target = (InetAddress)iter.next();
                while (iter.hasNext()) {
                    InetAddress destination = (InetAddress)iter.next();
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(bos);
                    byte[] previousHints = message.getHeader("FORWARD");
                    if (previousHints != null) {
                        dos.write(previousHints);
                    }
                    dos.write(destination.getAddress());
                    message.setHeader("FORWARD", bos.toByteArray());
                }
                MessagingService.instance().sendRR(message, target, (IMessageCallback)handler);
            }
        }
    }

    private static void addHintHeader(Message message, InetAddress target) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        byte[] previousHints = message.getHeader("HINT");
        if (previousHints != null) {
            dos.write(previousHints);
        }
        ByteBufferUtil.writeWithShortLength(ByteBufferUtil.bytes(target.getHostAddress()), dos);
        message.setHeader("HINT", bos.toByteArray());
    }

    private static void insertLocal(final RowMutation rm, final IWriteResponseHandler responseHandler) {
        if (logger.isDebugEnabled()) {
            logger.debug("insert writing local " + rm.toString(true));
        }
        DroppableRunnable runnable = new DroppableRunnable(StorageService.Verb.MUTATION){

            @Override
            public void runMayThrow() throws IOException {
                rm.localCopy().apply();
                responseHandler.response(null);
            }
        };
        StageManager.getStage(Stage.MUTATION).execute(runnable);
    }

    public static IWriteResponseHandler mutateCounter(CounterMutation cm, String localDataCenter) throws UnavailableException, TimeoutException, IOException {
        InetAddress endpoint = StorageProxy.findSuitableEndpoint(cm.getTable(), cm.key(), localDataCenter);
        if (endpoint.equals(FBUtilities.getLocalAddress())) {
            return StorageProxy.applyCounterMutationOnCoordinator(cm, localDataCenter);
        }
        String table = cm.getTable();
        AbstractReplicationStrategy rs = Table.open(table).getReplicationStrategy();
        Collection<InetAddress> writeEndpoints = StorageProxy.getWriteEndpoints(table, cm.key());
        Multimap<InetAddress, InetAddress> hintedEndpoints = rs.getHintedEndpoints(writeEndpoints);
        rs.getWriteResponseHandler(writeEndpoints, hintedEndpoints, cm.consistency()).assureSufficientLiveNodes();
        IWriteResponseHandler responseHandler = WriteResponseHandler.create(endpoint);
        Message message = cm.makeMutationMessage(Gossiper.instance.getVersion(endpoint));
        if (logger.isDebugEnabled()) {
            logger.debug("forwarding counter update of key " + ByteBufferUtil.bytesToHex(cm.key()) + " to " + endpoint);
        }
        MessagingService.instance().sendRR(message, endpoint, (IMessageCallback)responseHandler);
        return responseHandler;
    }

    private static InetAddress findSuitableEndpoint(String table, ByteBuffer key, String localDataCenter) throws UnavailableException {
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        List<InetAddress> endpoints = StorageService.instance.getLiveNaturalEndpoints(table, key);
        if (endpoints.isEmpty()) {
            throw new UnavailableException();
        }
        ArrayList<InetAddress> localEndpoints = new ArrayList<InetAddress>();
        for (InetAddress endpoint : endpoints) {
            if (!snitch.getDatacenter(endpoint).equals(localDataCenter)) continue;
            localEndpoints.add(endpoint);
        }
        if (localEndpoints.isEmpty()) {
            snitch.sortByProximity(FBUtilities.getLocalAddress(), endpoints);
            return endpoints.get(0);
        }
        return (InetAddress)localEndpoints.get(FBUtilities.threadLocalRandom().nextInt(localEndpoints.size()));
    }

    public static IWriteResponseHandler applyCounterMutationOnLeader(CounterMutation cm, String localDataCenter) throws UnavailableException, TimeoutException, IOException {
        return StorageProxy.performWrite(cm, cm.consistency(), localDataCenter, counterWritePerformer);
    }

    public static IWriteResponseHandler applyCounterMutationOnCoordinator(CounterMutation cm, String localDataCenter) throws UnavailableException, TimeoutException, IOException {
        return StorageProxy.performWrite(cm, cm.consistency(), localDataCenter, counterWriteOnCoordinatorPerformer);
    }

    private static Runnable counterWriteTask(final IMutation mutation, final Multimap<InetAddress, InetAddress> hintedEndpoints, final IWriteResponseHandler responseHandler, final String localDataCenter, final ConsistencyLevel consistency_level) {
        return new DroppableRunnable(StorageService.Verb.MUTATION){

            @Override
            public void runMayThrow() throws IOException {
                assert (mutation instanceof CounterMutation);
                final CounterMutation cm = (CounterMutation)mutation;
                cm.apply();
                responseHandler.response(null);
                InetAddress local = FBUtilities.getLocalAddress();
                hintedEndpoints.remove((Object)local, (Object)local);
                if (cm.shouldReplicateOnWrite() && !hintedEndpoints.isEmpty()) {
                    StageManager.getStage(Stage.REPLICATE_ON_WRITE).execute(new DroppableRunnable(StorageService.Verb.READ){

                        @Override
                        public void runMayThrow() throws IOException {
                            StorageProxy.sendToHintedEndpoints(cm.makeReplicationMutation(), (Multimap<InetAddress, InetAddress>)hintedEndpoints, responseHandler, localDataCenter, consistency_level);
                        }
                    });
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Row> read(List<ReadCommand> commands, ConsistencyLevel consistency_level) throws IOException, UnavailableException, TimeoutException, InvalidRequestException {
        List<Row> rows;
        if (StorageService.instance.isBootstrapMode()) {
            throw new UnavailableException();
        }
        long startTime = System.nanoTime();
        try {
            rows = StorageProxy.fetchRows(commands, consistency_level);
        }
        finally {
            readStats.addNano(System.nanoTime() - startTime);
        }
        return rows;
    }

    private static List<Row> fetchRows(List<ReadCommand> commands, ConsistencyLevel consistency_level) throws IOException, UnavailableException, TimeoutException {
        Row row;
        ArrayList<ReadCallback<Row>> readCallbacks = new ArrayList<ReadCallback<Row>>();
        ArrayList<Row> rows = new ArrayList<Row>();
        for (ReadCommand command : commands) {
            assert (!command.isDigestQuery());
            logger.debug("Command/ConsistencyLevel is {}/{}", (Object)command, (Object)consistency_level);
            List<InetAddress> list = StorageService.instance.getLiveNaturalEndpoints(command.table, command.key);
            DatabaseDescriptor.getEndpointSnitch().sortByProximity(FBUtilities.getLocalAddress(), list);
            RowDigestResolver resolver = new RowDigestResolver(command.table, command.key);
            ReadCallback<Row> handler = StorageProxy.getReadCallback(resolver, command, consistency_level, list);
            handler.assureSufficientLiveNodes();
            assert (!handler.endpoints.isEmpty());
            readCallbacks.add(handler);
            InetAddress dataPoint = handler.endpoints.get(0);
            if (dataPoint.equals(FBUtilities.getLocalAddress())) {
                logger.debug("reading data locally");
                StageManager.getStage(Stage.READ).execute(new LocalReadRunnable(command, handler));
            } else {
                logger.debug("reading data from {}", (Object)dataPoint);
                MessagingService.instance().sendRR(command, dataPoint, handler);
            }
            if (handler.endpoints.size() == 1) continue;
            ReadCommand digestCommand = command.copy();
            digestCommand.setDigestQuery(true);
            CachingMessageProducer producer = null;
            for (InetAddress digestPoint : handler.endpoints.subList(1, handler.endpoints.size())) {
                if (digestPoint.equals(FBUtilities.getLocalAddress())) {
                    logger.debug("reading digest locally");
                    StageManager.getStage(Stage.READ).execute(new LocalReadRunnable(digestCommand, handler));
                    continue;
                }
                logger.debug("reading digest from {}", (Object)digestPoint);
                if (producer == null) {
                    producer = new CachingMessageProducer(digestCommand);
                }
                MessagingService.instance().sendRR(producer, digestPoint, handler);
            }
        }
        ArrayList<RepairCallback<Row>> repairResponseHandlers = null;
        for (int i = 0; i < commands.size(); ++i) {
            ReadCallback readCallback = (ReadCallback)readCallbacks.get(i);
            ReadCommand command = commands.get(i);
            try {
                long startTime2 = System.currentTimeMillis();
                row = (Row)readCallback.get();
                if (row != null) {
                    rows.add(row);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Read: " + (System.currentTimeMillis() - startTime2) + " ms.");
                continue;
            }
            catch (TimeoutException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Read timeout: {}", (Object)ex.toString());
                }
                throw ex;
            }
            catch (DigestMismatchException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Digest mismatch: {}", (Object)ex.toString());
                }
                RowRepairResolver resolver = new RowRepairResolver(command.table, command.key);
                RepairCallback<Row> repairHandler = new RepairCallback<Row>(resolver, readCallback.endpoints);
                CachingMessageProducer producer = new CachingMessageProducer(command);
                for (InetAddress endpoint : readCallback.endpoints) {
                    MessagingService.instance().sendRR(producer, endpoint, repairHandler);
                }
                if (repairResponseHandlers == null) {
                    repairResponseHandlers = new ArrayList<RepairCallback<Row>>();
                }
                repairResponseHandlers.add(repairHandler);
            }
        }
        if (repairResponseHandlers != null) {
            for (RepairCallback repairCallback : repairResponseHandlers) {
                try {
                    row = (Row)repairCallback.get();
                    if (row == null) continue;
                    rows.add(row);
                }
                catch (DigestMismatchException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        return rows;
    }

    static <T> ReadCallback<T> getReadCallback(IResponseResolver<T> resolver, IReadCommand command, ConsistencyLevel consistencyLevel, List<InetAddress> endpoints) {
        if (consistencyLevel.equals((Object)ConsistencyLevel.LOCAL_QUORUM) || consistencyLevel.equals((Object)ConsistencyLevel.EACH_QUORUM)) {
            return new DatacenterReadCallback((IResponseResolver)resolver, consistencyLevel, command, endpoints);
        }
        return new ReadCallback<T>(resolver, consistencyLevel, command, endpoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Row> getRangeSlice(RangeSliceCommand command, ConsistencyLevel consistency_level) throws IOException, UnavailableException, TimeoutException {
        ArrayList<Row> rows;
        if (logger.isDebugEnabled()) {
            logger.debug(command.toString());
        }
        long startTime = System.nanoTime();
        try {
            rows = new ArrayList<Row>(command.max_keys);
            List<AbstractBounds> ranges = StorageProxy.getRestrictedRanges(command.range);
            for (AbstractBounds range : ranges) {
                List<InetAddress> liveEndpoints = StorageService.instance.getLiveNaturalEndpoints(command.keyspace, range.right);
                DatabaseDescriptor.getEndpointSnitch().sortByProximity(FBUtilities.getLocalAddress(), liveEndpoints);
                if (consistency_level == ConsistencyLevel.ONE && !liveEndpoints.isEmpty() && liveEndpoints.get(0).equals(FBUtilities.getLocalAddress())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("local range slice");
                    }
                    ColumnFamilyStore cfs = Table.open(command.keyspace).getColumnFamilyStore(command.column_family);
                    try {
                        rows.addAll(cfs.getRangeSlice(command.super_column, range, command.max_keys, QueryFilter.getFilter(command.predicate, cfs.getComparator())));
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e.getCause());
                    }
                    catch (InterruptedException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                RangeSliceCommand c2 = new RangeSliceCommand(command.keyspace, command.column_family, command.super_column, command.predicate, range, command.max_keys);
                RangeSliceResponseResolver resolver = new RangeSliceResponseResolver(command.keyspace, liveEndpoints);
                ReadCallback<Iterable<Row>> handler = StorageProxy.getReadCallback(resolver, command, consistency_level, liveEndpoints);
                handler.assureSufficientLiveNodes();
                for (InetAddress endpoint : liveEndpoints) {
                    MessagingService.instance().sendRR(c2, endpoint, handler);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("reading " + c2 + " from " + endpoint);
                }
                try {
                    for (Row row : handler.get()) {
                        rows.add(row);
                        logger.debug("range slices read {}", row.key);
                    }
                }
                catch (TimeoutException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Range slice timeout: {}", (Object)ex.toString());
                    }
                    throw ex;
                }
                catch (DigestMismatchException e) {
                    throw new AssertionError((Object)e);
                }
                if (rows.size() < command.max_keys) continue;
                break;
            }
        }
        finally {
            rangeStats.addNano(System.nanoTime() - startTime);
        }
        return rows.size() > command.max_keys ? rows.subList(0, command.max_keys) : rows;
    }

    public static Map<String, List<String>> describeSchemaVersions() {
        String myVersion = DatabaseDescriptor.getDefsVersion().toString();
        final ConcurrentHashMap versions = new ConcurrentHashMap();
        Set<InetAddress> liveHosts = Gossiper.instance.getLiveMembers();
        final CountDownLatch latch = new CountDownLatch(liveHosts.size());
        IAsyncCallback cb = new IAsyncCallback(){

            @Override
            public void response(Message message) {
                logger.debug("Received schema check response from " + message.getFrom().getHostAddress());
                UUID theirVersion = UUID.fromString(new String(message.getMessageBody()));
                versions.put(message.getFrom(), theirVersion);
                latch.countDown();
            }

            @Override
            public boolean isLatencyForSnitch() {
                return false;
            }
        };
        for (InetAddress endpoint : liveHosts) {
            Message message = new Message(FBUtilities.getLocalAddress(), StorageService.Verb.SCHEMA_CHECK, ArrayUtils.EMPTY_BYTE_ARRAY, Gossiper.instance.getVersion(endpoint));
            MessagingService.instance().sendRR(message, endpoint, (IMessageCallback)cb);
        }
        try {
            latch.await(DatabaseDescriptor.getRpcTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)"This latch shouldn't have been interrupted.");
        }
        logger.debug("My version is " + myVersion);
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        Iterable allHosts = Iterables.concat(Gossiper.instance.getLiveMembers(), Gossiper.instance.getUnreachableMembers());
        for (InetAddress inetAddress : allHosts) {
            UUID version = (UUID)versions.get(inetAddress);
            String stringVersion = version == null ? UNREACHABLE : version.toString();
            ArrayList<String> hosts = (ArrayList<String>)results.get(stringVersion);
            if (hosts == null) {
                hosts = new ArrayList<String>();
                results.put(stringVersion, hosts);
            }
            hosts.add(inetAddress.getHostAddress());
        }
        if (results.get(UNREACHABLE) != null) {
            logger.debug("Hosts not in agreement. Didn't get a response from everybody: " + StringUtils.join((Collection)((Collection)results.get(UNREACHABLE)), (String)","));
        }
        for (Map.Entry entry : results.entrySet()) {
            if (((String)entry.getKey()).equals(UNREACHABLE) || ((String)entry.getKey()).equals(myVersion)) continue;
            for (String host : (List)entry.getValue()) {
                logger.debug("%s disagrees (%s)", (Object)host, entry.getKey());
            }
        }
        if (results.size() == 1) {
            logger.debug("Schemas are in agreement.");
        }
        return results;
    }

    static List<AbstractBounds> getRestrictedRanges(AbstractBounds queryRange) {
        if (queryRange instanceof Bounds && queryRange.left.equals(queryRange.right) && !queryRange.left.equals(StorageService.getPartitioner().getMinimumToken())) {
            if (logger.isDebugEnabled()) {
                logger.debug("restricted single token match for query " + queryRange);
            }
            return Collections.singletonList(queryRange);
        }
        TokenMetadata tokenMetadata = StorageService.instance.getTokenMetadata();
        ArrayList<AbstractBounds> ranges = new ArrayList<AbstractBounds>();
        Iterator<Token> ringIter = TokenMetadata.ringIterator(tokenMetadata.sortedTokens(), queryRange.left, true);
        AbstractBounds remainder = queryRange;
        while (ringIter.hasNext()) {
            Token token = ringIter.next();
            if (remainder == null || !remainder.left.equals(token) && !remainder.contains(token)) break;
            Pair<AbstractBounds, AbstractBounds> splits = remainder.split(token);
            if (splits.left != null) {
                ranges.add((AbstractBounds)splits.left);
            }
            remainder = (AbstractBounds)splits.right;
        }
        if (remainder != null) {
            ranges.add(remainder);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("restricted ranges for query " + queryRange + " are " + ranges);
        }
        return ranges;
    }

    @Override
    public long getReadOperations() {
        return readStats.getOpCount();
    }

    @Override
    public long getTotalReadLatencyMicros() {
        return readStats.getTotalLatencyMicros();
    }

    @Override
    public double getRecentReadLatencyMicros() {
        return readStats.getRecentLatencyMicros();
    }

    @Override
    public long[] getTotalReadLatencyHistogramMicros() {
        return readStats.getTotalLatencyHistogramMicros();
    }

    @Override
    public long[] getRecentReadLatencyHistogramMicros() {
        return readStats.getRecentLatencyHistogramMicros();
    }

    @Override
    public long getRangeOperations() {
        return rangeStats.getOpCount();
    }

    @Override
    public long getTotalRangeLatencyMicros() {
        return rangeStats.getTotalLatencyMicros();
    }

    @Override
    public double getRecentRangeLatencyMicros() {
        return rangeStats.getRecentLatencyMicros();
    }

    @Override
    public long[] getTotalRangeLatencyHistogramMicros() {
        return rangeStats.getTotalLatencyHistogramMicros();
    }

    @Override
    public long[] getRecentRangeLatencyHistogramMicros() {
        return rangeStats.getRecentLatencyHistogramMicros();
    }

    @Override
    public long getWriteOperations() {
        return writeStats.getOpCount();
    }

    @Override
    public long getTotalWriteLatencyMicros() {
        return writeStats.getTotalLatencyMicros();
    }

    @Override
    public double getRecentWriteLatencyMicros() {
        return writeStats.getRecentLatencyMicros();
    }

    @Override
    public long[] getTotalWriteLatencyHistogramMicros() {
        return writeStats.getTotalLatencyHistogramMicros();
    }

    @Override
    public long[] getRecentWriteLatencyHistogramMicros() {
        return writeStats.getRecentLatencyHistogramMicros();
    }

    public static List<Row> scan(final String keyspace, String column_family, IndexClause index_clause, SlicePredicate column_predicate, ConsistencyLevel consistency_level) throws IOException, TimeoutException, UnavailableException {
        IPartitioner p = StorageService.getPartitioner();
        Object leftToken = index_clause.start_key == null ? p.getMinimumToken() : p.getToken(index_clause.start_key);
        List<AbstractBounds> ranges = StorageProxy.getRestrictedRanges(new Bounds((Token)leftToken, (Token)p.getMinimumToken()));
        logger.debug("scan ranges are " + StringUtils.join(ranges, (String)","));
        ArrayList<Row> rows = new ArrayList<Row>(index_clause.count);
        for (AbstractBounds range : ranges) {
            List<InetAddress> liveEndpoints = StorageService.instance.getLiveNaturalEndpoints(keyspace, range.right);
            DatabaseDescriptor.getEndpointSnitch().sortByProximity(FBUtilities.getLocalAddress(), liveEndpoints);
            RangeSliceResponseResolver resolver = new RangeSliceResponseResolver(keyspace, liveEndpoints);
            IReadCommand iCommand = new IReadCommand(){

                @Override
                public String getKeyspace() {
                    return keyspace;
                }
            };
            ReadCallback<Iterable<Row>> handler = StorageProxy.getReadCallback(resolver, iCommand, consistency_level, liveEndpoints);
            handler.assureSufficientLiveNodes();
            IndexScanCommand command = new IndexScanCommand(keyspace, column_family, index_clause, column_predicate, range);
            CachingMessageProducer producer = new CachingMessageProducer(command);
            for (InetAddress endpoint : liveEndpoints) {
                MessagingService.instance().sendRR(producer, endpoint, handler);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("reading " + command + " from " + endpoint);
            }
            try {
                for (Row row : handler.get()) {
                    rows.add(row);
                    logger.debug("read {}", (Object)row);
                }
            }
            catch (TimeoutException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Index scan timeout: {}", (Object)ex.toString());
                }
                throw ex;
            }
            catch (DigestMismatchException e) {
                throw new RuntimeException(e);
            }
            if (rows.size() < index_clause.count) continue;
            return rows.subList(0, index_clause.count);
        }
        return rows;
    }

    @Override
    public boolean getHintedHandoffEnabled() {
        return hintedHandoffEnabled;
    }

    @Override
    public void setHintedHandoffEnabled(boolean b) {
        hintedHandoffEnabled = b;
    }

    public static boolean isHintedHandoffEnabled() {
        return hintedHandoffEnabled;
    }

    @Override
    public int getMaxHintWindow() {
        return maxHintWindow;
    }

    @Override
    public void setMaxHintWindow(int ms) {
        maxHintWindow = ms;
    }

    public static boolean shouldHint(InetAddress ep) {
        return Gossiper.instance.getEndpointDowntime(ep) <= (long)maxHintWindow;
    }

    public static void truncateBlocking(String keyspace, String cfname) throws UnavailableException, TimeoutException, IOException {
        logger.debug("Starting a blocking truncate operation on keyspace {}, CF ", (Object)keyspace, (Object)cfname);
        if (StorageProxy.isAnyHostDown()) {
            logger.info("Cannot perform truncate, some hosts are down");
            throw new UnavailableException();
        }
        Set<InetAddress> allEndpoints = Gossiper.instance.getLiveMembers();
        int blockFor = allEndpoints.size();
        TruncateResponseHandler responseHandler = new TruncateResponseHandler(blockFor);
        logger.debug("Starting to send truncate messages to hosts {}", allEndpoints);
        Truncation truncation = new Truncation(keyspace, cfname);
        CachingMessageProducer producer = new CachingMessageProducer(truncation);
        for (InetAddress endpoint : allEndpoints) {
            MessagingService.instance().sendRR(producer, endpoint, responseHandler);
        }
        logger.debug("Sent all truncate messages, now waiting for {} responses", (Object)blockFor);
        responseHandler.get();
        logger.debug("truncate done");
    }

    private static boolean isAnyHostDown() {
        return !Gossiper.instance.getUnreachableMembers().isEmpty();
    }

    static {
        instance = new StorageProxy();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(new StorageProxy(), new ObjectName("org.apache.cassandra.db:type=StorageProxy"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        standardWritePerformer = new WritePerformer(){

            @Override
            public void apply(IMutation mutation, Multimap<InetAddress, InetAddress> hintedEndpoints, IWriteResponseHandler responseHandler, String localDataCenter, ConsistencyLevel consistency_level) throws IOException {
                assert (mutation instanceof RowMutation);
                StorageProxy.sendToHintedEndpoints((RowMutation)mutation, hintedEndpoints, responseHandler, localDataCenter, consistency_level);
            }
        };
        counterWritePerformer = new WritePerformer(){

            @Override
            public void apply(IMutation mutation, Multimap<InetAddress, InetAddress> hintedEndpoints, IWriteResponseHandler responseHandler, String localDataCenter, ConsistencyLevel consistency_level) throws IOException {
                if (logger.isDebugEnabled()) {
                    logger.debug("insert writing local & replicate " + mutation.toString(true));
                }
                Runnable runnable = StorageProxy.counterWriteTask(mutation, (Multimap<InetAddress, InetAddress>)hintedEndpoints, responseHandler, localDataCenter, consistency_level);
                runnable.run();
            }
        };
        counterWriteOnCoordinatorPerformer = new WritePerformer(){

            @Override
            public void apply(IMutation mutation, Multimap<InetAddress, InetAddress> hintedEndpoints, IWriteResponseHandler responseHandler, String localDataCenter, ConsistencyLevel consistency_level) throws IOException {
                if (logger.isDebugEnabled()) {
                    logger.debug("insert writing local & replicate " + mutation.toString(true));
                }
                Runnable runnable = StorageProxy.counterWriteTask(mutation, (Multimap<InetAddress, InetAddress>)hintedEndpoints, responseHandler, localDataCenter, consistency_level);
                StageManager.getStage(Stage.MUTATION).execute(runnable);
            }
        };
    }

    private static abstract class DroppableRunnable
    implements Runnable {
        private final long constructionTime = System.currentTimeMillis();
        private final StorageService.Verb verb;

        public DroppableRunnable(StorageService.Verb verb) {
            this.verb = verb;
        }

        @Override
        public final void run() {
            if (System.currentTimeMillis() > this.constructionTime + DatabaseDescriptor.getRpcTimeout()) {
                MessagingService.instance().incrementDroppedMessages(this.verb);
                return;
            }
            try {
                this.runMayThrow();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract void runMayThrow() throws Exception;
    }

    public static interface WritePerformer {
        public void apply(IMutation var1, Multimap<InetAddress, InetAddress> var2, IWriteResponseHandler var3, String var4, ConsistencyLevel var5) throws IOException;
    }

    static class LocalReadRunnable
    extends DroppableRunnable {
        private final ReadCommand command;
        private final ReadCallback<Row> handler;
        private final long start = System.currentTimeMillis();

        LocalReadRunnable(ReadCommand command, ReadCallback<Row> handler) {
            super(StorageService.Verb.READ);
            this.command = command;
            this.handler = handler;
        }

        @Override
        protected void runMayThrow() throws IOException {
            if (logger.isDebugEnabled()) {
                logger.debug("LocalReadRunnable reading " + this.command);
            }
            Table table = Table.open(this.command.table);
            ReadResponse result = ReadVerbHandler.getResponse(this.command, this.command.getRow(table));
            MessagingService.instance().addLatency(FBUtilities.getLocalAddress(), System.currentTimeMillis() - this.start);
            this.handler.response(result);
        }
    }
}

