/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnIndexer;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.PrecompactedRow;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.IIterableColumns;
import org.apache.cassandra.utils.ReducingIterator;
import org.apache.commons.collections.iterators.CollatingIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazilyCompactedRow
extends AbstractCompactedRow
implements IIterableColumns {
    private static Logger logger = LoggerFactory.getLogger(LazilyCompactedRow.class);
    private final List<SSTableIdentityIterator> rows;
    private final CompactionController controller;
    private final boolean shouldPurge;
    private final DataOutputBuffer headerBuffer;
    private ColumnFamily emptyColumnFamily;
    private LazyColumnIterator reducer;
    private int columnCount;
    private long columnSerializedSize;

    public LazilyCompactedRow(CompactionController controller, List<SSTableIdentityIterator> rows) {
        super(rows.get(0).getKey());
        this.rows = rows;
        this.controller = controller;
        this.shouldPurge = controller.shouldPurge(this.key);
        for (SSTableIdentityIterator row : rows) {
            ColumnFamily cf = row.getColumnFamily();
            if (this.emptyColumnFamily == null) {
                this.emptyColumnFamily = cf;
                continue;
            }
            this.emptyColumnFamily.delete(cf);
        }
        this.headerBuffer = new DataOutputBuffer();
        ColumnIndexer.serialize(this, this.headerBuffer);
        this.columnCount = this.reducer == null ? 0 : this.reducer.size;
        this.columnSerializedSize = this.reducer == null ? 0L : this.reducer.serializedSize;
        this.reducer = null;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        long secondPassColumnSize;
        DataOutputBuffer clockOut = new DataOutputBuffer();
        ColumnFamily.serializer().serializeCFInfo(this.emptyColumnFamily, clockOut);
        long dataSize = (long)(this.headerBuffer.getLength() + clockOut.getLength()) + this.columnSerializedSize;
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("header / clock / column sizes are %s / %s / %s", this.headerBuffer.getLength(), clockOut.getLength(), this.columnSerializedSize));
        }
        assert (dataSize > 0L);
        out.writeLong(dataSize);
        out.write(this.headerBuffer.getData(), 0, this.headerBuffer.getLength());
        out.write(clockOut.getData(), 0, clockOut.getLength());
        out.writeInt(this.columnCount);
        for (IColumn column : this) {
            this.emptyColumnFamily.getColumnSerializer().serialize(column, out);
        }
        long l = secondPassColumnSize = this.reducer == null ? 0L : this.reducer.serializedSize;
        assert (secondPassColumnSize == this.columnSerializedSize) : "originally calculated column size of " + this.columnSerializedSize + " but now it is " + secondPassColumnSize;
    }

    @Override
    public void update(MessageDigest digest) {
        DataOutputBuffer out = new DataOutputBuffer();
        try {
            ColumnFamily.serializer().serializeCFInfo(this.emptyColumnFamily, out);
            out.writeInt(this.columnCount);
            digest.update(out.getData(), 0, out.getLength());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        Iterator<IColumn> iter = this.iterator();
        while (iter.hasNext()) {
            iter.next().updateDigest(digest);
        }
    }

    @Override
    public boolean isEmpty() {
        boolean cfIrrelevant = this.shouldPurge ? ColumnFamilyStore.removeDeletedCF(this.emptyColumnFamily, this.controller.gcBefore) == null : !this.emptyColumnFamily.isMarkedForDelete();
        return cfIrrelevant && this.columnCount == 0;
    }

    @Override
    public int getEstimatedColumnCount() {
        int n = 0;
        for (SSTableIdentityIterator row : this.rows) {
            n += row.columnCount;
        }
        return n;
    }

    @Override
    public AbstractType getComparator() {
        return this.emptyColumnFamily.getComparator();
    }

    @Override
    public Iterator<IColumn> iterator() {
        for (SSTableIdentityIterator row : this.rows) {
            row.reset();
        }
        this.reducer = new LazyColumnIterator((Iterator<IColumn>)new CollatingIterator(this.getComparator().columnComparator, this.rows));
        return Iterators.filter((Iterator)this.reducer, (Predicate)Predicates.notNull());
    }

    @Override
    public int columnCount() {
        return this.columnCount;
    }

    private class LazyColumnIterator
    extends ReducingIterator<IColumn, IColumn> {
        ColumnFamily container;
        long serializedSize;
        int size;

        public LazyColumnIterator(Iterator<IColumn> source) {
            super(source);
            this.container = LazilyCompactedRow.this.emptyColumnFamily.cloneMeShallow();
            this.serializedSize = 4L;
            this.size = 0;
        }

        @Override
        protected boolean isEqual(IColumn o1, IColumn o2) {
            return o1.name().equals(o2.name());
        }

        @Override
        public void reduce(IColumn current) {
            this.container.addColumn(current);
        }

        @Override
        protected IColumn getReduced() {
            ColumnFamily purged = PrecompactedRow.removeDeletedAndOldShards(LazilyCompactedRow.this.key, LazilyCompactedRow.this.shouldPurge, LazilyCompactedRow.this.controller, this.container);
            if (purged == null || !purged.iterator().hasNext()) {
                this.container.clear();
                return null;
            }
            IColumn reduced = purged.iterator().next();
            this.container.clear();
            this.serializedSize += (long)reduced.serializedSize();
            ++this.size;
            return reduced;
        }
    }
}

