/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.context.IContext;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.service.IWriteResponseHandler;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.NodeId;
import org.apache.log4j.Logger;

public class CounterColumn
extends Column {
    private static final Logger logger = Logger.getLogger(CounterColumn.class);
    protected static final CounterContext contextManager = CounterContext.instance();
    private final long timestampOfLastDelete;

    public CounterColumn(ByteBuffer name, long value, long timestamp) {
        this(name, contextManager.create(value), timestamp);
    }

    public CounterColumn(ByteBuffer name, long value, long timestamp, long timestampOfLastDelete) {
        this(name, contextManager.create(value), timestamp, timestampOfLastDelete);
    }

    public CounterColumn(ByteBuffer name, ByteBuffer value, long timestamp) {
        this(name, value, timestamp, Long.MIN_VALUE);
    }

    public CounterColumn(ByteBuffer name, ByteBuffer value, long timestamp, long timestampOfLastDelete) {
        super(name, value, timestamp);
        this.timestampOfLastDelete = timestampOfLastDelete;
    }

    public long timestampOfLastDelete() {
        return this.timestampOfLastDelete;
    }

    public long total() {
        return contextManager.total(this.value);
    }

    @Override
    public int size() {
        return super.size() + 8;
    }

    @Override
    public IColumn diff(IColumn column) {
        assert (column instanceof CounterColumn) : "Wrong class type.";
        if (this.timestamp() < column.timestamp()) {
            return column;
        }
        if (this.timestampOfLastDelete() < ((CounterColumn)column).timestampOfLastDelete()) {
            return column;
        }
        IContext.ContextRelationship rel = contextManager.diff(column.value(), this.value());
        if (IContext.ContextRelationship.GREATER_THAN == rel || IContext.ContextRelationship.DISJOINT == rel) {
            return column;
        }
        return null;
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(this.name.duplicate());
        contextManager.updateDigest(digest, this.value);
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            buffer.writeLong(this.timestamp);
            buffer.writeByte(this.serializationFlags());
            buffer.writeLong(this.timestampOfLastDelete);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        digest.update(buffer.getData(), 0, buffer.getLength());
    }

    @Override
    public IColumn reconcile(IColumn column) {
        assert (column instanceof CounterColumn || column instanceof DeletedColumn) : "Wrong class type.";
        if (column.isMarkedForDelete()) {
            if (this.timestamp() < column.timestamp()) {
                return column;
            }
            if (this.timestampOfLastDelete() >= column.timestamp()) {
                return this;
            }
            return new CounterColumn(this.name(), this.value(), this.timestamp(), column.timestamp());
        }
        if (this.timestamp() < ((CounterColumn)column).timestampOfLastDelete()) {
            return column;
        }
        if (this.timestampOfLastDelete() > column.timestamp()) {
            return this;
        }
        return new CounterColumn(this.name(), contextManager.merge(this.value(), column.value()), Math.max(this.timestamp(), column.timestamp()), Math.max(this.timestampOfLastDelete(), ((CounterColumn)column).timestampOfLastDelete()));
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.timestampOfLastDelete == ((CounterColumn)o).timestampOfLastDelete;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.timestampOfLastDelete ^ this.timestampOfLastDelete >>> 32);
        return result;
    }

    @Override
    public IColumn localCopy(ColumnFamilyStore cfs) {
        return new CounterColumn(cfs.internOrCopy(this.name), ByteBufferUtil.clone(this.value), this.timestamp, this.timestampOfLastDelete);
    }

    @Override
    public String getString(AbstractType comparator) {
        StringBuilder sb = new StringBuilder();
        sb.append(comparator.getString(this.name));
        sb.append(":");
        sb.append(this.isMarkedForDelete());
        sb.append(":");
        sb.append(contextManager.toString(this.value));
        sb.append("@");
        sb.append(this.timestamp());
        sb.append("!");
        sb.append(this.timestampOfLastDelete);
        return sb.toString();
    }

    @Override
    public int serializationFlags() {
        return 4;
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        this.validateName(metadata);
        contextManager.validateContext(this.value());
    }

    public boolean hasNodeId(NodeId id) {
        return contextManager.hasNodeId(this.value(), id);
    }

    private CounterColumn computeOldShardMerger(int mergeBefore) {
        ByteBuffer bb = contextManager.computeOldShardMerger(this.value(), NodeId.getOldLocalNodeIds(), mergeBefore);
        if (bb == null) {
            return null;
        }
        return new CounterColumn(this.name(), bb, this.timestamp(), this.timestampOfLastDelete);
    }

    private CounterColumn removeOldShards(int gcBefore) {
        ByteBuffer bb = contextManager.removeOldShards(this.value(), gcBefore);
        if (bb == this.value()) {
            return this;
        }
        return new CounterColumn(this.name(), bb, this.timestamp(), this.timestampOfLastDelete);
    }

    public static void mergeAndRemoveOldShards(DecoratedKey key, ColumnFamily cf, int gcBefore, int mergeBefore) {
        ColumnFamily remoteMerger = null;
        if (!cf.isSuper()) {
            for (Map.Entry<ByteBuffer, IColumn> entry : cf.getColumnsMap().entrySet()) {
                CounterColumn cleaned;
                ByteBuffer cname = entry.getKey();
                IColumn c = entry.getValue();
                if (!(c instanceof CounterColumn)) continue;
                CounterColumn cc = (CounterColumn)c;
                CounterColumn shardMerger = cc.computeOldShardMerger(mergeBefore);
                CounterColumn merged = cc;
                if (shardMerger != null) {
                    merged = (CounterColumn)cc.reconcile(shardMerger);
                    if (remoteMerger == null) {
                        remoteMerger = cf.cloneMeShallow();
                    }
                    remoteMerger.addColumn(merged);
                }
                if ((cleaned = merged.removeOldShards(gcBefore)) == cc) continue;
                cf.remove(cname);
                cf.addColumn(cleaned);
            }
        } else {
            for (Map.Entry<ByteBuffer, IColumn> entry : cf.getColumnsMap().entrySet()) {
                SuperColumn c = (SuperColumn)entry.getValue();
                for (IColumn subColumn : c.getSubColumns()) {
                    CounterColumn cleaned;
                    if (!(subColumn instanceof CounterColumn)) continue;
                    CounterColumn cc = (CounterColumn)subColumn;
                    CounterColumn shardMerger = cc.computeOldShardMerger(mergeBefore);
                    CounterColumn merged = cc;
                    if (shardMerger != null) {
                        merged = (CounterColumn)cc.reconcile(shardMerger);
                        if (remoteMerger == null) {
                            remoteMerger = cf.cloneMeShallow();
                        }
                        remoteMerger.addColumn(c.name(), merged);
                    }
                    if ((cleaned = merged.removeOldShards(gcBefore)) == subColumn) continue;
                    c.remove(subColumn.name());
                    c.addColumn(cleaned);
                }
            }
        }
        if (remoteMerger != null) {
            try {
                CounterColumn.sendToOtherReplica(key, remoteMerger);
            }
            catch (Exception e) {
                logger.error((Object)"Error while sending shard merger mutation to remote endpoints", (Throwable)e);
            }
        }
    }

    private static void sendToOtherReplica(DecoratedKey key, ColumnFamily cf) throws UnavailableException, TimeoutException, IOException {
        RowMutation rm = new RowMutation(cf.metadata().ksName, key.key);
        rm.add(cf);
        final InetAddress local = FBUtilities.getLocalAddress();
        String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(local);
        StorageProxy.performWrite(rm, ConsistencyLevel.ANY, localDataCenter, new StorageProxy.WritePerformer(){

            @Override
            public void apply(IMutation mutation, Multimap<InetAddress, InetAddress> hintedEndpoints, IWriteResponseHandler responseHandler, String localDataCenter, ConsistencyLevel consistency_level) throws IOException {
                hintedEndpoints.remove((Object)local, (Object)local);
                responseHandler.response(null);
                StorageProxy.sendToHintedEndpoints((RowMutation)mutation, hintedEndpoints, responseHandler, localDataCenter, consistency_level);
            }
        });
    }
}

