/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class AbstractCommutativeType
extends AbstractType<Long> {
    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public Long compose(ByteBuffer bytes) {
        return CounterContext.instance().total(bytes);
    }

    @Override
    public ByteBuffer decompose(Long value) {
        return ByteBufferUtil.bytes(value);
    }

    public abstract Column createColumn(ByteBuffer var1, ByteBuffer var2, long var3);

    @Override
    public Class<Long> getType() {
        return Long.class;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public int getPrecision(Long obj) {
        return obj.toString().length();
    }

    @Override
    public int getScale(Long obj) {
        return 0;
    }

    @Override
    public int getJdbcType() {
        return 4;
    }

    @Override
    public boolean needsQuotes() {
        return false;
    }
}

