/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.io.DataOutput;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.List;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnIndexer;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrecompactedRow
extends AbstractCompactedRow {
    private static Logger logger = LoggerFactory.getLogger(PrecompactedRow.class);
    private final ColumnFamily compactedCf;
    private final int gcBefore;

    public PrecompactedRow(DecoratedKey key, ColumnFamily compacted) {
        super(key);
        this.compactedCf = compacted;
        this.gcBefore = Integer.MAX_VALUE;
    }

    public static ColumnFamily removeDeletedAndOldShards(DecoratedKey key, CompactionController controller, ColumnFamily cf) {
        return PrecompactedRow.removeDeletedAndOldShards(controller.shouldPurge(key), controller, cf);
    }

    public static ColumnFamily removeDeletedAndOldShards(boolean shouldPurge, CompactionController controller, ColumnFamily cf) {
        ColumnFamily compacted;
        ColumnFamily columnFamily = compacted = shouldPurge ? ColumnFamilyStore.removeDeleted(cf, controller.gcBefore) : cf;
        if (shouldPurge && compacted != null && compacted.metadata().getDefaultValidator().isCommutative()) {
            CounterColumn.removeOldShards(compacted, controller.gcBefore);
        }
        return compacted;
    }

    public PrecompactedRow(CompactionController controller, List<SSTableIdentityIterator> rows) {
        super(rows.get(0).getKey());
        this.gcBefore = controller.gcBefore;
        this.compactedCf = PrecompactedRow.removeDeletedAndOldShards(rows.get(0).getKey(), controller, PrecompactedRow.merge(rows));
    }

    private static ColumnFamily merge(List<SSTableIdentityIterator> rows) {
        ColumnFamily cf = null;
        for (SSTableIdentityIterator row : rows) {
            ColumnFamily thisCF;
            try {
                thisCF = row.getColumnFamilyWithColumns();
            }
            catch (IOException e) {
                logger.error("Skipping row " + row.getKey() + " in " + row.getPath(), (Throwable)e);
                continue;
            }
            if (cf == null) {
                cf = thisCF;
                continue;
            }
            cf.addAll(thisCF);
        }
        return cf;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        assert (this.compactedCf != null);
        DataOutputBuffer buffer = new DataOutputBuffer();
        DataOutputBuffer headerBuffer = new DataOutputBuffer();
        ColumnIndexer.serialize(this.compactedCf, headerBuffer);
        ColumnFamily.serializer().serializeForSSTable(this.compactedCf, buffer);
        out.writeLong(headerBuffer.getLength() + buffer.getLength());
        out.write(headerBuffer.getData(), 0, headerBuffer.getLength());
        out.write(buffer.getData(), 0, buffer.getLength());
    }

    @Override
    public void update(MessageDigest digest) {
        assert (this.compactedCf != null);
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            ColumnFamily.serializer().serializeCFInfo(this.compactedCf, buffer);
            buffer.writeInt(this.compactedCf.getColumnCount());
            digest.update(buffer.getData(), 0, buffer.getLength());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.compactedCf.updateDigest(digest);
    }

    @Override
    public boolean isEmpty() {
        return this.compactedCf == null || ColumnFamilyStore.removeDeletedCF(this.compactedCf, this.gcBefore) == null;
    }

    @Override
    public int columnCount() {
        return this.compactedCf == null ? 0 : this.compactedCf.getColumnCount();
    }

    public ColumnFamily getFullColumnFamily() throws IOException {
        return this.compactedCf;
    }
}

