/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.EchoedRow;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.LazilyCompactedRow;
import org.apache.cassandra.db.compaction.PrecompactedRow;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionController {
    private static Logger logger = LoggerFactory.getLogger(CompactionController.class);
    private final ColumnFamilyStore cfs;
    private final Set<SSTableReader> sstables;
    private final boolean forceDeserialize;
    public final boolean isMajor;
    public final int gcBefore;
    private int throttleResolution;

    public CompactionController(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, int gcBefore, boolean forceDeserialize) {
        assert (cfs != null);
        this.cfs = cfs;
        this.sstables = new HashSet<SSTableReader>(sstables);
        this.gcBefore = gcBefore;
        this.forceDeserialize = forceDeserialize;
        this.isMajor = cfs.isCompleteSSTables(this.sstables);
        long rowSize = cfs.getMeanRowSize();
        int rowsPerSecond = rowSize > 0L ? (int)((long)(DatabaseDescriptor.getCompactionThroughputMbPerSec() * 1024 * 1024) / rowSize) : 1000;
        this.throttleResolution = rowsPerSecond / 10;
        if (this.throttleResolution <= 0) {
            this.throttleResolution = 1;
        }
    }

    public int getThrottleResolution() {
        return this.throttleResolution;
    }

    public String getKeyspace() {
        return this.cfs.table.name;
    }

    public String getColumnFamily() {
        return this.cfs.columnFamily;
    }

    public boolean shouldPurge(DecoratedKey key) {
        return this.isMajor || !this.cfs.isKeyInRemainingSSTables(key, this.sstables);
    }

    public boolean needDeserialize() {
        if (this.forceDeserialize) {
            return true;
        }
        for (SSTableReader sstable : this.sstables) {
            if (sstable.descriptor.isLatestVersion) continue;
            return true;
        }
        return false;
    }

    public void invalidateCachedRow(DecoratedKey key) {
        this.cfs.invalidateCachedRow(key);
    }

    public void removeDeletedInCache(DecoratedKey key) {
        ColumnFamily cachedRow = this.cfs.getRawCachedRow(key);
        if (cachedRow != null) {
            ColumnFamilyStore.removeDeleted(cachedRow, this.gcBefore);
        }
    }

    public boolean isMajor() {
        return this.isMajor;
    }

    public AbstractCompactedRow getCompactedRow(List<SSTableIdentityIterator> rows) {
        if (rows.size() == 1 && !this.needDeserialize() && !this.shouldPurge(rows.get(0).getKey())) {
            return new EchoedRow(this, rows.get(0));
        }
        long rowSize = 0L;
        for (SSTableIdentityIterator row : rows) {
            rowSize += row.dataSize;
        }
        if (rowSize > (long)DatabaseDescriptor.getInMemoryCompactionLimit()) {
            String keyString = this.cfs.metadata.getKeyValidator().getString(rows.get((int)0).getKey().key);
            logger.info(String.format("Compacting large row %s/%s:%s (%d bytes) incrementally", this.cfs.table.name, this.cfs.columnFamily, keyString, rowSize));
            return new LazilyCompactedRow(this, rows);
        }
        return new PrecompactedRow(this, rows);
    }

    public AbstractCompactedRow getCompactedRow(SSTableIdentityIterator row) {
        return this.getCompactedRow(Collections.singletonList(row));
    }
}

