/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.cassandra.utils.FBUtilities;

public class UUIDGen {
    private static final long START_EPOCH = -12219292800000L;
    private static final long clock = new Random(System.currentTimeMillis()).nextLong();
    private static final UUIDGen instance = new UUIDGen();
    private long lastNanos;
    private final Map<InetAddress, Long> nodeCache = new HashMap<InetAddress, Long>();

    private UUIDGen() {
        if (clock == 0L) {
            throw new RuntimeException("singleton instantiation is misplaced.");
        }
    }

    public static UUID makeType1UUIDFromHost(InetAddress addr) {
        return new UUID(instance.createTimeSafe(), instance.getClockSeqAndNode(addr));
    }

    public static UUID getUUID(ByteBuffer raw) {
        return new UUID(raw.getLong(raw.position()), raw.getLong(raw.position() + 8));
    }

    public static byte[] decompose(UUID uuid) {
        long most = uuid.getMostSignificantBits();
        long least = uuid.getLeastSignificantBits();
        byte[] b = new byte[16];
        for (int i = 0; i < 8; ++i) {
            b[i] = (byte)(most >>> (7 - i) * 8);
            b[8 + i] = (byte)(least >>> (7 - i) * 8);
        }
        return b;
    }

    public static byte[] getTimeUUIDBytes() {
        return UUIDGen.createTimeUUIDBytes(instance.createTimeSafe());
    }

    public static byte[] getTimeUUIDBytes(long timeMillis) {
        return UUIDGen.createTimeUUIDBytes(instance.createTimeUnsafe(timeMillis));
    }

    private static byte[] createTimeUUIDBytes(long msb) {
        int i;
        long lsb = instance.getClockSeqAndNode();
        byte[] uuidBytes = new byte[16];
        for (i = 0; i < 8; ++i) {
            uuidBytes[i] = (byte)(msb >>> 8 * (7 - i));
        }
        for (i = 8; i < 16; ++i) {
            uuidBytes[i] = (byte)(lsb >>> 8 * (7 - i));
        }
        return uuidBytes;
    }

    public static long getAdjustedTimestamp(UUID uuid) {
        if (uuid.version() != 1) {
            throw new IllegalArgumentException("incompatible with uuid version: " + uuid.version());
        }
        return uuid.timestamp() / 10000L - -12219292800000L;
    }

    private long getClockSeqAndNode() {
        try {
            return this.getClockSeqAndNode(InetAddress.getLocalHost());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private long getClockSeqAndNode(InetAddress addr) {
        long lsb = 0L;
        lsb |= (clock & 0x3F00000000000000L) >>> 56;
        lsb |= 0x80L;
        lsb |= (clock & 0xFF000000000000L) >>> 48;
        return lsb |= this.makeNode(addr);
    }

    private synchronized long createTimeSafe() {
        long nanosSince = (System.currentTimeMillis() - -12219292800000L) * 10000L;
        if (nanosSince > this.lastNanos) {
            this.lastNanos = nanosSince;
        } else {
            nanosSince = ++this.lastNanos;
        }
        return this.createTime(nanosSince);
    }

    private long createTimeUnsafe(long when) {
        long nanosSince = (when - -12219292800000L) * 10000L;
        return this.createTime(nanosSince);
    }

    private long createTime(long nanosSince) {
        long msb = 0L;
        msb |= (0xFFFFFFFFL & nanosSince) << 32;
        msb |= (0xFFFF00000000L & nanosSince) >>> 16;
        msb |= (0xFFFF000000000000L & nanosSince) >>> 48;
        return msb |= 0x1000L;
    }

    private long makeNode(InetAddress addr) {
        if (this.nodeCache.containsKey(addr)) {
            return this.nodeCache.get(addr);
        }
        byte[] hash = FBUtilities.hash(ByteBuffer.wrap(addr.toString().getBytes()));
        long node = 0L;
        for (int i = 0; i < Math.min(6, hash.length); ++i) {
            node |= (0xFFL & (long)hash[i]) << (5 - i) * 8;
        }
        assert ((0xFF00000000000000L & node) == 0L);
        this.nodeCache.put(addr, node);
        return node;
    }
}

