/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.streaming.PendingFile;

public class StreamHeader {
    private static ICompactSerializer<StreamHeader> serializer = new StreamHeaderSerializer();
    public final String table;
    public final PendingFile file;
    public final long sessionId;
    public final Collection<PendingFile> pendingFiles;

    public static ICompactSerializer<StreamHeader> serializer() {
        return serializer;
    }

    public StreamHeader(String table, long sessionId, PendingFile file) {
        this(table, sessionId, file, Collections.emptyList());
    }

    public StreamHeader(String table, long sessionId, PendingFile first, Collection<PendingFile> pendingFiles) {
        this.table = table;
        this.sessionId = sessionId;
        this.file = first;
        this.pendingFiles = pendingFiles;
    }

    private static class StreamHeaderSerializer
    implements ICompactSerializer<StreamHeader> {
        private StreamHeaderSerializer() {
        }

        @Override
        public void serialize(StreamHeader sh, DataOutputStream dos, int version) throws IOException {
            dos.writeUTF(sh.table);
            dos.writeLong(sh.sessionId);
            PendingFile.serializer().serialize(sh.file, dos, version);
            dos.writeInt(sh.pendingFiles.size());
            for (PendingFile file : sh.pendingFiles) {
                PendingFile.serializer().serialize(file, dos, version);
            }
        }

        @Override
        public StreamHeader deserialize(DataInputStream dis, int version) throws IOException {
            String table = dis.readUTF();
            long sessionId = dis.readLong();
            PendingFile file = PendingFile.serializer().deserialize(dis, version);
            int size = dis.readInt();
            ArrayList<PendingFile> pendingFiles = new ArrayList<PendingFile>(size);
            for (int i = 0; i < size; ++i) {
                pendingFiles.add(PendingFile.serializer().deserialize(dis, version));
            }
            return new StreamHeader(table, sessionId, file, pendingFiles);
        }
    }
}

