/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.StringUtils;

public class TypeParser {
    private final String str;
    private int idx;
    private static final Map<String, AbstractType> cache = new HashMap<String, AbstractType>();
    public static final TypeParser EMPTY_PARSER = new TypeParser("", 0);

    private TypeParser(String str, int idx) {
        this.str = str;
        this.idx = idx;
    }

    public static AbstractType parse(String str) throws ConfigurationException {
        if (str == null) {
            return BytesType.instance;
        }
        AbstractType type = cache.get(str);
        if (type != null) {
            return type;
        }
        int i = 0;
        int j = i = TypeParser.skipBlank(str, i);
        while (!TypeParser.isEOS(str, i) && TypeParser.isIdentifierChar(str.charAt(i))) {
            ++i;
        }
        if (i == j) {
            return BytesType.instance;
        }
        String name = str.substring(j, i);
        type = !TypeParser.isEOS(str, i = TypeParser.skipBlank(str, i)) && str.charAt(i) == '(' ? TypeParser.getAbstractType(name, new TypeParser(str, i)) : TypeParser.getAbstractType(name);
        cache.put(str, type);
        return type;
    }

    public static AbstractType parse(CharSequence compareWith) throws ConfigurationException {
        return TypeParser.parse(compareWith == null ? null : ((Object)compareWith).toString());
    }

    private AbstractType parse() throws ConfigurationException {
        this.skipBlank();
        String name = this.readNextIdentifier();
        this.skipBlank();
        if (!this.isEOS() && this.str.charAt(this.idx) == '(') {
            return TypeParser.getAbstractType(name, this);
        }
        return TypeParser.getAbstractType(name);
    }

    public Map<String, String> getKeyValueParameters() throws ConfigurationException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.isEOS()) {
            return map;
        }
        if (this.str.charAt(this.idx) != '(') {
            throw new IllegalStateException();
        }
        ++this.idx;
        while (this.skipBlankAndComma()) {
            if (this.str.charAt(this.idx) == ')') {
                ++this.idx;
                return map;
            }
            String k = this.readNextIdentifier();
            String v = "";
            this.skipBlank();
            if (this.str.charAt(this.idx) == '=') {
                ++this.idx;
                this.skipBlank();
                v = this.readNextIdentifier();
            } else if (this.str.charAt(this.idx) != ',' && this.str.charAt(this.idx) != ')') {
                this.throwSyntaxError("unexpected character '" + this.str.charAt(this.idx) + "'");
            }
            map.put(k, v);
        }
        throw new ConfigurationException(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
    }

    public List<AbstractType> getTypeParameters() throws ConfigurationException {
        ArrayList<AbstractType> list = new ArrayList<AbstractType>();
        if (this.isEOS()) {
            return list;
        }
        if (this.str.charAt(this.idx) != '(') {
            throw new IllegalStateException();
        }
        ++this.idx;
        while (this.skipBlankAndComma()) {
            if (this.str.charAt(this.idx) == ')') {
                ++this.idx;
                return list;
            }
            try {
                list.add(this.parse());
            }
            catch (ConfigurationException e) {
                ConfigurationException ex = new ConfigurationException(String.format("Exception while parsing '%s' around char %d", this.str, this.idx));
                ex.initCause(e);
                throw ex;
            }
        }
        throw new ConfigurationException(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
    }

    public Map<Byte, AbstractType> getAliasParameters() throws ConfigurationException {
        HashMap<Byte, AbstractType> map = new HashMap<Byte, AbstractType>();
        if (this.isEOS()) {
            return map;
        }
        if (this.str.charAt(this.idx) != '(') {
            throw new IllegalStateException();
        }
        ++this.idx;
        while (this.skipBlankAndComma()) {
            char aliasChar;
            if (this.str.charAt(this.idx) == ')') {
                ++this.idx;
                return map;
            }
            String alias = this.readNextIdentifier();
            if (alias.length() != 1) {
                this.throwSyntaxError("An alias should be a single character");
            }
            if ((aliasChar = alias.charAt(0)) < '!' || aliasChar > '\u007f') {
                this.throwSyntaxError("An alias should be a single character in [0..9a..bA..B-+._&]");
            }
            this.skipBlank();
            if (this.str.charAt(this.idx) != '=' || this.str.charAt(this.idx + 1) != '>') {
                this.throwSyntaxError("expecting '=>' token");
            }
            this.idx += 2;
            this.skipBlank();
            try {
                map.put((byte)aliasChar, this.parse());
            }
            catch (ConfigurationException e) {
                ConfigurationException ex = new ConfigurationException(String.format("Exception while parsing '%s' around char %d", this.str, this.idx));
                ex.initCause(e);
                throw ex;
            }
        }
        throw new ConfigurationException(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
    }

    private static AbstractType getAbstractType(String compareWith) throws ConfigurationException {
        String className = compareWith.contains(".") ? compareWith : "org.apache.cassandra.db.marshal." + compareWith;
        Class typeClass = FBUtilities.classForName(className, "abstract-type");
        try {
            Field field = typeClass.getDeclaredField("instance");
            return (AbstractType)field.get(null);
        }
        catch (NoSuchFieldException e) {
            return TypeParser.getRawAbstractType(typeClass, EMPTY_PARSER);
        }
        catch (IllegalAccessException e) {
            return TypeParser.getRawAbstractType(typeClass, EMPTY_PARSER);
        }
    }

    private static AbstractType getAbstractType(String compareWith, TypeParser parser) throws ConfigurationException {
        String className = compareWith.contains(".") ? compareWith : "org.apache.cassandra.db.marshal." + compareWith;
        Class typeClass = FBUtilities.classForName(className, "abstract-type");
        try {
            Method method = typeClass.getDeclaredMethod("getInstance", TypeParser.class);
            return (AbstractType)method.invoke(null, parser);
        }
        catch (NoSuchMethodException e) {
            AbstractType type = TypeParser.getRawAbstractType(typeClass);
            return AbstractType.parseDefaultParameters(type, parser);
        }
        catch (IllegalAccessException e) {
            AbstractType type = TypeParser.getRawAbstractType(typeClass);
            return AbstractType.parseDefaultParameters(type, parser);
        }
        catch (InvocationTargetException e) {
            ConfigurationException ex = new ConfigurationException("Invalid definition for comparator " + typeClass.getName() + ".");
            ex.initCause(e.getTargetException());
            throw ex;
        }
    }

    private static AbstractType getRawAbstractType(Class<? extends AbstractType> typeClass) throws ConfigurationException {
        try {
            Field field = typeClass.getDeclaredField("instance");
            return (AbstractType)field.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new ConfigurationException("Invalid comparator class " + typeClass.getName() + ": must define a public static instance field or a public static method getInstance(TypeParser).");
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Invalid comparator class " + typeClass.getName() + ": must define a public static instance field or a public static method getInstance(TypeParser).");
        }
    }

    private static AbstractType getRawAbstractType(Class<? extends AbstractType> typeClass, TypeParser parser) throws ConfigurationException {
        try {
            Method method = typeClass.getDeclaredMethod("getInstance", TypeParser.class);
            return (AbstractType)method.invoke(null, parser);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("Invalid comparator class " + typeClass.getName() + ": must define a public static instance field or a public static method getInstance(TypeParser).");
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Invalid comparator class " + typeClass.getName() + ": must define a public static instance field or a public static method getInstance(TypeParser).");
        }
        catch (InvocationTargetException e) {
            ConfigurationException ex = new ConfigurationException("Invalid definition for comparator " + typeClass.getName() + ".");
            ex.initCause(e.getTargetException());
            throw ex;
        }
    }

    private void throwSyntaxError(String msg) throws ConfigurationException {
        throw new ConfigurationException(String.format("Syntax error parsing '%s' at char %d: %s", this.str, this.idx, msg));
    }

    private boolean isEOS() {
        return TypeParser.isEOS(this.str, this.idx);
    }

    private static boolean isEOS(String str, int i) {
        return i >= str.length();
    }

    private static boolean isBlank(int c) {
        return c == 32 || c == 9 || c == 10;
    }

    private void skipBlank() {
        this.idx = TypeParser.skipBlank(this.str, this.idx);
    }

    private static int skipBlank(String str, int i) {
        while (!TypeParser.isEOS(str, i) && TypeParser.isBlank(str.charAt(i))) {
            ++i;
        }
        return i;
    }

    private boolean skipBlankAndComma() {
        boolean commaFound = false;
        while (!this.isEOS()) {
            char c = this.str.charAt(this.idx);
            if (c == ',') {
                if (commaFound) {
                    return true;
                }
                commaFound = true;
            } else if (!TypeParser.isBlank(c)) {
                return true;
            }
            ++this.idx;
        }
        return false;
    }

    private static boolean isIdentifierChar(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 45 || c == 43 || c == 46 || c == 95 || c == 38;
    }

    private String readNextIdentifier() {
        int i = this.idx;
        while (!this.isEOS() && TypeParser.isIdentifierChar(this.str.charAt(this.idx))) {
            ++this.idx;
        }
        return this.str.substring(i, this.idx);
    }

    public static String stringifyAliasesParameters(Map<Byte, AbstractType> aliases) {
        Map.Entry<Byte, AbstractType> entry;
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        Iterator<Map.Entry<Byte, AbstractType>> iter = aliases.entrySet().iterator();
        if (iter.hasNext()) {
            entry = iter.next();
            sb.append((char)entry.getKey().byteValue()).append("=>").append(entry.getValue());
        }
        while (iter.hasNext()) {
            entry = iter.next();
            sb.append(',').append((char)entry.getKey().byteValue()).append("=>").append(entry.getValue());
        }
        sb.append(')');
        return sb.toString();
    }

    public static String stringifyTypeParameters(List<AbstractType> types) {
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(StringUtils.join(types, (String)",")).append(')');
        return sb.toString();
    }
}

