/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import org.apache.cassandra.io.ICompactSerializer2;
import org.apache.cassandra.io.sstable.SSTable;

public class ReplayPosition
implements Comparable<ReplayPosition> {
    public static final ReplayPositionSerializer serializer = new ReplayPositionSerializer();
    public static final ReplayPosition NONE = new ReplayPosition(-1L, 0);
    public final long segment;
    public final int position;
    public static final Comparator<ReplayPosition> comparator = new Comparator<ReplayPosition>(){

        @Override
        public int compare(ReplayPosition o1, ReplayPosition o2) {
            if (o1.segment != o2.segment) {
                return Long.valueOf(o1.segment).compareTo(o2.segment);
            }
            return Integer.valueOf(o1.position).compareTo(o2.position);
        }
    };

    public static ReplayPosition getReplayPosition(Iterable<? extends SSTable> sstables) {
        if (Iterables.isEmpty(sstables)) {
            return NONE;
        }
        Function<SSTable, ReplayPosition> f = new Function<SSTable, ReplayPosition>(){

            public ReplayPosition apply(SSTable sstable) {
                return sstable.replayPosition;
            }
        };
        Ordering ordering = Ordering.from(comparator);
        return (ReplayPosition)ordering.max(Iterables.transform(sstables, (Function)f));
    }

    public ReplayPosition(long segment, int position) {
        this.segment = segment;
        assert (position >= 0);
        this.position = position;
    }

    @Override
    public int compareTo(ReplayPosition other) {
        return comparator.compare(this, other);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplayPosition that = (ReplayPosition)o;
        if (this.position != that.position) {
            return false;
        }
        return this.segment == that.segment;
    }

    public int hashCode() {
        int result = (int)(this.segment ^ this.segment >>> 32);
        result = 31 * result + this.position;
        return result;
    }

    public String toString() {
        return "ReplayPosition(segmentId=" + this.segment + ", position=" + this.position + ')';
    }

    public static class ReplayPositionSerializer
    implements ICompactSerializer2<ReplayPosition> {
        @Override
        public void serialize(ReplayPosition rp, DataOutput dos) throws IOException {
            dos.writeLong(rp.segment);
            dos.writeInt(rp.position);
        }

        @Override
        public ReplayPosition deserialize(DataInput dis) throws IOException {
            return new ReplayPosition(dis.readLong(), dis.readInt());
        }
    }
}

