/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamilySerializer;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.CounterUpdateColumn;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IColumnContainer;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.SuperColumnSerializer;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.io.IColumnSerializer;
import org.apache.cassandra.io.util.IIterableColumns;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFamily
implements IColumnContainer,
IIterableColumns {
    private static Logger logger = LoggerFactory.getLogger(ColumnFamily.class);
    private static ColumnFamilySerializer serializer = new ColumnFamilySerializer();
    private final CFMetaData cfm;
    private transient IColumnSerializer columnSerializer;
    final AtomicLong markedForDeleteAt = new AtomicLong(Long.MIN_VALUE);
    final AtomicInteger localDeletionTime = new AtomicInteger(Integer.MIN_VALUE);
    private ConcurrentSkipListMap<ByteBuffer, IColumn> columns;

    public static ColumnFamilySerializer serializer() {
        return serializer;
    }

    public static ColumnFamily create(Integer cfId) {
        return ColumnFamily.create(DatabaseDescriptor.getCFMetaData(cfId));
    }

    public static ColumnFamily create(String tableName, String cfName) {
        return ColumnFamily.create(DatabaseDescriptor.getCFMetaData(tableName, cfName));
    }

    public static ColumnFamily create(CFMetaData cfm) {
        return new ColumnFamily(cfm);
    }

    public ColumnFamily(CFMetaData cfm) {
        assert (cfm != null);
        this.cfm = cfm;
        this.columnSerializer = cfm.cfType == ColumnFamilyType.Standard ? Column.serializer() : SuperColumn.serializer(cfm.subcolumnComparator);
        this.columns = new ConcurrentSkipListMap(cfm.comparator);
    }

    public ColumnFamily cloneMeShallow() {
        ColumnFamily cf = new ColumnFamily(this.cfm);
        cf.markedForDeleteAt.set(this.markedForDeleteAt.get());
        cf.localDeletionTime.set(this.localDeletionTime.get());
        return cf;
    }

    public AbstractType getSubComparator() {
        return this.columnSerializer instanceof SuperColumnSerializer ? ((SuperColumnSerializer)this.columnSerializer).getComparator() : null;
    }

    public ColumnFamilyType getType() {
        return this.cfm.cfType;
    }

    public ColumnFamily cloneMe() {
        ColumnFamily cf = this.cloneMeShallow();
        cf.columns = this.columns.clone();
        return cf;
    }

    public Integer id() {
        return this.cfm.cfId;
    }

    public CFMetaData metadata() {
        return this.cfm;
    }

    public void addAll(ColumnFamily cf) {
        for (IColumn column : cf.getSortedColumns()) {
            this.addColumn(column);
        }
        this.delete(cf);
    }

    public IColumnSerializer getColumnSerializer() {
        return this.columnSerializer;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public boolean isSuper() {
        return this.getType() == ColumnFamilyType.Super;
    }

    public void addColumn(QueryPath path, ByteBuffer value, long timestamp) {
        this.addColumn(path, value, timestamp, 0);
    }

    public void addColumn(QueryPath path, ByteBuffer value, long timestamp, int timeToLive) {
        assert (path.columnName != null) : path;
        assert (!this.metadata().getDefaultValidator().isCommutative());
        Column column = timeToLive > 0 ? new ExpiringColumn(path.columnName, value, timestamp, timeToLive) : new Column(path.columnName, value, timestamp);
        this.addColumn(path.superColumnName, column);
    }

    public void addCounter(QueryPath path, long value) {
        assert (path.columnName != null) : path;
        this.addColumn(path.superColumnName, new CounterUpdateColumn(path.columnName, value, System.currentTimeMillis()));
    }

    public void addTombstone(QueryPath path, ByteBuffer localDeletionTime, long timestamp) {
        assert (path.columnName != null) : path;
        this.addColumn(path.superColumnName, new DeletedColumn(path.columnName, localDeletionTime, timestamp));
    }

    public void addTombstone(QueryPath path, int localDeletionTime, long timestamp) {
        assert (path.columnName != null) : path;
        this.addColumn(path.superColumnName, new DeletedColumn(path.columnName, localDeletionTime, timestamp));
    }

    public void addTombstone(ByteBuffer name, int localDeletionTime, long timestamp) {
        this.addColumn(null, new DeletedColumn(name, localDeletionTime, timestamp));
    }

    public void addColumn(ByteBuffer superColumnName, Column column) {
        IColumn c;
        if (superColumnName == null) {
            c = column;
        } else {
            assert (this.isSuper());
            c = new SuperColumn(superColumnName, this.getSubComparator());
            c.addColumn(column);
        }
        this.addColumn(c);
    }

    public void clear() {
        this.columns.clear();
    }

    @Override
    public void addColumn(IColumn column) {
        IColumn oldColumn;
        ByteBuffer name = column.name();
        while ((oldColumn = this.columns.putIfAbsent(name, column)) != null) {
            if (oldColumn instanceof SuperColumn) {
                ((SuperColumn)oldColumn).putColumn(column);
                break;
            }
            IColumn reconciledColumn = column.reconcile(oldColumn);
            if (!this.columns.replace(name, oldColumn, reconciledColumn)) continue;
            break;
        }
    }

    public IColumn getColumn(ByteBuffer name) {
        return this.columns.get(name);
    }

    public SortedSet<ByteBuffer> getColumnNames() {
        return this.columns.keySet();
    }

    @Override
    public Collection<IColumn> getSortedColumns() {
        return this.columns.values();
    }

    public Collection<IColumn> getReverseSortedColumns() {
        return this.columns.descendingMap().values();
    }

    public Map<ByteBuffer, IColumn> getColumnsMap() {
        return this.columns;
    }

    @Override
    public void remove(ByteBuffer columnName) {
        this.columns.remove(columnName);
    }

    @Deprecated
    public void delete(int localtime, long timestamp) {
        this.localDeletionTime.set(localtime);
        this.markedForDeleteAt.set(timestamp);
    }

    public void delete(ColumnFamily cf2) {
        FBUtilities.atomicSetMax(this.localDeletionTime, cf2.getLocalDeletionTime());
        FBUtilities.atomicSetMax(this.markedForDeleteAt, cf2.getMarkedForDeleteAt());
    }

    @Override
    public boolean isMarkedForDelete() {
        return this.markedForDeleteAt.get() > Long.MIN_VALUE;
    }

    public ColumnFamily diff(ColumnFamily cfComposite) {
        assert (cfComposite.id().equals(this.id()));
        ColumnFamily cfDiff = new ColumnFamily(this.cfm);
        if (cfComposite.getMarkedForDeleteAt() > this.getMarkedForDeleteAt()) {
            cfDiff.delete(cfComposite.getLocalDeletionTime(), cfComposite.getMarkedForDeleteAt());
        }
        Map<ByteBuffer, IColumn> columns = cfComposite.getColumnsMap();
        for (Map.Entry<ByteBuffer, IColumn> entry : columns.entrySet()) {
            ByteBuffer cName = entry.getKey();
            IColumn columnInternal = this.columns.get(cName);
            IColumn columnExternal = entry.getValue();
            if (columnInternal == null) {
                cfDiff.addColumn(columnExternal);
                continue;
            }
            IColumn columnDiff = columnInternal.diff(columnExternal);
            if (columnDiff == null) continue;
            cfDiff.addColumn(columnDiff);
        }
        if (!cfDiff.getColumnsMap().isEmpty() || cfDiff.isMarkedForDelete()) {
            return cfDiff;
        }
        return null;
    }

    @Override
    public AbstractType getComparator() {
        return (AbstractType)this.columns.comparator();
    }

    int size() {
        int size = 0;
        for (IColumn column : this.columns.values()) {
            size += column.size();
        }
        return size;
    }

    public int hashCode() {
        throw new RuntimeException("Not implemented.");
    }

    public boolean equals(Object o) {
        throw new RuntimeException("Not implemented.");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ColumnFamily(");
        CFMetaData cfm = this.metadata();
        sb.append(cfm == null ? "<anonymous>" : cfm.cfName);
        if (this.isMarkedForDelete()) {
            sb.append(" -deleted at ").append(this.getMarkedForDeleteAt()).append("-");
        }
        sb.append(" [").append(this.getComparator().getColumnsString(this.getSortedColumns())).append("])");
        return sb.toString();
    }

    public static ByteBuffer digest(ColumnFamily cf) {
        MessageDigest digest = FBUtilities.threadLocalMD5Digest();
        if (cf != null) {
            cf.updateDigest(digest);
        }
        return ByteBuffer.wrap(digest.digest());
    }

    public void updateDigest(MessageDigest digest) {
        for (IColumn column : this.columns.values()) {
            column.updateDigest(digest);
        }
    }

    @Override
    public long getMarkedForDeleteAt() {
        return this.markedForDeleteAt.get();
    }

    public int getLocalDeletionTime() {
        return this.localDeletionTime.get();
    }

    public static AbstractType getComparatorFor(String table, String columnFamilyName, ByteBuffer superColumnName) {
        return superColumnName == null ? DatabaseDescriptor.getComparator(table, columnFamilyName) : DatabaseDescriptor.getSubComparator(table, columnFamilyName);
    }

    public static ColumnFamily diff(ColumnFamily cf1, ColumnFamily cf2) {
        if (cf1 == null) {
            return cf2;
        }
        return cf1.diff(cf2);
    }

    public void resolve(ColumnFamily cf) {
        if (cf == null) {
            return;
        }
        this.addAll(cf);
    }

    @Override
    public int getEstimatedColumnCount() {
        return this.getColumnCount();
    }

    public void retainAll(ColumnFamily cf) {
        Iterator<IColumn> iter = this.iterator();
        Iterator<IColumn> toRetain = cf.iterator();
        IColumn current = iter.hasNext() ? iter.next() : null;
        IColumn retain = toRetain.hasNext() ? toRetain.next() : null;
        AbstractType comparator = this.getComparator();
        while (current != null && retain != null) {
            int c = comparator.compare(current.name(), retain.name());
            if (c == 0) {
                if (this.isSuper()) {
                    assert (current instanceof SuperColumn && retain instanceof SuperColumn);
                    ((SuperColumn)current).retainAll((SuperColumn)retain);
                }
                current = iter.hasNext() ? iter.next() : null;
                retain = toRetain.hasNext() ? toRetain.next() : null;
                continue;
            }
            if (c < 0) {
                iter.remove();
                current = iter.hasNext() ? iter.next() : null;
                continue;
            }
            retain = toRetain.hasNext() ? toRetain.next() : null;
        }
        while (current != null) {
            iter.remove();
            current = iter.hasNext() ? iter.next() : null;
        }
    }

    @Override
    public Iterator<IColumn> iterator() {
        return this.columns.values().iterator();
    }

    public long serializedSize() {
        int size = 21;
        for (IColumn column : this.columns.values()) {
            size += column.serializedSize();
        }
        return size;
    }

    public void validateColumnFields() throws MarshalException {
        CFMetaData metadata = this.metadata();
        for (IColumn column : this.getSortedColumns()) {
            column.validateFields(metadata);
        }
    }
}

