/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.concurrent.NamedThreadFactory;

public class RetryingScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    public RetryingScheduledThreadPoolExecutor(String threadPoolName, int priority) {
        this(1, threadPoolName, priority);
    }

    public RetryingScheduledThreadPoolExecutor(int corePoolSize, String threadPoolName, int priority) {
        super(corePoolSize, new NamedThreadFactory(threadPoolName, priority));
    }

    public RetryingScheduledThreadPoolExecutor(String threadPoolName) {
        this(1, threadPoolName, 5);
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        return new LoggingScheduledFuture<V>(task);
    }

    private static class LoggingScheduledFuture<V>
    implements RunnableScheduledFuture<V> {
        private final RunnableScheduledFuture<V> task;

        public LoggingScheduledFuture(RunnableScheduledFuture<V> task) {
            this.task = task;
        }

        @Override
        public boolean isPeriodic() {
            return this.task.isPeriodic();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.task.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.task.compareTo(o);
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.task.run();
                }
                catch (Exception e) {
                    if (Thread.getDefaultUncaughtExceptionHandler() == null) break block2;
                    Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e.getCause());
                }
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.task.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.task.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.task.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.task.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.task.get(timeout, unit);
        }
    }
}

