/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.nio.ByteBuffer;
import org.apache.cassandra.cache.AutoSavingCache;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.utils.Pair;

public class AutoSavingKeyCache<K extends Pair<Descriptor, DecoratedKey>, V>
extends AutoSavingCache<K, V> {
    public AutoSavingKeyCache(ICache<K, V> cache, String tableName, String cfName) {
        super(cache, tableName, cfName, ColumnFamilyStore.CacheType.KEY_CACHE_TYPE);
    }

    @Override
    public double getConfiguredCacheSize(CFMetaData cfm) {
        return cfm == null ? 200000.0 : cfm.getKeyCacheSize();
    }

    @Override
    public ByteBuffer translateKey(K key) {
        return ((DecoratedKey)((Pair)key).right).key;
    }
}

