/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.base.Function;
import java.io.DataOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.locator.ILatencySubscriber;
import org.apache.cassandra.net.AsyncResult;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.IAsyncResult;
import org.apache.cassandra.net.IMessageCallback;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.IncomingTcpConnection;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessageDeliveryTask;
import org.apache.cassandra.net.MessageProducer;
import org.apache.cassandra.net.MessagingServiceMBean;
import org.apache.cassandra.net.OutboundTcpConnection;
import org.apache.cassandra.net.OutboundTcpConnectionPool;
import org.apache.cassandra.net.io.SerializerType;
import org.apache.cassandra.net.sink.SinkManager;
import org.apache.cassandra.security.SSLFactory;
import org.apache.cassandra.security.streaming.SSLFileStreamTask;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.FileStreamTask;
import org.apache.cassandra.streaming.StreamHeader;
import org.apache.cassandra.utils.ExpiringMap;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.SimpleCondition;
import org.apache.cassandra.utils.StatusLogger;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessagingService
implements MessagingServiceMBean {
    public static final String MBEAN_NAME = "org.apache.cassandra.net:type=MessagingService";
    public static final int VERSION_07 = 1;
    public static final int version_ = 2;
    private SerializerType serializerType_ = SerializerType.BINARY;
    private static final int PROTOCOL_MAGIC = -900387334;
    private final ExpiringMap<String, Pair<InetAddress, IMessageCallback>> callbacks;
    private final Map<StorageService.Verb, IVerbHandler> verbHandlers_;
    private final ExecutorService streamExecutor_;
    private final NonBlockingHashMap<InetAddress, OutboundTcpConnectionPool> connectionManagers_ = new NonBlockingHashMap();
    private static final Logger logger_ = LoggerFactory.getLogger(MessagingService.class);
    private static final int LOG_DROPPED_INTERVAL_IN_MS = 5000;
    private SocketThread socketThread;
    private final SimpleCondition listenGate;
    public static final EnumSet<StorageService.Verb> DROPPABLE_VERBS = EnumSet.of(StorageService.Verb.BINARY, new StorageService.Verb[]{StorageService.Verb.MUTATION, StorageService.Verb.READ_REPAIR, StorageService.Verb.READ, StorageService.Verb.RANGE_SLICE, StorageService.Verb.REQUEST_RESPONSE});
    private final Map<StorageService.Verb, AtomicInteger> droppedMessages = new EnumMap<StorageService.Verb, AtomicInteger>(StorageService.Verb.class);
    private final Map<StorageService.Verb, Integer> lastDropped = Collections.synchronizedMap(new EnumMap(StorageService.Verb.class));
    private final List<ILatencySubscriber> subscribers = new ArrayList<ILatencySubscriber>();
    private static final long DEFAULT_CALLBACK_TIMEOUT = (long)(1.1 * (double)DatabaseDescriptor.getRpcTimeout());
    private static AtomicInteger idGen = new AtomicInteger(0);

    public static MessagingService instance() {
        return MSHandle.instance;
    }

    private MessagingService() {
        for (StorageService.Verb verb : DROPPABLE_VERBS) {
            this.droppedMessages.put(verb, new AtomicInteger());
            this.lastDropped.put(verb, 0);
        }
        this.listenGate = new SimpleCondition();
        this.verbHandlers_ = new EnumMap<StorageService.Verb, IVerbHandler>(StorageService.Verb.class);
        this.streamExecutor_ = new DebuggableThreadPoolExecutor("Streaming", DatabaseDescriptor.getCompactionThreadPriority());
        Runnable logDropped = new Runnable(){

            @Override
            public void run() {
                MessagingService.this.logDroppedMessages();
            }
        };
        StorageService.scheduledTasks.scheduleWithFixedDelay(logDropped, 5000L, 5000L, TimeUnit.MILLISECONDS);
        Function<Pair<String, Pair<InetAddress, IMessageCallback>>, Object> timeoutReporter = new Function<Pair<String, Pair<InetAddress, IMessageCallback>>, Object>(){

            public Object apply(Pair<String, Pair<InetAddress, IMessageCallback>> pair) {
                Pair expiredValue = (Pair)pair.right;
                MessagingService.this.maybeAddLatency((IMessageCallback)expiredValue.right, (InetAddress)expiredValue.left, DatabaseDescriptor.getRpcTimeout());
                return null;
            }
        };
        this.callbacks = new ExpiringMap<String, Pair<InetAddress, IMessageCallback>>(DEFAULT_CALLBACK_TIMEOUT, timeoutReporter);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName(MBEAN_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void maybeAddLatency(IMessageCallback cb, InetAddress address, double latency) {
        if (cb.isLatencyForSnitch()) {
            this.addLatency(address, latency);
        }
    }

    public void addLatency(InetAddress address, double latency) {
        for (ILatencySubscriber subscriber : this.subscribers) {
            subscriber.receiveTiming(address, latency);
        }
    }

    public void convict(InetAddress ep) {
        logger_.debug("Resetting pool for " + ep);
        this.getConnectionPool(ep).reset();
    }

    public void listen(InetAddress localEp) throws IOException, ConfigurationException {
        this.socketThread = new SocketThread(this.getServerSocket(localEp), "ACCEPT-" + localEp);
        this.socketThread.start();
        this.listenGate.signalAll();
    }

    private ServerSocket getServerSocket(InetAddress localEp) throws IOException, ConfigurationException {
        ServerSocket ss;
        if (DatabaseDescriptor.getEncryptionOptions() != null && DatabaseDescriptor.getEncryptionOptions().internode_encryption == EncryptionOptions.InternodeEncryption.all) {
            ss = SSLFactory.getServerSocket(DatabaseDescriptor.getEncryptionOptions(), localEp, DatabaseDescriptor.getStoragePort());
            logger_.info("Starting Encrypted Messaging Service on port {}", (Object)DatabaseDescriptor.getStoragePort());
        } else {
            ServerSocketChannel serverChannel = ServerSocketChannel.open();
            ss = serverChannel.socket();
            ss.setReuseAddress(true);
            InetSocketAddress address = new InetSocketAddress(localEp, DatabaseDescriptor.getStoragePort());
            try {
                ss.bind(address);
            }
            catch (BindException e) {
                if (e.getMessage().contains("in use")) {
                    throw new ConfigurationException(address + " is in use by another process.  Change listen_address:storage_port in cassandra.yaml to values that do not conflict with other services");
                }
                if (e.getMessage().contains("Cannot assign requested address")) {
                    throw new ConfigurationException("Unable to bind to address " + address + ". Set listen_address in cassandra.yaml to an interface you can bind to, e.g., your private IP address on EC2");
                }
                throw e;
            }
            logger_.info("Starting Messaging Service on {}", (Object)address);
        }
        return ss;
    }

    public void waitUntilListening() {
        try {
            this.listenGate.await();
        }
        catch (InterruptedException ie) {
            logger_.debug("await interrupted");
        }
    }

    public OutboundTcpConnectionPool getConnectionPool(InetAddress to) {
        OutboundTcpConnectionPool cp = (OutboundTcpConnectionPool)this.connectionManagers_.get((Object)to);
        if (cp == null) {
            this.connectionManagers_.putIfAbsent((Object)to, (Object)new OutboundTcpConnectionPool(to));
            cp = (OutboundTcpConnectionPool)this.connectionManagers_.get((Object)to);
        }
        return cp;
    }

    public OutboundTcpConnection getConnection(InetAddress to, Message msg) {
        return this.getConnectionPool(to).getConnection(msg);
    }

    public void registerVerbHandlers(StorageService.Verb verb, IVerbHandler verbHandler) {
        assert (!this.verbHandlers_.containsKey((Object)verb));
        this.verbHandlers_.put(verb, verbHandler);
    }

    public IVerbHandler getVerbHandler(StorageService.Verb type) {
        return this.verbHandlers_.get((Object)type);
    }

    private void addCallback(IMessageCallback cb, String messageId, InetAddress to) {
        this.addCallback(cb, messageId, to, DEFAULT_CALLBACK_TIMEOUT);
    }

    private void addCallback(IMessageCallback cb, String messageId, InetAddress to, long timeout) {
        Pair<InetAddress, IMessageCallback> previous = this.callbacks.put(messageId, new Pair<InetAddress, IMessageCallback>(to, cb), timeout);
        assert (previous == null);
    }

    private static String nextId() {
        return Integer.toString(idGen.incrementAndGet());
    }

    public String sendRR(Message message, InetAddress to, IMessageCallback cb) {
        return this.sendRR(message, to, cb, DEFAULT_CALLBACK_TIMEOUT);
    }

    public String sendRR(Message message, InetAddress to, IMessageCallback cb, long timeout) {
        String id = MessagingService.nextId();
        this.addCallback(cb, id, to, timeout);
        this.sendOneWay(message, id, to);
        return id;
    }

    public void sendOneWay(Message message, InetAddress to) {
        this.sendOneWay(message, MessagingService.nextId(), to);
    }

    public void sendReply(Message message, String id, InetAddress to) {
        this.sendOneWay(message, id, to);
    }

    public String sendRR(MessageProducer producer, InetAddress to, IAsyncCallback cb) {
        try {
            return this.sendRR(producer.getMessage(Gossiper.instance.getVersion(to)), to, (IMessageCallback)cb);
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    private void sendOneWay(Message message, String id, InetAddress to) {
        byte[] data;
        Object buffer;
        if (logger_.isTraceEnabled()) {
            logger_.trace(FBUtilities.getLocalAddress() + " sending " + (Object)((Object)message.getVerb()) + " to " + id + "@" + to);
        }
        if (message.getFrom().equals(to)) {
            this.receive(message, id);
            return;
        }
        Message processedMessage = SinkManager.processClientMessage(message, id, to);
        if (processedMessage == null) {
            return;
        }
        OutboundTcpConnection connection = this.getConnection(to, message);
        try {
            buffer = new DataOutputBuffer();
            ((DataOutputStream)buffer).writeUTF(id);
            Message.serializer().serialize(message, (DataOutputStream)buffer, message.getVersion());
            data = ((DataOutputBuffer)buffer).getData();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        assert (data.length > 0);
        buffer = this.packIt(data, false, message.getVersion());
        connection.write((ByteBuffer)buffer);
    }

    public IAsyncResult sendRR(Message message, InetAddress to) {
        AsyncResult iar = new AsyncResult();
        this.sendRR(message, to, iar);
        return iar;
    }

    public void stream(StreamHeader header, InetAddress to) {
        if (DatabaseDescriptor.getEncryptionOptions().internode_encryption == EncryptionOptions.InternodeEncryption.all) {
            this.streamExecutor_.execute(new SSLFileStreamTask(header, to));
        } else {
            this.streamExecutor_.execute(new FileStreamTask(header, to));
        }
    }

    public void register(ILatencySubscriber subcriber) {
        this.subscribers.add(subcriber);
    }

    public void waitFor() throws InterruptedException {
        while (!this.streamExecutor_.isTerminated()) {
            this.streamExecutor_.awaitTermination(5L, TimeUnit.SECONDS);
        }
    }

    public void shutdown() {
        logger_.info("Shutting down MessageService...");
        try {
            this.socketThread.close();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        this.streamExecutor_.shutdownNow();
        this.callbacks.shutdown();
        logger_.info("Shutdown complete (no further commands will be processed)");
    }

    public void receive(Message message, String id) {
        if (logger_.isTraceEnabled()) {
            logger_.trace(FBUtilities.getLocalAddress() + " received " + (Object)((Object)message.getVerb()) + " from " + id + "@" + message.getFrom());
        }
        if ((message = SinkManager.processServerMessage(message, id)) == null) {
            return;
        }
        MessageDeliveryTask runnable = new MessageDeliveryTask(message, id);
        ThreadPoolExecutor stage = StageManager.getStage(message.getMessageType());
        assert (stage != null) : "No stage for message type " + (Object)((Object)message.getMessageType());
        stage.execute(runnable);
    }

    public Pair<InetAddress, IMessageCallback> removeRegisteredCallback(String messageId) {
        return this.callbacks.remove(messageId);
    }

    public long getRegisteredCallbackAge(String messageId) {
        return this.callbacks.getAge(messageId);
    }

    public static void validateMagic(int magic) throws IOException {
        if (magic != -900387334) {
            throw new IOException("invalid protocol header");
        }
    }

    public static int getBits(int x, int p, int n) {
        return x >>> p + 1 - n & ~(-1 << n);
    }

    public ByteBuffer packIt(byte[] bytes, boolean compress, int version) {
        int header = 0;
        header |= this.serializerType_.ordinal();
        if (compress) {
            header |= 4;
        }
        ByteBuffer buffer = ByteBuffer.allocate(12 + bytes.length);
        buffer.putInt(-900387334);
        buffer.putInt(header |= version << 8);
        buffer.putInt(bytes.length);
        buffer.put(bytes);
        buffer.flip();
        return buffer;
    }

    public ByteBuffer constructStreamHeader(StreamHeader streamHeader, boolean compress, int version) {
        byte[] bytes;
        Object buffer;
        int header = 0;
        header |= this.serializerType_.ordinal();
        if (compress) {
            header |= 4;
        }
        header |= 8;
        header |= version << 8;
        try {
            buffer = new DataOutputBuffer();
            StreamHeader.serializer().serialize(streamHeader, (DataOutputStream)buffer, version);
            bytes = ((DataOutputBuffer)buffer).getData();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        assert (bytes.length > 0);
        buffer = ByteBuffer.allocate(12 + bytes.length);
        ((ByteBuffer)buffer).putInt(-900387334);
        ((ByteBuffer)buffer).putInt(header);
        ((ByteBuffer)buffer).putInt(bytes.length);
        ((ByteBuffer)buffer).put(bytes);
        ((ByteBuffer)buffer).flip();
        return buffer;
    }

    public void incrementDroppedMessages(StorageService.Verb verb) {
        assert (DROPPABLE_VERBS.contains((Object)verb)) : "Verb " + (Object)((Object)verb) + " should not legally be dropped";
        this.droppedMessages.get((Object)verb).incrementAndGet();
    }

    private void logDroppedMessages() {
        boolean logTpstats = false;
        for (Map.Entry<StorageService.Verb, AtomicInteger> entry : this.droppedMessages.entrySet()) {
            AtomicInteger dropped = entry.getValue();
            if (dropped.get() <= 0) continue;
            logTpstats = true;
            logger_.info("{} {} messages dropped in server lifetime", (Object)dropped, (Object)entry.getKey());
        }
        if (logTpstats) {
            StatusLogger.log();
        }
    }

    @Override
    public Map<String, Integer> getCommandPendingTasks() {
        HashMap<String, Integer> pendingTasks = new HashMap<String, Integer>();
        for (Map.Entry entry : this.connectionManagers_.entrySet()) {
            pendingTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).cmdCon.getPendingMessages());
        }
        return pendingTasks;
    }

    @Override
    public Map<String, Long> getCommandCompletedTasks() {
        HashMap<String, Long> completedTasks = new HashMap<String, Long>();
        for (Map.Entry entry : this.connectionManagers_.entrySet()) {
            completedTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).cmdCon.getCompletedMesssages());
        }
        return completedTasks;
    }

    @Override
    public Map<String, Integer> getResponsePendingTasks() {
        HashMap<String, Integer> pendingTasks = new HashMap<String, Integer>();
        for (Map.Entry entry : this.connectionManagers_.entrySet()) {
            pendingTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).ackCon.getPendingMessages());
        }
        return pendingTasks;
    }

    @Override
    public Map<String, Long> getResponseCompletedTasks() {
        HashMap<String, Long> completedTasks = new HashMap<String, Long>();
        for (Map.Entry entry : this.connectionManagers_.entrySet()) {
            completedTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).ackCon.getCompletedMesssages());
        }
        return completedTasks;
    }

    public static long getDefaultCallbackTimeout() {
        return DEFAULT_CALLBACK_TIMEOUT;
    }

    @Override
    public Map<String, Integer> getDroppedMessages() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Map.Entry<StorageService.Verb, AtomicInteger> entry : this.droppedMessages.entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue().get());
        }
        return map;
    }

    @Override
    public Map<String, Integer> getRecentlyDroppedMessages() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Map.Entry<StorageService.Verb, AtomicInteger> entry : this.droppedMessages.entrySet()) {
            StorageService.Verb verb = entry.getKey();
            Integer dropped = entry.getValue().get();
            Integer recentlyDropped = dropped - this.lastDropped.get((Object)verb);
            map.put(verb.toString(), recentlyDropped);
            this.lastDropped.put(verb, dropped);
        }
        return map;
    }

    private static class SocketThread
    extends Thread {
        private final ServerSocket server;

        SocketThread(ServerSocket server, String name) {
            super(name);
            this.server = server;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Socket socket = this.server.accept();
                    new IncomingTcpConnection(socket).start();
                }
            }
            catch (AsynchronousCloseException e) {
                logger_.info("MessagingService shutting down server thread.");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        void close() throws IOException {
            this.server.close();
        }
    }

    private static class MSHandle {
        public static final MessagingService instance = new MessagingService();

        private MSHandle() {
        }
    }
}

