/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnIndexer;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.IIterableColumns;
import org.apache.cassandra.utils.ReducingIterator;
import org.apache.commons.collections.iterators.CollatingIterator;

public class LazilyCompactedRow
extends AbstractCompactedRow
implements IIterableColumns {
    private final List<SSTableIdentityIterator> rows;
    private final CompactionController controller;
    private final boolean shouldPurge;
    private final DataOutputBuffer headerBuffer;
    private ColumnFamily emptyColumnFamily;
    private LazyColumnIterator iter;
    private int columnCount;
    private long columnSerializedSize;

    public LazilyCompactedRow(CompactionController controller, List<SSTableIdentityIterator> rows) {
        super(rows.get(0).getKey());
        this.controller = controller;
        this.shouldPurge = controller.shouldPurge(this.key);
        this.rows = new ArrayList<SSTableIdentityIterator>(rows);
        for (SSTableIdentityIterator row : rows) {
            ColumnFamily cf = row.getColumnFamily();
            if (this.emptyColumnFamily == null) {
                this.emptyColumnFamily = cf;
                continue;
            }
            this.emptyColumnFamily.delete(cf);
        }
        this.headerBuffer = new DataOutputBuffer();
        ColumnIndexer.serialize(this, this.headerBuffer);
        this.columnCount = this.iter.size;
        this.columnSerializedSize = this.iter.serializedSize;
        this.iter = null;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        DataOutputBuffer clockOut = new DataOutputBuffer();
        ColumnFamily.serializer().serializeCFInfo(this.emptyColumnFamily, clockOut);
        long dataSize = (long)(this.headerBuffer.getLength() + clockOut.getLength()) + this.columnSerializedSize;
        assert (dataSize > 0L);
        out.writeLong(dataSize);
        out.write(this.headerBuffer.getData(), 0, this.headerBuffer.getLength());
        out.write(clockOut.getData(), 0, clockOut.getLength());
        out.writeInt(this.columnCount);
        for (IColumn column : this) {
            this.emptyColumnFamily.getColumnSerializer().serialize(column, out);
        }
    }

    @Override
    public void update(MessageDigest digest) {
        DataOutputBuffer out = new DataOutputBuffer();
        try {
            ColumnFamily.serializer().serializeCFInfo(this.emptyColumnFamily, out);
            out.writeInt(this.columnCount);
            digest.update(out.getData(), 0, out.getLength());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        Iterator<IColumn> iter = this.iterator();
        while (iter.hasNext()) {
            iter.next().updateDigest(digest);
        }
    }

    @Override
    public boolean isEmpty() {
        boolean cfIrrelevant = ColumnFamilyStore.removeDeletedCF(this.emptyColumnFamily, this.controller.gcBefore) == null;
        return cfIrrelevant && this.columnCount == 0;
    }

    @Override
    public int getEstimatedColumnCount() {
        int n = 0;
        for (SSTableIdentityIterator row : this.rows) {
            n += row.columnCount;
        }
        return n;
    }

    @Override
    public AbstractType getComparator() {
        return this.emptyColumnFamily.getComparator();
    }

    @Override
    public Iterator<IColumn> iterator() {
        for (SSTableIdentityIterator row : this.rows) {
            row.reset();
        }
        this.iter = new LazyColumnIterator((Iterator<IColumn>)new CollatingIterator(this.getComparator().columnComparator, this.rows));
        return Iterators.filter((Iterator)this.iter, (Predicate)Predicates.notNull());
    }

    @Override
    public int columnCount() {
        return this.columnCount;
    }

    private class LazyColumnIterator
    extends ReducingIterator<IColumn, IColumn> {
        ColumnFamily container;
        long serializedSize;
        int size;

        public LazyColumnIterator(Iterator<IColumn> source) {
            super(source);
            this.container = LazilyCompactedRow.this.emptyColumnFamily.cloneMeShallow();
            this.serializedSize = 4L;
            this.size = 0;
        }

        @Override
        protected boolean isEqual(IColumn o1, IColumn o2) {
            return o1.name().equals(o2.name());
        }

        @Override
        public void reduce(IColumn current) {
            this.container.addColumn(current);
        }

        @Override
        protected IColumn getReduced() {
            ColumnFamily purged;
            assert (this.container != null);
            IColumn reduced = this.container.iterator().next();
            ColumnFamily columnFamily = purged = LazilyCompactedRow.this.shouldPurge ? ColumnFamilyStore.removeDeleted(this.container, ((LazilyCompactedRow)LazilyCompactedRow.this).controller.gcBefore) : this.container;
            if (purged != null && purged.metadata().getDefaultValidator().isCommutative()) {
                CounterColumn.removeOldShards(purged, ((LazilyCompactedRow)LazilyCompactedRow.this).controller.gcBefore);
            }
            if (purged == null || !purged.iterator().hasNext()) {
                this.container.clear();
                return null;
            }
            this.container.clear();
            this.serializedSize += (long)reduced.serializedSize();
            ++this.size;
            return reduced;
        }
    }
}

