/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.CounterMutationSerializer;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterMutation
implements IMutation {
    private static final Logger logger = LoggerFactory.getLogger(CounterMutation.class);
    private static final CounterMutationSerializer serializer = new CounterMutationSerializer();
    private final RowMutation rowMutation;
    private final ConsistencyLevel consistency;
    private static final ThreadLocal<Random> random = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };

    public CounterMutation(RowMutation rowMutation, ConsistencyLevel consistency) {
        this.rowMutation = rowMutation;
        this.consistency = consistency;
    }

    @Override
    public String getTable() {
        return this.rowMutation.getTable();
    }

    @Override
    public Collection<Integer> getColumnFamilyIds() {
        return this.rowMutation.getColumnFamilyIds();
    }

    @Override
    public ByteBuffer key() {
        return this.rowMutation.key();
    }

    public RowMutation rowMutation() {
        return this.rowMutation;
    }

    public ConsistencyLevel consistency() {
        return this.consistency;
    }

    public static CounterMutationSerializer serializer() {
        return serializer;
    }

    public RowMutation makeReplicationMutation() throws IOException {
        LinkedList<ReadCommand> readCommands = new LinkedList<ReadCommand>();
        for (ColumnFamily columnFamily : this.rowMutation.getColumnFamilies()) {
            if (!columnFamily.metadata().getReplicateOnWrite()) continue;
            this.addReadCommandFromColumnFamily(this.rowMutation.getTable(), this.rowMutation.key(), columnFamily, readCommands);
        }
        RowMutation replicationMutation = new RowMutation(this.rowMutation.getTable(), this.rowMutation.key());
        for (ReadCommand readCommand : readCommands) {
            Table table;
            Row row = readCommand.getRow(table = Table.open(readCommand.table));
            if (row == null || row.cf == null) continue;
            row = this.mergeOldShards(readCommand.table, row);
            replicationMutation.add(row.cf);
        }
        return replicationMutation;
    }

    private void addReadCommandFromColumnFamily(String table, ByteBuffer key, ColumnFamily columnFamily, List<ReadCommand> commands) {
        if (!columnFamily.isSuper()) {
            QueryPath queryPath = new QueryPath(columnFamily.metadata().cfName);
            commands.add(new SliceByNamesReadCommand(table, key, queryPath, columnFamily.getColumnNames()));
        } else {
            for (IColumn superColumn : columnFamily.getSortedColumns()) {
                QueryPath queryPath = new QueryPath(columnFamily.metadata().cfName, superColumn.name());
                Collection<IColumn> subColumns = superColumn.getSubColumns();
                HashSet<ByteBuffer> subColNames = new HashSet<ByteBuffer>(subColumns.size());
                for (IColumn subCol : subColumns) {
                    subColNames.add(subCol.name());
                }
                commands.add(new SliceByNamesReadCommand(table, key, queryPath, subColNames));
            }
        }
    }

    private Row mergeOldShards(String table, Row row) throws IOException {
        ColumnFamily merger;
        ColumnFamily cf = row.cf;
        if (cf.metadata().getMergeShardsChance() > random.get().nextDouble() && (merger = this.computeShardMerger(cf)) != null) {
            RowMutation localMutation = new RowMutation(table, row.key.key);
            localMutation.add(merger);
            localMutation.apply();
            cf.addAll(merger);
        }
        return row;
    }

    private ColumnFamily computeShardMerger(ColumnFamily cf) {
        ColumnFamily merger = null;
        if (!cf.isSuper()) {
            for (IColumn column : cf.getSortedColumns()) {
                CounterColumn c;
                if (!(column instanceof CounterColumn) || (c = ((CounterColumn)column).computeOldShardMerger()) == null) continue;
                if (merger == null) {
                    merger = cf.cloneMeShallow();
                }
                merger.addColumn(c);
            }
        } else {
            for (IColumn superColumn : cf.getSortedColumns()) {
                IColumn mergerSuper = null;
                for (IColumn column : superColumn.getSubColumns()) {
                    CounterColumn c;
                    if (!(column instanceof CounterColumn) || (c = ((CounterColumn)column).computeOldShardMerger()) == null) continue;
                    if (mergerSuper == null) {
                        mergerSuper = ((SuperColumn)superColumn).cloneMeShallow();
                    }
                    mergerSuper.addColumn(c);
                }
                if (mergerSuper == null) continue;
                if (merger == null) {
                    merger = cf.cloneMeShallow();
                }
                merger.addColumn(mergerSuper);
            }
        }
        return merger;
    }

    public Message makeMutationMessage(int version) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        CounterMutation.serializer().serialize(this, dos, version);
        return new Message(FBUtilities.getLocalAddress(), StorageService.Verb.COUNTER_MUTATION, bos.toByteArray(), version);
    }

    public boolean shouldReplicateOnWrite() {
        for (ColumnFamily cf : this.rowMutation.getColumnFamilies()) {
            if (!cf.metadata().getReplicateOnWrite()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void apply() throws IOException {
        RowMutation rm = new RowMutation(this.rowMutation.getTable(), ByteBufferUtil.clone(this.rowMutation.key()));
        Table table = Table.open(rm.getTable());
        for (ColumnFamily cf_ : this.rowMutation.getColumnFamilies()) {
            ColumnFamily cf = cf_.cloneMeShallow();
            ColumnFamilyStore cfs = table.getColumnFamilyStore(cf.id());
            for (IColumn column : cf_.getColumnsMap().values()) {
                cf.addColumn(column.localCopy(cfs));
            }
            rm.add(cf);
        }
        rm.apply();
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean shallow) {
        StringBuilder buff = new StringBuilder("CounterMutation(");
        buff.append(this.rowMutation.toString(shallow));
        buff.append(", ").append(this.consistency.toString());
        return buff.append(")").toString();
    }
}

