/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.collect.Iterables;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import java.util.Set;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.IExecutorMBean;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.net.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusLogger {
    private static final Logger logger = LoggerFactory.getLogger(StatusLogger.class);

    public static void log() {
        Set<ObjectName> internal;
        Set<ObjectName> request;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        logger.info(String.format("%-25s%10s%10s", "Pool Name", "Active", "Pending"));
        try {
            request = server.queryNames(new ObjectName("org.apache.cassandra.request:type=*"), null);
            internal = server.queryNames(new ObjectName("org.apache.cassandra.internal:type=*"), null);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        for (ObjectName objectName : Iterables.concat(request, internal)) {
            String poolName = objectName.getKeyProperty("type");
            IExecutorMBean threadPoolProxy = JMX.newMBeanProxy(server, objectName, IExecutorMBean.class);
            logger.info(String.format("%-25s%10s%10s", poolName, threadPoolProxy.getActiveCount(), threadPoolProxy.getPendingTasks()));
        }
        logger.info(String.format("%-25s%10s%10s", "CompactionManager", "n/a", CompactionManager.instance.getPendingTasks()));
        int pendingCommands = 0;
        for (int n : MessagingService.instance().getCommandPendingTasks().values()) {
            pendingCommands += n;
        }
        int pendingResponses = 0;
        Iterator<Object> i$ = MessagingService.instance().getResponsePendingTasks().values().iterator();
        while (i$.hasNext()) {
            int n = i$.next();
            pendingResponses += n;
        }
        logger.info(String.format("%-25s%10s%10s", "MessagingService", "n/a", pendingCommands + "," + pendingResponses));
        logger.info(String.format("%-25s%20s%20s%20s", "ColumnFamily", "Memtable ops,data", "Row cache size/cap", "Key cache size/cap"));
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            logger.info(String.format("%-25s%20s%20s%20s", cfs.table.name + "." + cfs.columnFamily, cfs.getMemtableColumnsCount() + "," + cfs.getMemtableDataSize(), cfs.getRowCacheSize() + "/" + cfs.getRowCacheCapacity(), cfs.getKeyCacheSize() + "/" + cfs.getKeyCacheCapacity()));
        }
    }
}

