/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.CompactionType;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ReducingIterator;
import org.apache.commons.collections.iterators.CollatingIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionIterator
extends ReducingIterator<SSTableIdentityIterator, AbstractCompactedRow>
implements Closeable,
CompactionInfo.Holder {
    private static Logger logger = LoggerFactory.getLogger(CompactionIterator.class);
    public static final int FILE_BUFFER_SIZE = 0x100000;
    protected final List<SSTableIdentityIterator> rows = new ArrayList<SSTableIdentityIterator>();
    protected final CompactionType type;
    protected final CompactionController controller;
    private long totalBytes;
    private long bytesRead;
    private long row;
    private long bytesAtLastDelay;
    private long timeAtLastDelay;
    private int targetBytesPerMS = -1;

    public CompactionIterator(CompactionType type, Iterable<SSTableReader> sstables, CompactionController controller) throws IOException {
        this(type, (Iterator)CompactionIterator.getCollatingIterator(sstables), controller);
    }

    protected CompactionIterator(CompactionType type, Iterator iter, CompactionController controller) {
        super(iter);
        this.type = type;
        this.controller = controller;
        this.row = 0L;
        this.bytesRead = 0L;
        this.totalBytes = 0L;
        for (SSTableScanner scanner : this.getScanners()) {
            this.totalBytes += scanner.getFileLength();
        }
    }

    protected static CollatingIterator getCollatingIterator(Iterable<SSTableReader> sstables) throws IOException {
        CollatingIterator iter = FBUtilities.getCollatingIterator();
        for (SSTableReader sstable : sstables) {
            iter.addIterator((Iterator)sstable.getDirectScanner(0x100000));
        }
        return iter;
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        return new CompactionInfo(this.controller.getKeyspace(), this.controller.getColumnFamily(), this.type, this.bytesRead, this.totalBytes);
    }

    @Override
    protected boolean isEqual(SSTableIdentityIterator o1, SSTableIdentityIterator o2) {
        return o1.getKey().equals(o2.getKey());
    }

    @Override
    public void reduce(SSTableIdentityIterator current) {
        this.rows.add(current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractCompactedRow getReduced() {
        assert (this.rows.size() > 0);
        try {
            AbstractCompactedRow compactedRow = this.controller.getCompactedRow(this.rows);
            if (compactedRow.isEmpty()) {
                this.controller.invalidateCachedRow(compactedRow.key);
                AbstractCompactedRow abstractCompactedRow = null;
                return abstractCompactedRow;
            }
            this.controller.removeDeletedInCache(compactedRow.key);
            AbstractCompactedRow abstractCompactedRow = compactedRow;
            return abstractCompactedRow;
        }
        finally {
            this.rows.clear();
            if (this.row++ % 1000L == 0L) {
                this.bytesRead = 0L;
                for (SSTableScanner scanner : this.getScanners()) {
                    this.bytesRead += scanner.getFilePointer();
                }
                this.throttle();
            }
        }
    }

    private void throttle() {
        if (DatabaseDescriptor.getCompactionThroughputMbPerSec() < 1 || StorageService.instance.isBootstrapMode()) {
            return;
        }
        int totalBytesPerMS = DatabaseDescriptor.getCompactionThroughputMbPerSec() * 1024 * 1024 / 1000;
        long bytesSinceLast = this.bytesRead - this.bytesAtLastDelay;
        long msSinceLast = System.currentTimeMillis() - this.timeAtLastDelay;
        int newTarget = totalBytesPerMS / Math.max(1, CompactionManager.instance.getActiveCompactions());
        if (newTarget != this.targetBytesPerMS) {
            logger.info(String.format("%s now compacting at %d bytes/ms.", this, newTarget));
        }
        this.targetBytesPerMS = newTarget;
        long excessBytes = bytesSinceLast - msSinceLast * (long)this.targetBytesPerMS;
        long timeToDelay = excessBytes / (long)Math.max(1, this.targetBytesPerMS);
        if (timeToDelay > 0L) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Compacted %d bytes in %d ms: throttling for %d ms", bytesSinceLast, msSinceLast, timeToDelay));
            }
            try {
                Thread.sleep(timeToDelay);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
        this.bytesAtLastDelay = this.bytesRead;
        this.timeAtLastDelay = System.currentTimeMillis();
    }

    @Override
    public void close() throws IOException {
        FileUtils.close(this.getScanners());
    }

    protected Iterable<SSTableScanner> getScanners() {
        return ((CollatingIterator)this.source).getIterators();
    }

    public String toString() {
        return this.getCompactionInfo().toString();
    }
}

