/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.cql.Term;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;

public class CreateColumnFamilyStatement {
    private static final String KW_COMPARATOR = "comparator";
    private static final String KW_COMMENT = "comment";
    private static final String KW_ROWCACHESIZE = "row_cache_size";
    private static final String KW_KEYCACHESIZE = "key_cache_size";
    private static final String KW_READREPAIRCHANCE = "read_repair_chance";
    private static final String KW_GCGRACESECONDS = "gc_grace_seconds";
    private static final String KW_DEFAULTVALIDATION = "default_validation";
    private static final String KW_MINCOMPACTIONTHRESHOLD = "min_compaction_threshold";
    private static final String KW_MAXCOMPACTIONTHRESHOLD = "max_compaction_threshold";
    private static final String KW_ROWCACHESAVEPERIODSECS = "row_cache_save_period_in_seconds";
    private static final String KW_KEYCACHESAVEPERIODSECS = "key_cache_save_period_in_seconds";
    private static final String KW_MEMTABLEFLUSHINMINS = "memtable_flush_after_mins";
    private static final String KW_MEMTABLESIZEINMB = "memtable_throughput_in_mb";
    private static final String KW_MEMTABLEOPSINMILLIONS = "memtable_operations_in_millions";
    private static final String KW_REPLICATEONWRITE = "replicate_on_write";
    private static final String KW_ROW_CACHE_PROVIDER = "row_cache_provider";
    public static final Map<String, String> comparators = new HashMap<String, String>();
    private static final Set<String> keywords = new HashSet<String>();
    private final String name;
    private final Map<Term, String> columns = new HashMap<Term, String>();
    private final Map<String, String> properties = new HashMap<String, String>();
    private List<String> keyValidator = new ArrayList<String>();
    private ByteBuffer keyAlias = null;

    public CreateColumnFamilyStatement(String name) {
        this.name = name;
    }

    private void validate() throws InvalidRequestException {
        if (!this.name.matches("\\w+")) {
            throw new InvalidRequestException(String.format("\"%s\" is not a valid column family name", this.name));
        }
        HashSet<String> keywordsFound = new HashSet<String>(this.properties.keySet());
        keywordsFound.removeAll(keywords);
        Iterator i$ = keywordsFound.iterator();
        if (i$.hasNext()) {
            String bogus = (String)i$.next();
            throw new InvalidRequestException(bogus + " is not a valid keyword argument for CREATE COLUMNFAMILY");
        }
        Integer minCompaction = this.getPropertyInt(KW_MINCOMPACTIONTHRESHOLD, null);
        Integer maxCompaction = this.getPropertyInt(KW_MAXCOMPACTIONTHRESHOLD, null);
        if (minCompaction != null && maxCompaction != null) {
            if (minCompaction > maxCompaction && maxCompaction != 0) {
                throw new InvalidRequestException(String.format("%s cannot be larger than %s", KW_MINCOMPACTIONTHRESHOLD, KW_MAXCOMPACTIONTHRESHOLD));
            }
        } else if (minCompaction != null) {
            if (minCompaction > 32) {
                throw new InvalidRequestException(String.format("%s cannot be larger than %s, (default %s)", KW_MINCOMPACTIONTHRESHOLD, KW_MAXCOMPACTIONTHRESHOLD, 32));
            }
        } else if (maxCompaction != null && maxCompaction < 4 && maxCompaction != 0) {
            throw new InvalidRequestException(String.format("%s cannot be smaller than %s, (default %s)", KW_MAXCOMPACTIONTHRESHOLD, KW_MINCOMPACTIONTHRESHOLD, 4));
        }
        Integer memMins = this.getPropertyInt(KW_MEMTABLEFLUSHINMINS, null);
        Integer memMb = this.getPropertyInt(KW_MEMTABLESIZEINMB, null);
        Double memOps = this.getPropertyDouble(KW_MEMTABLEOPSINMILLIONS, null);
        if (memMins != null && memMins <= 0) {
            throw new InvalidRequestException(String.format("%s must be non-negative and greater than zero", KW_MEMTABLEFLUSHINMINS));
        }
        if (memMb != null && memMb <= 0) {
            throw new InvalidRequestException(String.format("%s must be non-negative and greater than zero", KW_MEMTABLESIZEINMB));
        }
        if (memOps != null && memOps <= 0.0) {
            throw new InvalidRequestException(String.format("%s must be non-negative and greater than zero", KW_MEMTABLEOPSINMILLIONS));
        }
        if (this.keyValidator.size() < 1) {
            throw new InvalidRequestException("You must specify a PRIMARY KEY");
        }
        if (this.keyValidator.size() > 1) {
            throw new InvalidRequestException("You may only specify one PRIMARY KEY");
        }
    }

    public void addColumn(Term term, String comparator) {
        this.columns.put(term, comparator);
    }

    public void setKeyType(String validator) {
        this.keyValidator.add(validator);
    }

    public String getKeyType() {
        return this.keyValidator.get(0);
    }

    public void setKeyAlias(String alias) {
        if (!alias.toUpperCase().equals("KEY")) {
            this.keyAlias = ByteBufferUtil.bytes(alias);
        }
    }

    public void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getName() {
        return this.name;
    }

    private Map<ByteBuffer, ColumnDefinition> getColumns(AbstractType<?> comparator) throws InvalidRequestException {
        HashMap<ByteBuffer, ColumnDefinition> columnDefs = new HashMap<ByteBuffer, ColumnDefinition>();
        for (Map.Entry<Term, String> col : this.columns.entrySet()) {
            try {
                ByteBuffer columnName = col.getKey().getByteBuffer(comparator);
                String validatorClassName = comparators.containsKey(col.getValue()) ? comparators.get(col.getValue()) : col.getValue();
                AbstractType validator = TypeParser.parse(validatorClassName);
                columnDefs.put(columnName, new ColumnDefinition(columnName, validator, null, null));
            }
            catch (ConfigurationException e) {
                InvalidRequestException ex = new InvalidRequestException(e.toString());
                ex.initCause((Throwable)e);
                throw ex;
            }
        }
        return columnDefs;
    }

    public CFMetaData getCFMetaData(String keyspace) throws InvalidRequestException {
        CFMetaData newCFMD;
        this.validate();
        try {
            String comparatorString = comparators.get(this.getPropertyString(KW_COMPARATOR, "text")) != null ? comparators.get(this.getPropertyString(KW_COMPARATOR, "text")) : this.getPropertyString(KW_COMPARATOR, "text");
            String validatorString = comparators.get(this.getPropertyString(KW_DEFAULTVALIDATION, "text")) != null ? comparators.get(this.getPropertyString(KW_DEFAULTVALIDATION, "text")) : this.getPropertyString(KW_DEFAULTVALIDATION, "text");
            AbstractType comparator = TypeParser.parse(comparatorString);
            newCFMD = new CFMetaData(keyspace, this.name, ColumnFamilyType.Standard, comparator, null);
            newCFMD.comment(this.properties.get(KW_COMMENT)).rowCacheSize(this.getPropertyDouble(KW_ROWCACHESIZE, 0.0)).keyCacheSize(this.getPropertyDouble(KW_KEYCACHESIZE, 200000.0)).readRepairChance(this.getPropertyDouble(KW_READREPAIRCHANCE, 1.0)).replicateOnWrite(this.getPropertyBoolean(KW_REPLICATEONWRITE, true)).gcGraceSeconds(this.getPropertyInt(KW_GCGRACESECONDS, 864000)).defaultValidator(TypeParser.parse(validatorString)).minCompactionThreshold(this.getPropertyInt(KW_MINCOMPACTIONTHRESHOLD, 4)).maxCompactionThreshold(this.getPropertyInt(KW_MAXCOMPACTIONTHRESHOLD, 32)).rowCacheSavePeriod(this.getPropertyInt(KW_ROWCACHESAVEPERIODSECS, 0)).keyCacheSavePeriod(this.getPropertyInt(KW_KEYCACHESAVEPERIODSECS, 14400)).memTime(this.getPropertyInt(KW_MEMTABLEFLUSHINMINS, 1440)).memSize(this.getPropertyInt(KW_MEMTABLESIZEINMB, CFMetaData.DEFAULT_MEMTABLE_THROUGHPUT_IN_MB)).memOps(this.getPropertyDouble(KW_MEMTABLEOPSINMILLIONS, CFMetaData.DEFAULT_MEMTABLE_OPERATIONS_IN_MILLIONS)).mergeShardsChance(0.0).columnMetadata(this.getColumns(comparator)).keyValidator(TypeParser.parse(comparators.get(this.getKeyType()))).rowCacheProvider(FBUtilities.newCacheProvider(this.getPropertyString(KW_ROW_CACHE_PROVIDER, "org.apache.cassandra.cache.ConcurrentLinkedHashCacheProvider"))).keyAlias(this.keyAlias);
        }
        catch (ConfigurationException e) {
            throw new InvalidRequestException(e.toString());
        }
        return newCFMD;
    }

    private String getPropertyString(String key, String defaultValue) {
        String value = this.properties.get(key);
        return value != null ? value : defaultValue;
    }

    private Boolean getPropertyBoolean(String key, Boolean defaultValue) throws InvalidRequestException {
        String value = this.properties.get(key);
        return value == null ? defaultValue.booleanValue() : value.toLowerCase().matches("(1|true|yes)");
    }

    private Double getPropertyDouble(String key, Double defaultValue) throws InvalidRequestException {
        Double result;
        String value = this.properties.get(key);
        if (value == null) {
            result = defaultValue;
        } else {
            try {
                result = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidRequestException(String.format("%s not valid for \"%s\"", value, key));
            }
        }
        return result;
    }

    private Integer getPropertyInt(String key, Integer defaultValue) throws InvalidRequestException {
        Integer result;
        String value = this.properties.get(key);
        if (value == null) {
            result = defaultValue;
        } else {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidRequestException(String.format("%s not valid for \"%s\"", value, key));
            }
        }
        return result;
    }

    static {
        comparators.put("bytea", "BytesType");
        comparators.put("ascii", "AsciiType");
        comparators.put("text", "UTF8Type");
        comparators.put("varchar", "UTF8Type");
        comparators.put("varint", "IntegerType");
        comparators.put("int", "LongType");
        comparators.put("bigint", "LongType");
        comparators.put("uuid", "UUIDType");
        comparators.put("counter", "CounterColumnType");
        comparators.put("boolean", "BooleanType");
        comparators.put("date", "DateType");
        comparators.put("float", "FloatType");
        comparators.put("double", "DoubleType");
        keywords.add(KW_COMPARATOR);
        keywords.add(KW_COMMENT);
        keywords.add(KW_ROWCACHESIZE);
        keywords.add(KW_KEYCACHESIZE);
        keywords.add(KW_READREPAIRCHANCE);
        keywords.add(KW_GCGRACESECONDS);
        keywords.add(KW_DEFAULTVALIDATION);
        keywords.add(KW_MINCOMPACTIONTHRESHOLD);
        keywords.add(KW_MAXCOMPACTIONTHRESHOLD);
        keywords.add(KW_ROWCACHESAVEPERIODSECS);
        keywords.add(KW_KEYCACHESAVEPERIODSECS);
        keywords.add(KW_MEMTABLEFLUSHINMINS);
        keywords.add(KW_MEMTABLESIZEINMB);
        keywords.add(KW_MEMTABLEOPSINMILLIONS);
        keywords.add(KW_REPLICATEONWRITE);
        keywords.add(KW_ROW_CACHE_PROVIDER);
    }
}

