/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.client;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.TBinaryProtocol;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RingCache {
    private static final Logger logger_ = LoggerFactory.getLogger(RingCache.class);
    private final Set<String> seeds_ = new HashSet<String>();
    private final int port_;
    private final IPartitioner<?> partitioner_;
    private final String keyspace;
    private Multimap<Range, InetAddress> rangeMap;

    public RingCache(String keyspace, IPartitioner<?> partitioner, String addresses, int port) throws IOException {
        for (String seed : addresses.split(",")) {
            this.seeds_.add(seed);
        }
        this.port_ = port;
        this.keyspace = keyspace;
        this.partitioner_ = partitioner;
        this.refreshEndpointMap();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refreshEndpointMap() {
        for (String seed : this.seeds_) {
            try {
                TSocket socket = new TSocket(seed, this.port_);
                TBinaryProtocol binaryProtocol = new TBinaryProtocol((TTransport)new TFramedTransport((TTransport)socket));
                Cassandra.Client client = new Cassandra.Client((TProtocol)binaryProtocol);
                socket.open();
                List ring = client.describe_ring(this.keyspace);
                this.rangeMap = ArrayListMultimap.create();
                for (TokenRange range : ring) {
                    Token left = this.partitioner_.getTokenFactory().fromString(range.start_token);
                    Token right = this.partitioner_.getTokenFactory().fromString(range.end_token);
                    Range r = new Range(left, right, this.partitioner_);
                    for (String host : range.endpoints) {
                        try {
                            this.rangeMap.put((Object)r, (Object)InetAddress.getByName(host));
                        }
                        catch (UnknownHostException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                    continue;
                    return;
                }
            }
            catch (InvalidRequestException e) {
                throw new RuntimeException(e);
            }
            catch (TException e) {
                logger_.debug("Error contacting seed " + seed + " " + e.getMessage());
            }
        }
    }

    public List<InetAddress> getEndpoint(Range range) {
        return (List)this.rangeMap.get((Object)range);
    }

    public List<InetAddress> getEndpoint(ByteBuffer key) {
        return this.getEndpoint(this.getRange(key));
    }

    public Range getRange(ByteBuffer key) {
        Object t = this.partitioner_.getToken(key);
        for (Range range : this.rangeMap.keySet()) {
            if (!range.contains((Token)t)) continue;
            return range;
        }
        throw new RuntimeException("Invalid token information returned by describe_ring: " + this.rangeMap);
    }
}

