/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.migration.avro.ColumnDef;
import org.apache.cassandra.db.migration.avro.IndexType;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ColumnDefinition {
    public static final String D_COLDEF_INDEXTYPE = "KEYS";
    public static final String D_COLDEF_INDEXNAME = null;
    public final ByteBuffer name;
    private AbstractType validator;
    private org.apache.cassandra.thrift.IndexType index_type;
    private String index_name;

    public ColumnDefinition(ByteBuffer name, AbstractType validator, org.apache.cassandra.thrift.IndexType index_type, String index_name) {
        this.name = name;
        this.index_type = index_type;
        this.index_name = index_name;
        this.validator = validator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnDefinition that = (ColumnDefinition)o;
        if (this.index_name != null ? !this.index_name.equals(that.index_name) : that.index_name != null) {
            return false;
        }
        if (this.index_type != null ? !this.index_type.equals((Object)that.index_type) : that.index_type != null) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return !(this.validator == null ? that.validator != null : !this.validator.equals(that.validator));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.validator != null ? this.validator.hashCode() : 0);
        result = 31 * result + (this.index_type != null ? this.index_type.hashCode() : 0);
        result = 31 * result + (this.index_name != null ? this.index_name.hashCode() : 0);
        return result;
    }

    public ColumnDef deflate() {
        ColumnDef cd = new ColumnDef();
        cd.name = this.name;
        cd.validation_class = new Utf8(this.validator.getClass().getName());
        cd.index_type = this.index_type == null ? null : Enum.valueOf(IndexType.class, this.index_type.name());
        cd.index_name = this.index_name == null ? null : new Utf8(this.index_name);
        return cd;
    }

    public static ColumnDefinition inflate(ColumnDef cd) {
        org.apache.cassandra.thrift.IndexType index_type = cd.index_type == null ? null : Enum.valueOf(org.apache.cassandra.thrift.IndexType.class, cd.index_type.name());
        String index_name = cd.index_name == null ? null : ((Object)cd.index_name).toString();
        try {
            AbstractType validatorType = DatabaseDescriptor.getComparator(cd.validation_class);
            return new ColumnDefinition(cd.name, validatorType, index_type, index_name);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static ColumnDefinition fromColumnDef(org.apache.cassandra.thrift.ColumnDef thriftColumnDef) throws ConfigurationException {
        AbstractType validatorType = DatabaseDescriptor.getComparator(thriftColumnDef.validation_class);
        return new ColumnDefinition(ByteBufferUtil.clone(thriftColumnDef.name), validatorType, thriftColumnDef.index_type, thriftColumnDef.index_name);
    }

    public static ColumnDefinition fromColumnDef(ColumnDef avroColumnDef) throws ConfigurationException {
        ColumnDefinition.validateIndexType(avroColumnDef);
        AbstractType validatorType = DatabaseDescriptor.getComparator(avroColumnDef.validation_class);
        return new ColumnDefinition(avroColumnDef.name, validatorType, org.apache.cassandra.thrift.IndexType.valueOf((String)(avroColumnDef.index_type == null ? D_COLDEF_INDEXTYPE : avroColumnDef.index_type.name())), avroColumnDef.index_name == null ? D_COLDEF_INDEXNAME : ((Object)avroColumnDef.index_name).toString());
    }

    public static Map<ByteBuffer, ColumnDefinition> fromColumnDef(List<org.apache.cassandra.thrift.ColumnDef> thriftDefs) throws ConfigurationException {
        if (thriftDefs == null) {
            return new HashMap<ByteBuffer, ColumnDefinition>();
        }
        TreeMap<ByteBuffer, ColumnDefinition> cds = new TreeMap<ByteBuffer, ColumnDefinition>();
        for (org.apache.cassandra.thrift.ColumnDef thriftColumnDef : thriftDefs) {
            cds.put(ByteBufferUtil.clone(thriftColumnDef.name), ColumnDefinition.fromColumnDef(thriftColumnDef));
        }
        return cds;
    }

    public static void validateIndexType(ColumnDef avroColumnDef) throws ConfigurationException {
        if (avroColumnDef.index_name != null && avroColumnDef.index_type == null) {
            throw new ConfigurationException("index_name cannot be set if index_type is not also set");
        }
    }

    public String toString() {
        return "ColumnDefinition{name=" + ByteBufferUtil.bytesToHex(this.name) + ", validator=" + this.validator + ", index_type=" + this.index_type + ", index_name='" + this.index_name + '\'' + '}';
    }

    public String getIndexName() {
        return this.index_name;
    }

    public void setIndexName(String s) {
        this.index_name = s;
    }

    public org.apache.cassandra.thrift.IndexType getIndexType() {
        return this.index_type;
    }

    public void setIndexType(org.apache.cassandra.thrift.IndexType index_type) {
        this.index_type = index_type;
    }

    public AbstractType getValidator() {
        return this.validator;
    }

    public void setValidator(AbstractType validator) {
        this.validator = validator;
    }
}

