/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.streaming.OperationType;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang.StringUtils;

public class PendingFile {
    private static PendingFileSerializer serializer_ = new PendingFileSerializer();
    private final SSTable sstable;
    public final Descriptor desc;
    public final String component;
    public final List<Pair<Long, Long>> sections;
    public final OperationType type;
    public final long size;
    public long progress;

    public static PendingFileSerializer serializer() {
        return serializer_;
    }

    public PendingFile(Descriptor desc, PendingFile pf) {
        this(null, desc, pf.component, pf.sections, pf.type);
    }

    public PendingFile(SSTable sstable, Descriptor desc, String component, List<Pair<Long, Long>> sections, OperationType type) {
        this.sstable = sstable;
        this.desc = desc;
        this.component = component;
        this.sections = sections;
        this.type = type;
        long tempSize = 0L;
        for (Pair<Long, Long> section : sections) {
            tempSize += (Long)section.right - (Long)section.left;
        }
        this.size = tempSize;
    }

    public String getFilename() {
        return this.desc.filenameFor(this.component);
    }

    public boolean equals(Object o) {
        if (!(o instanceof PendingFile)) {
            return false;
        }
        PendingFile rhs = (PendingFile)o;
        return this.getFilename().equals(rhs.getFilename());
    }

    public int hashCode() {
        return this.getFilename().hashCode();
    }

    public String toString() {
        return this.getFilename() + "/" + StringUtils.join(this.sections, (String)",") + "\n\t progress=" + this.progress + "/" + this.size + " - " + this.progress * 100L / this.size + "%";
    }

    public static class PendingFileSerializer
    implements ICompactSerializer<PendingFile> {
        @Override
        public void serialize(PendingFile sc, DataOutputStream dos, int version) throws IOException {
            if (sc == null) {
                dos.writeUTF("");
                return;
            }
            dos.writeUTF(sc.desc.filenameFor(sc.component));
            dos.writeUTF(sc.component);
            dos.writeInt(sc.sections.size());
            for (Pair<Long, Long> section : sc.sections) {
                dos.writeLong((Long)section.left);
                dos.writeLong((Long)section.right);
            }
            if (version > 1) {
                dos.writeUTF(sc.type.name());
            }
        }

        @Override
        public PendingFile deserialize(DataInputStream dis, int version) throws IOException {
            String filename = dis.readUTF();
            if (filename.isEmpty()) {
                return null;
            }
            Descriptor desc = Descriptor.fromFilename(filename);
            String component = dis.readUTF();
            int count = dis.readInt();
            ArrayList<Pair<Long, Long>> sections = new ArrayList<Pair<Long, Long>>(count);
            for (int i = 0; i < count; ++i) {
                sections.add(new Pair<Long, Long>(dis.readLong(), dis.readLong()));
            }
            OperationType type = OperationType.RESTORE_REPLICA_COUNT;
            if (version > 1) {
                type = OperationType.valueOf(dis.readUTF());
            }
            return new PendingFile(null, desc, component, sections, type);
        }
    }
}

