/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class UTF8Type
extends AbstractType<String> {
    public static final UTF8Type instance = new UTF8Type();

    UTF8Type() {
    }

    @Override
    public String compose(ByteBuffer bytes) {
        return this.getString(bytes);
    }

    @Override
    public ByteBuffer decompose(String value) {
        return ByteBufferUtil.bytes(value, Charsets.UTF_8);
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return BytesType.bytesCompare(o1, o2);
    }

    @Override
    public String getString(ByteBuffer bytes) {
        try {
            return ByteBufferUtil.string(bytes);
        }
        catch (CharacterCodingException e) {
            throw new MarshalException("invalid UTF8 bytes " + ByteBufferUtil.bytesToHex(bytes));
        }
    }

    @Override
    public String toString(String s) {
        return s;
    }

    @Override
    public ByteBuffer fromString(String source) {
        return this.decompose(source);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        if (!UTF8Validator.validate(bytes.slice())) {
            throw new MarshalException("String didn't validate.");
        }
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }

    static class UTF8Validator {
        UTF8Validator() {
        }

        static boolean validate(ByteBuffer buf) {
            byte b = 0;
            State state = State.START;
            block10: while (buf.remaining() > 0) {
                b = buf.get();
                switch (state) {
                    case START: {
                        if (b >= 0) {
                            if (b <= 127) continue block10;
                            return false;
                        }
                        if (b >> 5 == -2) {
                            if (b == -64) {
                                state = State.TWO_80;
                            } else if ((b & 0x1E) == 0) {
                                return false;
                            }
                            state = State.TWO;
                            continue block10;
                        }
                        if (b >> 4 == -2) {
                            if (b == -32) {
                                state = State.THREE_a0bf;
                                continue block10;
                            }
                            state = State.THREE_80bf_2;
                            continue block10;
                        }
                        if (b >> 3 == -2) {
                            if (b == -16) {
                                state = State.FOUR_90bf;
                                continue block10;
                            }
                            if (b == -12) {
                                state = State.FOUR_80bf_3;
                                continue block10;
                            }
                            state = State.FOUR_80bf_3;
                            continue block10;
                        }
                        return false;
                    }
                    case TWO: {
                        if ((b & 0xC0) != 128) {
                            return false;
                        }
                        state = State.START;
                        continue block10;
                    }
                    case TWO_80: {
                        if (b != -128) {
                            return false;
                        }
                        state = State.START;
                        continue block10;
                    }
                    case THREE_a0bf: {
                        if ((b & 0xE0) == 128) {
                            return false;
                        }
                        state = State.THREE_80bf_1;
                        continue block10;
                    }
                    case THREE_80bf_1: {
                        if ((b & 0xC0) != 128) {
                            return false;
                        }
                        state = State.START;
                        continue block10;
                    }
                    case THREE_80bf_2: {
                        if ((b & 0xC0) != 128) {
                            return false;
                        }
                        state = State.THREE_80bf_1;
                        continue block10;
                    }
                    case FOUR_90bf: {
                        if ((b & 0x30) == 0) {
                            return false;
                        }
                        state = State.THREE_80bf_2;
                        continue block10;
                    }
                    case FOUR_80bf_3: {
                        if ((b & 0xC0) != 128) {
                            return false;
                        }
                        state = State.THREE_80bf_2;
                        continue block10;
                    }
                }
                return false;
            }
            return state == State.START;
        }

        static enum State {
            START,
            TWO,
            TWO_80,
            THREE_a0bf,
            THREE_80bf_1,
            THREE_80bf_2,
            FOUR_90bf,
            FOUR_80bf_3;

        }
    }
}

